/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.smstpdu;

import org.mobicents.protocols.ss7.map.api.smstpdu.CharacterSet;
import org.mobicents.protocols.ss7.map.api.smstpdu.DataCodingGroup;
import org.mobicents.protocols.ss7.map.api.smstpdu.DataCodingSchemaIndicationType;
import org.mobicents.protocols.ss7.map.api.smstpdu.DataCodingSchemaMessageClass;
import org.mobicents.protocols.ss7.map.api.smstpdu.DataCodingScheme;

public class DataCodingSchemeImpl
implements DataCodingScheme {
    private int code;

    public DataCodingSchemeImpl(int code) {
        this.code = code;
    }

    public DataCodingSchemeImpl(DataCodingGroup dataCodingGroup, DataCodingSchemaMessageClass messageClass, DataCodingSchemaIndicationType dataCodingSchemaIndicationType, Boolean setIndicationActive, CharacterSet characterSet, boolean isCompressed) {
        if (dataCodingGroup == null) {
            return;
        }
        switch (dataCodingGroup) {
            case GeneralGroup: 
            case MessageMarkedForAutomaticDeletionGroup: {
                this.code = (dataCodingGroup == DataCodingGroup.MessageMarkedForAutomaticDeletionGroup ? 64 : 0) | (isCompressed ? 32 : 0) | (messageClass != null ? 0x10 | messageClass.getCode() : 0) | (characterSet != null ? characterSet.getCode() << 2 : 0);
                break;
            }
            case MessageWaitingIndicationGroupDiscardMessage: 
            case MessageWaitingIndicationGroupStoreMessage: {
                int i1 = dataCodingGroup == DataCodingGroup.MessageWaitingIndicationGroupDiscardMessage ? 192 : (characterSet != null && characterSet == CharacterSet.UCS2 ? 224 : 208);
                this.code = i1 | (setIndicationActive != false ? 8 : 0) | (dataCodingSchemaIndicationType != null ? dataCodingSchemaIndicationType.getCode() : 0);
                break;
            }
            case DataCodingMessageClass: {
                this.code = 0xF0 | (characterSet == CharacterSet.GSM8 ? 4 : 0) | (messageClass != null ? messageClass.getCode() : 0);
            }
        }
    }

    public int getCode() {
        return this.code;
    }

    public DataCodingGroup getDataCodingGroup() {
        switch ((this.code & 0xC0) >> 6) {
            case 0: {
                return DataCodingGroup.GeneralGroup;
            }
            case 1: {
                return DataCodingGroup.MessageMarkedForAutomaticDeletionGroup;
            }
            case 2: {
                return DataCodingGroup.Reserved;
            }
        }
        switch ((this.code & 0x30) >> 4) {
            case 0: {
                return DataCodingGroup.MessageWaitingIndicationGroupDiscardMessage;
            }
            case 1: 
            case 2: {
                return DataCodingGroup.MessageWaitingIndicationGroupStoreMessage;
            }
        }
        return DataCodingGroup.DataCodingMessageClass;
    }

    public DataCodingSchemaMessageClass getMessageClass() {
        DataCodingGroup dcg = this.getDataCodingGroup();
        switch (dcg) {
            case GeneralGroup: 
            case MessageMarkedForAutomaticDeletionGroup: {
                if ((this.code & 0x10) != 0) {
                    return DataCodingSchemaMessageClass.getInstance((int)(this.code & 3));
                }
                return null;
            }
            case DataCodingMessageClass: {
                return DataCodingSchemaMessageClass.getInstance((int)(this.code & 3));
            }
        }
        return null;
    }

    public DataCodingSchemaIndicationType getDataCodingSchemaIndicationType() {
        DataCodingGroup dcg = this.getDataCodingGroup();
        switch (dcg) {
            case MessageWaitingIndicationGroupDiscardMessage: 
            case MessageWaitingIndicationGroupStoreMessage: {
                return DataCodingSchemaIndicationType.getInstance((int)(this.code & 3));
            }
        }
        return null;
    }

    public Boolean getSetIndicationActive() {
        DataCodingGroup dcg = this.getDataCodingGroup();
        switch (dcg) {
            case MessageWaitingIndicationGroupDiscardMessage: 
            case MessageWaitingIndicationGroupStoreMessage: {
                if ((this.code & 8) != 0) {
                    return true;
                }
                return false;
            }
        }
        return null;
    }

    public CharacterSet getCharacterSet() {
        int cg1 = (this.code & 0xC0) >> 6;
        switch (cg1) {
            case 0: 
            case 1: {
                int cs = (this.code & 0xC) >> 2;
                return CharacterSet.getInstance((int)cs);
            }
            case 3: {
                int cg2 = (this.code & 0x30) >> 4;
                switch (cg2) {
                    case 0: 
                    case 1: {
                        return CharacterSet.GSM7;
                    }
                    case 2: {
                        return CharacterSet.UCS2;
                    }
                }
                if ((this.code & 4) == 0) {
                    return CharacterSet.GSM7;
                }
                return CharacterSet.GSM8;
            }
        }
        return CharacterSet.Reserved;
    }

    public boolean getIsCompressed() {
        return ((this.code & 0xC0) == 0 || (this.code & 0xC0) == 64) && (this.code & 0x20) != 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TP-Data-Coding-Scheme [");
        sb.append("Code=");
        sb.append(this.code);
        sb.append(", DataCodingGroup=");
        sb.append(this.getDataCodingGroup());
        if (this.getMessageClass() != null) {
            sb.append(", MessageClass=");
            sb.append(this.getMessageClass());
        }
        if (this.getDataCodingSchemaIndicationType() != null) {
            sb.append(", IndicationType=");
            sb.append(this.getDataCodingSchemaIndicationType());
        }
        if (this.getSetIndicationActive() != null) {
            sb.append(", SetIndicationActive=");
            sb.append(this.getSetIndicationActive());
        }
        sb.append(", CharacterSet=");
        sb.append(this.getCharacterSet());
        if (this.getIsCompressed()) {
            sb.append(", Compressed");
        }
        sb.append("]");
        return sb.toString();
    }
}

