/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.supplementary;

import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.service.supplementary.CallBarringFeature;
import org.mobicents.protocols.ss7.map.api.service.supplementary.CallBarringInfo;
import org.mobicents.protocols.ss7.map.api.service.supplementary.SSCode;
import org.mobicents.protocols.ss7.map.primitives.SequenceBase;
import org.mobicents.protocols.ss7.map.service.supplementary.CallBarringFeatureImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.SSCodeImpl;

public class CallBarringInfoImpl
extends SequenceBase
implements CallBarringInfo {
    private SSCode ssCode;
    private ArrayList<CallBarringFeature> callBarringFeatureList;

    public CallBarringInfoImpl() {
        super("CallBarringInfo");
    }

    public CallBarringInfoImpl(SSCode ssCode, ArrayList<CallBarringFeature> callBarringFeatureList) {
        super("CallBarringInfo");
        this.ssCode = ssCode;
        this.callBarringFeatureList = callBarringFeatureList;
    }

    public SSCode getSsCode() {
        return this.ssCode;
    }

    public ArrayList<CallBarringFeature> getCallBarringFeatureList() {
        return this.callBarringFeatureList;
    }

    @Override
    protected void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.ssCode = null;
        this.callBarringFeatureList = null;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        block4: while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 0) {
                switch (tag) {
                    case 4: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + " ssCode: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.ssCode = new SSCodeImpl();
                        ((SSCodeImpl)this.ssCode).decodeAll(ais);
                        break;
                    }
                    case 16: {
                        if (ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".callBarringFeatureList: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        AsnInputStream ais2 = ais.readSequenceStream();
                        this.callBarringFeatureList = new ArrayList();
                        while (ais2.available() != 0) {
                            ais2.readTag();
                            CallBarringFeatureImpl callBarringFeature = new CallBarringFeatureImpl();
                            callBarringFeature.decodeAll(ais2);
                            this.callBarringFeatureList.add(callBarringFeature);
                        }
                        if (this.callBarringFeatureList.size() >= 1 && this.callBarringFeatureList.size() <= 13) continue block4;
                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter forwardingFeatureList size must be from 1 to 13, found: " + this.callBarringFeatureList.size(), MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    default: {
                        ais.advanceElement();
                        break;
                    }
                }
                continue;
            }
            ais.advanceElement();
        }
        if (this.callBarringFeatureList == null) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": callBarringFeatureList parameter is mandatory but has not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.callBarringFeatureList == null) {
            throw new MAPException("callBarringFeatureList parameter must not be null");
        }
        if (this.ssCode != null) {
            ((SSCodeImpl)this.ssCode).encodeAll(asnOs);
        }
        try {
            asnOs.writeTag(0, false, 16);
            int pos = asnOs.StartContentDefiniteLength();
            for (CallBarringFeature item : this.callBarringFeatureList) {
                ((CallBarringFeatureImpl)item).encodeAll(asnOs);
            }
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ".callBarringFeatureList: " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        if (this.ssCode != null) {
            sb.append("ssCode=");
            sb.append(this.ssCode);
        }
        if (this.callBarringFeatureList != null) {
            sb.append("callBarringFeatureList=[");
            boolean firstItem = true;
            for (CallBarringFeature be : this.callBarringFeatureList) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    sb.append(", ");
                }
                sb.append(be.toString());
            }
            sb.append("], ");
        }
        sb.append("]");
        return sb.toString();
    }
}

