/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.locationManagement;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPMessageType;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.primitives.LAIFixedLength;
import org.mobicents.protocols.ss7.map.api.primitives.LMSI;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.primitives.TMSI;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.SendIdentificationRequest;
import org.mobicents.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.mobicents.protocols.ss7.map.primitives.LAIFixedLengthImpl;
import org.mobicents.protocols.ss7.map.primitives.LMSIImpl;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.primitives.TMSIImpl;
import org.mobicents.protocols.ss7.map.service.mobility.MobilityMessageImpl;

public class SendIdentificationRequestImpl
extends MobilityMessageImpl
implements SendIdentificationRequest {
    protected static final int _TAG_previousLAI = 0;
    protected static final int _TAG_hopCounter = 1;
    protected static final int _TAG_mtRoamingForwardingSupported = 2;
    protected static final int _TAG_newVLRNumber = 3;
    protected static final int _TAG_newLmsi = 4;
    public static final String _PrimitiveName = "SendIdentificationRequest";
    private TMSI tmsi;
    private Integer numberOfRequestedVectors;
    private boolean segmentationProhibited;
    private MAPExtensionContainer extensionContainer;
    private ISDNAddressString mscNumber;
    private LAIFixedLength previousLAI;
    private Integer hopCounter;
    private boolean mtRoamingForwardingSupported;
    private ISDNAddressString newVLRNumber;
    private LMSI newLmsi;
    private long mapProtocolVersion;

    public SendIdentificationRequestImpl(long mapProtocolVersion) {
        this.mapProtocolVersion = mapProtocolVersion;
    }

    public SendIdentificationRequestImpl(TMSI tmsi, Integer numberOfRequestedVectors, boolean segmentationProhibited, MAPExtensionContainer extensionContainer, ISDNAddressString mscNumber, LAIFixedLength previousLAI, Integer hopCounter, boolean mtRoamingForwardingSupported, ISDNAddressString newVLRNumber, LMSI newLmsi, long mapProtocolVersion) {
        this.tmsi = tmsi;
        this.numberOfRequestedVectors = numberOfRequestedVectors;
        this.segmentationProhibited = segmentationProhibited;
        this.extensionContainer = extensionContainer;
        this.mscNumber = mscNumber;
        this.previousLAI = previousLAI;
        this.hopCounter = hopCounter;
        this.mtRoamingForwardingSupported = mtRoamingForwardingSupported;
        this.newVLRNumber = newVLRNumber;
        this.newLmsi = newLmsi;
        this.mapProtocolVersion = mapProtocolVersion;
    }

    public SendIdentificationRequestImpl(TMSI tmsi, long mapProtocolVersion) {
        this.tmsi = tmsi;
        this.mapProtocolVersion = mapProtocolVersion;
    }

    public MAPMessageType getMessageType() {
        return MAPMessageType.sendIdentification_Request;
    }

    public int getOperationCode() {
        return 55;
    }

    public TMSI getTmsi() {
        return this.tmsi;
    }

    public Integer getNumberOfRequestedVectors() {
        return this.numberOfRequestedVectors;
    }

    public boolean getSegmentationProhibited() {
        return this.segmentationProhibited;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public ISDNAddressString getMscNumber() {
        return this.mscNumber;
    }

    public LAIFixedLength getPreviousLAI() {
        return this.previousLAI;
    }

    public Integer getHopCounter() {
        return this.hopCounter;
    }

    public boolean getMtRoamingForwardingSupported() {
        return this.mtRoamingForwardingSupported;
    }

    public ISDNAddressString getNewVLRNumber() {
        return this.newVLRNumber;
    }

    public LMSI getNewLmsi() {
        return this.newLmsi;
    }

    public long getMapProtocolVersion() {
        return this.mapProtocolVersion;
    }

    @Override
    public int getTag() throws MAPException {
        if (this.mapProtocolVersion >= 3L) {
            return 16;
        }
        return 4;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return this.mapProtocolVersion < 3L;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SendIdentificationRequest: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SendIdentificationRequest: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SendIdentificationRequest: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SendIdentificationRequest: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.tmsi = null;
        this.numberOfRequestedVectors = null;
        this.segmentationProhibited = false;
        this.extensionContainer = null;
        this.mscNumber = null;
        this.previousLAI = null;
        this.hopCounter = null;
        this.mtRoamingForwardingSupported = false;
        this.newVLRNumber = null;
        this.newLmsi = null;
        if (this.mapProtocolVersion >= 3L) {
            AsnInputStream ais = ansIS.readSequenceStreamData(length);
            int num = 0;
            while (ais.available() != 0) {
                int tag = ais.readTag();
                if (num == 0) {
                    if (tag != 4 || ais.getTagClass() != 0 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding SendIdentificationRequest.tmsi: Parameter 0 bad tag or tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.tmsi = new TMSIImpl();
                    ((TMSIImpl)this.tmsi).decodeAll(ais);
                } else {
                    block0 : switch (ais.getTagClass()) {
                        case 0: {
                            switch (tag) {
                                case 2: {
                                    if (!ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding SendIdentificationRequest.numberOfRequestedVectors: is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    this.numberOfRequestedVectors = (int)ais.readInteger();
                                    break block0;
                                }
                                case 5: {
                                    if (!ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding SendIdentificationRequest.segmentationProhibited: is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    ais.readNull();
                                    this.segmentationProhibited = true;
                                    break block0;
                                }
                                case 16: {
                                    if (ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding SendIdentificationRequest.extensionContainer: is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    this.extensionContainer = new MAPExtensionContainerImpl();
                                    ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                                    break block0;
                                }
                                case 4: {
                                    if (!ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding SendIdentificationRequest.mscNumber: is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    this.mscNumber = new ISDNAddressStringImpl();
                                    ((ISDNAddressStringImpl)this.mscNumber).decodeAll(ais);
                                    break block0;
                                }
                            }
                            ais.advanceElement();
                            break;
                        }
                        case 2: {
                            switch (tag) {
                                case 0: {
                                    if (!ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding SendIdentificationRequest.previousLAI: is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    this.previousLAI = new LAIFixedLengthImpl();
                                    ((LAIFixedLengthImpl)this.previousLAI).decodeAll(ais);
                                    break block0;
                                }
                                case 1: {
                                    if (!ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding SendIdentificationRequest.hopCounter: is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    this.hopCounter = (int)ais.readInteger();
                                    break block0;
                                }
                                case 2: {
                                    if (!ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding SendIdentificationRequest.mtRoamingForwardingSupported: is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    ais.readNull();
                                    this.mtRoamingForwardingSupported = true;
                                    break block0;
                                }
                                case 3: {
                                    if (!ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding SendIdentificationRequest.newVLRNumber: is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    this.newVLRNumber = new ISDNAddressStringImpl();
                                    ((ISDNAddressStringImpl)this.newVLRNumber).decodeAll(ais);
                                    break block0;
                                }
                                case 4: {
                                    if (!ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding SendIdentificationRequest.newLmsi: is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    this.newLmsi = new LMSIImpl();
                                    ((LMSIImpl)this.newLmsi).decodeAll(ais);
                                    break block0;
                                }
                            }
                            ais.advanceElement();
                            break;
                        }
                        default: {
                            ais.advanceElement();
                        }
                    }
                }
                ++num;
            }
            if (num < 1) {
                throw new MAPParsingComponentException("Error while decoding SendIdentificationRequest: Needs at least 1 mandatory parameters, found " + num, MAPParsingComponentExceptionReason.MistypedParameter);
            }
        } else {
            int tag = ansIS.getTag();
            if (tag != 4 || ansIS.getTagClass() != 0 || !ansIS.isTagPrimitive()) {
                throw new MAPParsingComponentException("Error while decoding SendIdentificationRequest.tmsi: Parameter 0 bad tag or tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
            }
            this.tmsi = new TMSIImpl();
            ((TMSIImpl)this.tmsi).decodeData(ansIS, length);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding SendIdentificationRequest: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.tmsi == null) {
            throw new MAPException("Error while encoding SendIdentificationRequest the mandatory parameter tmsi is not defined");
        }
        try {
            if (this.mapProtocolVersion >= 3L) {
                ((TMSIImpl)this.tmsi).encodeAll(asnOs);
                if (this.numberOfRequestedVectors != null) {
                    asnOs.writeInteger((long)this.numberOfRequestedVectors.intValue());
                }
                if (this.segmentationProhibited) {
                    asnOs.writeNull();
                }
                if (this.extensionContainer != null) {
                    ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs);
                }
                if (this.mscNumber != null) {
                    ((ISDNAddressStringImpl)this.mscNumber).encodeAll(asnOs);
                }
                if (this.previousLAI != null) {
                    ((LAIFixedLengthImpl)this.previousLAI).encodeAll(asnOs, 2, 0);
                }
                if (this.hopCounter != null) {
                    asnOs.writeInteger(2, 1, (long)this.hopCounter.intValue());
                }
                if (this.mtRoamingForwardingSupported) {
                    asnOs.writeNull(2, 2);
                }
                if (this.newVLRNumber != null) {
                    ((ISDNAddressStringImpl)this.newVLRNumber).encodeAll(asnOs, 2, 3);
                }
                if (this.newLmsi != null) {
                    ((LMSIImpl)this.newLmsi).encodeAll(asnOs, 2, 4);
                }
            } else {
                ((TMSIImpl)this.tmsi).encodeData(asnOs);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding SendIdentificationRequest: " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding SendIdentificationRequest: " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.tmsi != null) {
            sb.append("tmsi=");
            sb.append(this.tmsi.toString());
            sb.append(", ");
        }
        if (this.numberOfRequestedVectors != null) {
            sb.append("numberOfRequestedVectors=");
            sb.append(this.numberOfRequestedVectors.toString());
            sb.append(", ");
        }
        if (this.segmentationProhibited) {
            sb.append("segmentationProhibited, ");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer.toString());
            sb.append(", ");
        }
        if (this.mscNumber != null) {
            sb.append("mscNumber=");
            sb.append(this.mscNumber.toString());
            sb.append(", ");
        }
        if (this.previousLAI != null) {
            sb.append("previousLAI=");
            sb.append(this.previousLAI.toString());
            sb.append(", ");
        }
        if (this.hopCounter != null) {
            sb.append("hopCounter=");
            sb.append(this.hopCounter.toString());
            sb.append(", ");
        }
        if (this.mtRoamingForwardingSupported) {
            sb.append("mtRoamingForwardingSupported, ");
        }
        if (this.newVLRNumber != null) {
            sb.append("newVLRNumber=");
            sb.append(this.newVLRNumber.toString());
            sb.append(", ");
        }
        if (this.newLmsi != null) {
            sb.append("lmsi=");
            sb.append(this.newLmsi.toString());
            sb.append(", ");
        }
        sb.append("mapProtocolVersion=");
        sb.append(this.mapProtocolVersion);
        sb.append("]");
        return sb.toString();
    }
}

