/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.lsm;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPMessageType;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.lsm.SubscriberLocationReportResponse;
import org.mobicents.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.service.lsm.LsmMessageImpl;

public class SubscriberLocationReportResponseImpl
extends LsmMessageImpl
implements SubscriberLocationReportResponse {
    private static final int _TAG_NA_ESRK = 0;
    private static final int _TAG_NA_ESRD = 1;
    public static final String _PrimitiveName = "SubscriberLocationReportResponse";
    private ISDNAddressString naEsrd;
    private ISDNAddressString naEsrk;
    private MAPExtensionContainer extensionContainer;

    public SubscriberLocationReportResponseImpl() {
    }

    public SubscriberLocationReportResponseImpl(ISDNAddressString naEsrd, ISDNAddressString naEsrk, MAPExtensionContainer extensionContainer) {
        this.naEsrd = naEsrd;
        this.naEsrk = naEsrk;
        this.extensionContainer = extensionContainer;
    }

    public MAPMessageType getMessageType() {
        return MAPMessageType.subscriberLocationReport_Response;
    }

    public int getOperationCode() {
        return 86;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public ISDNAddressString getNaESRK() {
        return this.naEsrk;
    }

    public ISDNAddressString getNaESRD() {
        return this.naEsrd;
    }

    @Override
    public int getTag() throws MAPException {
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SubscriberLocationReportResponse: ", (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SubscriberLocationReportResponse: ", (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SubscriberLocationReportResponse: ", (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SubscriberLocationReportResponse: ", (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.naEsrd = null;
        this.naEsrk = null;
        this.extensionContainer = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        block7: while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 0) {
                switch (tag) {
                    case 16: {
                        if (ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding SubscriberLocationReportResponse: Parameter extensionContainer is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.extensionContainer = new MAPExtensionContainerImpl();
                        ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                        continue block7;
                    }
                }
                ais.advanceElement();
                continue;
            }
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding SubscriberLocationReportResponse: Parameter [na-ESRK [0] ISDN-AddressString] is not Sequence", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.naEsrk = new ISDNAddressStringImpl();
                        ((ISDNAddressStringImpl)this.naEsrk).decodeAll(ais);
                        continue block7;
                    }
                    case 1: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding SubscriberLocationReportResponse: Parameter [na-ESRD [1] ISDN-AddressString] is not Sequence", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.naEsrd = new ISDNAddressStringImpl();
                        ((ISDNAddressStringImpl)this.naEsrd).decodeAll(ais);
                        continue block7;
                    }
                }
                ais.advanceElement();
                continue;
            }
            ais.advanceElement();
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, false, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding SubscriberLocationReportResponse: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.extensionContainer != null) {
            ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs);
        }
        if (this.naEsrk != null) {
            ((ISDNAddressStringImpl)this.naEsrk).encodeAll(asnOs, 2, 0);
        }
        if (this.naEsrd != null) {
            ((ISDNAddressStringImpl)this.naEsrd).encodeAll(asnOs, 2, 1);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.extensionContainer != null) {
            sb.append("extensionContainer");
            sb.append(this.extensionContainer);
        }
        if (this.naEsrd != null) {
            sb.append(", naEsrd=");
            sb.append(this.naEsrd);
        }
        if (this.naEsrk != null) {
            sb.append(", naEsrk=");
            sb.append(this.naEsrk);
        }
        sb.append("]");
        return sb.toString();
    }
}

