/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.lsm;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.DiameterIdentity;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.primitives.LMSI;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.lsm.AdditionalNumber;
import org.mobicents.protocols.ss7.map.api.service.lsm.LCSLocationInfo;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.SupportedLCSCapabilitySets;
import org.mobicents.protocols.ss7.map.primitives.DiameterIdentityImpl;
import org.mobicents.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.mobicents.protocols.ss7.map.primitives.LMSIImpl;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.primitives.SequenceBase;
import org.mobicents.protocols.ss7.map.service.lsm.AdditionalNumberImpl;
import org.mobicents.protocols.ss7.map.service.mobility.locationManagement.SupportedLCSCapabilitySetsImpl;

public class LCSLocationInfoImpl
extends SequenceBase
implements LCSLocationInfo {
    private static final int _TAG_LMSI = 0;
    private static final int _TAG_EXTENSION_CONTAINER = 1;
    private static final int _TAG_GPRS_NODE_IND = 2;
    private static final int _TAG_ADDITIONAL_NUMBER = 3;
    private static final int _TAG_SUPPORTED_LCS_CAPBILITY_SET = 4;
    private static final int _TAG_ADDITIONAL_LCS_CAPBILITY_SET = 5;
    private static final int _TAG_mme_Name = 6;
    private static final int _TAG_aaa_Server_Name = 8;
    private ISDNAddressString networkNodeNumber;
    private LMSI lmsi;
    private MAPExtensionContainer extensionContainer;
    private boolean gprsNodeIndicator;
    private AdditionalNumber additionalNumber;
    private SupportedLCSCapabilitySets supportedLCSCapabilitySets;
    private SupportedLCSCapabilitySets additionalLCSCapabilitySets;
    private DiameterIdentity mmeName;
    private DiameterIdentity aaaServerName;

    public LCSLocationInfoImpl() {
        super("LCSLocationInfo");
    }

    public LCSLocationInfoImpl(ISDNAddressString networkNodeNumber, LMSI lmsi, MAPExtensionContainer extensionContainer, boolean gprsNodeIndicator, AdditionalNumber additionalNumber, SupportedLCSCapabilitySets supportedLCSCapabilitySets, SupportedLCSCapabilitySets additionalLCSCapabilitySets, DiameterIdentity mmeName, DiameterIdentity aaaServerName) {
        super("LCSLocationInfo");
        this.networkNodeNumber = networkNodeNumber;
        this.lmsi = lmsi;
        this.extensionContainer = extensionContainer;
        this.gprsNodeIndicator = gprsNodeIndicator;
        this.additionalNumber = additionalNumber;
        this.supportedLCSCapabilitySets = supportedLCSCapabilitySets;
        this.additionalLCSCapabilitySets = additionalLCSCapabilitySets;
        this.mmeName = mmeName;
        this.aaaServerName = aaaServerName;
    }

    public ISDNAddressString getNetworkNodeNumber() {
        return this.networkNodeNumber;
    }

    public LMSI getLMSI() {
        return this.lmsi;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public boolean getGprsNodeIndicator() {
        return this.gprsNodeIndicator;
    }

    public AdditionalNumber getAdditionalNumber() {
        return this.additionalNumber;
    }

    public SupportedLCSCapabilitySets getSupportedLCSCapabilitySets() {
        return this.supportedLCSCapabilitySets;
    }

    public SupportedLCSCapabilitySets getAdditionalLCSCapabilitySets() {
        return this.additionalLCSCapabilitySets;
    }

    public DiameterIdentity getMmeName() {
        return this.mmeName;
    }

    public DiameterIdentity getAaaServerName() {
        return this.aaaServerName;
    }

    @Override
    protected void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.networkNodeNumber = null;
        this.lmsi = null;
        this.extensionContainer = null;
        this.gprsNodeIndicator = false;
        this.additionalNumber = null;
        this.supportedLCSCapabilitySets = null;
        this.additionalLCSCapabilitySets = null;
        this.mmeName = null;
        this.aaaServerName = null;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        int tag = ais.readTag();
        if (ais.getTagClass() != 0 || !ais.isTagPrimitive() || tag != 4) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter [networkNode-Number ISDN-AddressString] bad tag class, tag or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        this.networkNodeNumber = new ISDNAddressStringImpl();
        ((ISDNAddressStringImpl)this.networkNodeNumber).decodeAll(ais);
        block10: while (ais.available() != 0) {
            tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter [lmsi [0] LMSI ] bad tag class, tag or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.lmsi = new LMSIImpl();
                        ((LMSIImpl)this.lmsi).decodeAll(ais);
                        continue block10;
                    }
                    case 1: {
                        if (ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter [extensionContainer [1] ExtensionContainer ] is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.extensionContainer = new MAPExtensionContainerImpl();
                        ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                        continue block10;
                    }
                    case 2: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter [gprsNodeIndicator [2] NULL ] is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        ais.readNull();
                        this.gprsNodeIndicator = true;
                        continue block10;
                    }
                    case 3: {
                        if (ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter [additional-Number [3] Additional-Number] is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.additionalNumber = new AdditionalNumberImpl();
                        AsnInputStream ais2 = ais.readSequenceStream();
                        ais2.readTag();
                        ((AdditionalNumberImpl)this.additionalNumber).decodeAll(ais2);
                        continue block10;
                    }
                    case 4: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter [supportedLCS-CapabilitySets [4] SupportedLCS-CapabilitySets] is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.supportedLCSCapabilitySets = new SupportedLCSCapabilitySetsImpl();
                        ((SupportedLCSCapabilitySetsImpl)this.supportedLCSCapabilitySets).decodeAll(ais);
                        continue block10;
                    }
                    case 5: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter [additional-LCS-CapabilitySets [5] SupportedLCS-CapabilitySets] is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.additionalLCSCapabilitySets = new SupportedLCSCapabilitySetsImpl();
                        ((SupportedLCSCapabilitySetsImpl)this.additionalLCSCapabilitySets).decodeAll(ais);
                        continue block10;
                    }
                    case 6: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter mmeName is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.mmeName = new DiameterIdentityImpl();
                        ((DiameterIdentityImpl)this.mmeName).decodeAll(ais);
                        continue block10;
                    }
                    case 8: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter aaaServerName is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.aaaServerName = new DiameterIdentityImpl();
                        ((DiameterIdentityImpl)this.aaaServerName).decodeAll(ais);
                        continue block10;
                    }
                }
                ais.advanceElement();
                continue;
            }
            ais.advanceElement();
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.networkNodeNumber == null) {
            throw new MAPException("Error while encoding LCSLocationInfo the mandatory parameter networkNode-Number ISDN-AddressString is not defined");
        }
        ((ISDNAddressStringImpl)this.networkNodeNumber).encodeAll(asnOs);
        if (this.lmsi != null) {
            ((LMSIImpl)this.lmsi).encodeAll(asnOs, 2, 0);
        }
        if (this.extensionContainer != null) {
            ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 1);
        }
        if (this.gprsNodeIndicator) {
            try {
                asnOs.writeNull(2, 2);
            }
            catch (IOException e) {
                throw new MAPException("Error while encoding LCSLocationInfo the optional parameter gprsNodeIndicator encoding failed ", (Throwable)e);
            }
            catch (AsnException e) {
                throw new MAPException("Error while encoding LCSLocationInfo the optional parameter gprsNodeIndicator encoding failed ", (Throwable)e);
            }
        }
        if (this.additionalNumber != null) {
            try {
                asnOs.writeTag(2, false, 3);
            }
            catch (AsnException e) {
                throw new MAPException("AsnException while encoding parameter additional-Number");
            }
            int pos = asnOs.StartContentDefiniteLength();
            ((AdditionalNumberImpl)this.additionalNumber).encodeAll(asnOs, 2, ((AdditionalNumberImpl)this.additionalNumber).getTag());
            asnOs.FinalizeContent(pos);
        }
        if (this.supportedLCSCapabilitySets != null) {
            ((SupportedLCSCapabilitySetsImpl)this.supportedLCSCapabilitySets).encodeAll(asnOs, 2, 4);
        }
        if (this.additionalLCSCapabilitySets != null) {
            ((SupportedLCSCapabilitySetsImpl)this.additionalLCSCapabilitySets).encodeAll(asnOs, 2, 5);
        }
        if (this.mmeName != null) {
            ((DiameterIdentityImpl)this.mmeName).encodeAll(asnOs, 2, 6);
        }
        if (this.aaaServerName != null) {
            ((DiameterIdentityImpl)this.aaaServerName).encodeAll(asnOs, 2, 8);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.additionalLCSCapabilitySets == null ? 0 : this.additionalLCSCapabilitySets.hashCode());
        result = 31 * result + (this.additionalNumber == null ? 0 : this.additionalNumber.hashCode());
        result = 31 * result + (this.extensionContainer == null ? 0 : this.extensionContainer.hashCode());
        result = 31 * result + (this.gprsNodeIndicator ? 1 : 0);
        result = 31 * result + (this.lmsi == null ? 0 : this.lmsi.hashCode());
        result = 31 * result + (this.networkNodeNumber == null ? 0 : this.networkNodeNumber.hashCode());
        result = 31 * result + (this.supportedLCSCapabilitySets == null ? 0 : this.supportedLCSCapabilitySets.hashCode());
        result = 31 * result + (this.mmeName == null ? 0 : this.mmeName.hashCode());
        result = 31 * result + (this.aaaServerName == null ? 0 : this.aaaServerName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LCSLocationInfoImpl other = (LCSLocationInfoImpl)obj;
        if (this.additionalLCSCapabilitySets == null ? other.additionalLCSCapabilitySets != null : !this.additionalLCSCapabilitySets.equals(other.additionalLCSCapabilitySets)) {
            return false;
        }
        if (this.additionalNumber == null ? other.additionalNumber != null : !this.additionalNumber.equals(other.additionalNumber)) {
            return false;
        }
        if (this.extensionContainer == null ? other.extensionContainer != null : !this.extensionContainer.equals(other.extensionContainer)) {
            return false;
        }
        if (this.gprsNodeIndicator != other.gprsNodeIndicator) {
            return false;
        }
        if (this.lmsi == null ? other.lmsi != null : !this.lmsi.equals(other.lmsi)) {
            return false;
        }
        if (this.networkNodeNumber == null ? other.networkNodeNumber != null : !this.networkNodeNumber.equals(other.networkNodeNumber)) {
            return false;
        }
        if (this.supportedLCSCapabilitySets == null ? other.supportedLCSCapabilitySets != null : !this.supportedLCSCapabilitySets.equals(other.supportedLCSCapabilitySets)) {
            return false;
        }
        if (this.mmeName == null ? other.mmeName != null : !this.mmeName.equals(other.mmeName)) {
            return false;
        }
        return !(this.aaaServerName == null ? other.aaaServerName != null : !this.aaaServerName.equals(other.aaaServerName));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        if (this.networkNodeNumber != null) {
            sb.append("networkNodeNumber=");
            sb.append(this.networkNodeNumber);
        }
        if (this.lmsi != null) {
            sb.append(", lmsi=");
            sb.append(this.lmsi);
        }
        if (this.extensionContainer != null) {
            sb.append(", extensionContainer=");
            sb.append(this.extensionContainer);
        }
        if (this.gprsNodeIndicator) {
            sb.append(", gprsNodeIndicator=");
        }
        if (this.additionalNumber != null) {
            sb.append(", additionalNumber=");
            sb.append(this.additionalNumber);
        }
        if (this.supportedLCSCapabilitySets != null) {
            sb.append(", supportedLCSCapabilitySets=");
            sb.append(this.supportedLCSCapabilitySets);
        }
        if (this.additionalLCSCapabilitySets != null) {
            sb.append(", additionalLCSCapabilitySets=");
            sb.append(this.additionalLCSCapabilitySets);
        }
        if (this.mmeName != null) {
            sb.append(", mmeName=");
            sb.append(this.mmeName);
        }
        if (this.aaaServerName != null) {
            sb.append(", aaaServerName=");
            sb.append(this.aaaServerName);
        }
        sb.append("]");
        return sb.toString();
    }
}

