/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.callhandling;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.service.callhandling.ForwardingData;
import org.mobicents.protocols.ss7.map.api.service.callhandling.RoutingInfo;
import org.mobicents.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;
import org.mobicents.protocols.ss7.map.service.callhandling.ForwardingDataImpl;

public class RoutingInfoImpl
implements RoutingInfo,
MAPAsnPrimitive {
    private ISDNAddressString roamingNumber = null;
    private ForwardingData forwardingData = null;
    private static final String _PrimitiveName = "RoutingInfo";

    public RoutingInfoImpl() {
    }

    public RoutingInfoImpl(ISDNAddressString roamingNumber) {
        this.roamingNumber = roamingNumber;
    }

    public RoutingInfoImpl(ForwardingData forwardingData) {
        this.forwardingData = forwardingData;
    }

    public ISDNAddressString getRoamingNumber() {
        return this.roamingNumber;
    }

    public ForwardingData getForwardingData() {
        return this.forwardingData;
    }

    @Override
    public int getTag() throws MAPException {
        if (this.roamingNumber != null) {
            return 4;
        }
        return 16;
    }

    @Override
    public int getTagClass() {
        if (this.roamingNumber != null) {
            return 0;
        }
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return this.roamingNumber != null;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding RoutingInfo: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding RoutingInfo: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding RoutingInfo: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding RoutingInfo: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ais, int length) throws MAPParsingComponentException, IOException, AsnException {
        block5: {
            block4: {
                this.roamingNumber = null;
                this.forwardingData = null;
                int tag = ais.getTag();
                if (ais.getTagClass() != 0) break block4;
                switch (tag) {
                    case 4: {
                        this.roamingNumber = new ISDNAddressStringImpl();
                        ((ISDNAddressStringImpl)this.roamingNumber).decodeData(ais, length);
                        break block5;
                    }
                    case 16: {
                        this.forwardingData = new ForwardingDataImpl();
                        ((ForwardingDataImpl)this.forwardingData).decodeData(ais, length);
                        break block5;
                    }
                    default: {
                        throw new MAPParsingComponentException("Error while decoding RoutingInfo: bad choice tagNumber", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                }
            }
            throw new MAPParsingComponentException("Error while decoding RoutingInfo: bad choice tagClass", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding RoutingInfo: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.roamingNumber == null && this.forwardingData == null) {
            throw new MAPException("Both roamingNumber and forwardingData must not be null");
        }
        if (this.roamingNumber != null && this.forwardingData != null) {
            throw new MAPException("Both roamingNumber and forwardingData must not be not null");
        }
        if (this.roamingNumber != null) {
            ((ISDNAddressStringImpl)this.roamingNumber).encodeData(asnOs);
        } else {
            ((ForwardingDataImpl)this.forwardingData).encodeData(asnOs);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.roamingNumber != null) {
            sb.append(this.roamingNumber.toString());
        } else if (this.forwardingData != null) {
            sb.append(this.forwardingData.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

