/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.primitives;

import java.io.IOException;
import java.util.Arrays;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;

public abstract class OctetStringBase
implements MAPAsnPrimitive {
    private static final char[] digits = "0123456789ABCDEF".toCharArray();
    protected byte[] data;
    protected int minLength;
    protected int maxLength;
    protected String _PrimitiveName;

    public OctetStringBase(int minLength, int maxLength, String _PrimitiveName) {
        this.minLength = minLength;
        this.maxLength = maxLength;
        this._PrimitiveName = _PrimitiveName;
    }

    public OctetStringBase(int minLength, int maxLength, String _PrimitiveName, byte[] data) {
        this(minLength, maxLength, _PrimitiveName);
        this.data = data;
    }

    @Override
    public int getTag() throws MAPException {
        return 4;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return true;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    protected void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException {
        if (!ansIS.isTagPrimitive()) {
            throw new MAPParsingComponentException("Error decoding " + this._PrimitiveName + ": field must be primitive", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (length < this.minLength || length > this.maxLength) {
            throw new MAPParsingComponentException("Error decoding " + this._PrimitiveName + ": the field must contain from " + this.minLength + " to " + this.maxLength + " octets. Contains: " + length, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        this.data = new byte[length];
        ansIS.read(this.data);
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.data == null) {
            throw new MAPException("Error while encoding the " + this._PrimitiveName + ": data is not defined");
        }
        if (this.data.length < this.minLength || this.data.length > this.maxLength) {
            throw new MAPException("Error while encoding the " + this._PrimitiveName + ": data field length must be from " + this.minLength + " to " + this.maxLength + " octets");
        }
        asnOs.write(this.data);
    }

    public int hashCode() {
        if (this.data == null) {
            return 0;
        }
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OctetStringBase other = (OctetStringBase)obj;
        return !(this.data == null ? other.data != null : !Arrays.equals(this.data, other.data));
    }

    public String toString() {
        return this._PrimitiveName + " [Data= " + this.printDataArr() + "]";
    }

    protected String printDataArr() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        if (this.data != null) {
            for (byte b : this.data) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(b & 0xFF);
            }
        }
        return sb.toString();
    }

    protected static String bytesToHex(byte[] data) {
        int i;
        if (data == null) {
            return null;
        }
        char[] c = new char[data.length * 2];
        int j = i = 0;
        while (i < data.length) {
            c[j] = digits[data[i] >> 4 & 0xF];
            c[j + 1] = digits[data[i] & 0xF];
            ++i;
            j += 2;
        }
        return new String(c);
    }

    private static byte byteFromHexChar(char c) {
        if ('0' <= c && c <= '9') {
            return (byte)(c - 48);
        }
        if ('A' <= (c = Character.toUpperCase(c)) && c <= 'F') {
            return (byte)(c - 65 + 10);
        }
        throw new IllegalArgumentException("Invalid hex character: " + c);
    }

    protected static byte[] hexToBytes(String hex) {
        int i;
        if (hex == null) {
            return null;
        }
        char[] c = hex.toCharArray();
        if ((c.length & 1) > 0) {
            throw new IllegalArgumentException("Hex string must be 2n characters long!");
        }
        byte[] b = new byte[c.length / 2];
        int j = i = 0;
        while (i < b.length) {
            b[i] = (byte)((OctetStringBase.byteFromHexChar(c[j]) << 4) + OctetStringBase.byteFromHexChar(c[j + 1]));
            ++i;
            j += 2;
        }
        return b;
    }
}

