/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.primitives;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.AddressNature;
import org.mobicents.protocols.ss7.map.api.primitives.AddressString;
import org.mobicents.protocols.ss7.map.api.primitives.NumberingPlan;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;
import org.mobicents.protocols.ss7.map.primitives.TbcdString;

public class AddressStringImpl
implements AddressString,
MAPAsnPrimitive {
    private static final String NAI = "nai";
    private static final String NPI = "npi";
    private static final String NUMBER = "number";
    private static final String DEFAULT_STRING_VALUE = null;
    protected int NO_EXTENSION_MASK = 128;
    protected int NATURE_OF_ADD_IND_MASK = 112;
    protected int NUMBERING_PLAN_IND_MASK = 15;
    protected AddressNature addressNature;
    protected NumberingPlan numberingPlan;
    protected String address;
    private boolean isExtension;
    protected static final XMLFormat<AddressStringImpl> ADDRESS_STRING_XML = new XMLFormat<AddressStringImpl>(AddressStringImpl.class){

        public void read(XMLFormat.InputElement xml, AddressStringImpl addressStringImpl) throws XMLStreamException {
            addressStringImpl.address = xml.getAttribute(AddressStringImpl.NUMBER, "");
            String nai = xml.getAttribute(AddressStringImpl.NAI, DEFAULT_STRING_VALUE);
            String npi = xml.getAttribute(AddressStringImpl.NPI, DEFAULT_STRING_VALUE);
            if (nai != null) {
                addressStringImpl.addressNature = Enum.valueOf(AddressNature.class, nai);
            }
            if (npi != null) {
                addressStringImpl.numberingPlan = Enum.valueOf(NumberingPlan.class, npi);
            }
        }

        public void write(AddressStringImpl addressStringImpl, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(AddressStringImpl.NUMBER, addressStringImpl.address);
            xml.setAttribute(AddressStringImpl.NAI, addressStringImpl.addressNature.toString());
            xml.setAttribute(AddressStringImpl.NPI, addressStringImpl.numberingPlan.toString());
        }
    };

    public AddressStringImpl() {
    }

    public AddressStringImpl(AddressNature addressNature, NumberingPlan numberingPlan, String address) {
        this.addressNature = addressNature;
        this.numberingPlan = numberingPlan;
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }

    public AddressNature getAddressNature() {
        return this.addressNature;
    }

    public NumberingPlan getNumberingPlan() {
        return this.numberingPlan;
    }

    public boolean isExtension() {
        return this.isExtension;
    }

    @Override
    public int getTag() throws MAPException {
        return 4;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return true;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding AddressString: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding AddressString: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    protected void _testLengthDecode(int length) throws MAPParsingComponentException {
        if (length > 20) {
            throw new MAPParsingComponentException("Error when decoding AddressString: mesage length must not exceed 20", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    protected void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException {
        this._testLengthDecode(length);
        int nature = ansIS.read();
        this.isExtension = (nature & this.NO_EXTENSION_MASK) != 128;
        int natureOfAddInd = (nature & this.NATURE_OF_ADD_IND_MASK) >> 4;
        this.addressNature = AddressNature.getInstance((int)natureOfAddInd);
        int numbPlanInd = nature & this.NUMBERING_PLAN_IND_MASK;
        this.numberingPlan = NumberingPlan.getInstance((int)numbPlanInd);
        this.address = TbcdString.decodeString((InputStream)ansIS, length - 1);
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, 0, 4);
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, true, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding AddressString: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void _testLengthEncode() throws MAPException {
        if (this.address.length() > 38) {
            throw new MAPException("Error when encoding AddressString: address length must not exceed 38 digits");
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.addressNature == null || this.numberingPlan == null || this.address == null) {
            throw new MAPException("Error when encoding AddressString: addressNature, numberingPlan or address is empty");
        }
        this._testLengthEncode();
        int nature = 1;
        if (this.isExtension) {
            nature = 0;
        }
        nature <<= 7;
        nature |= this.addressNature.getIndicator() << 4;
        asnOs.write(nature |= this.numberingPlan.getIndicator());
        TbcdString.encodeString((OutputStream)asnOs, this.address);
    }

    public String toString() {
        return "AddressString[AddressNature=" + this.addressNature.toString() + ", NumberingPlan=" + this.numberingPlan.toString() + ", Address=" + this.address + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.addressNature == null ? 0 : this.addressNature.hashCode());
        result = 31 * result + (this.numberingPlan == null ? 0 : this.numberingPlan.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AddressStringImpl other = (AddressStringImpl)obj;
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        if (this.addressNature != other.addressNature) {
            return false;
        }
        return this.numberingPlan == other.numberingPlan;
    }
}

