/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.datacoding;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import org.mobicents.protocols.ss7.map.datacoding.GSMCharset;
import org.mobicents.protocols.ss7.map.datacoding.GSMCharsetDecodingData;
import org.mobicents.protocols.ss7.map.datacoding.Gsm7EncodingStyle;

public class GSMCharsetDecoder
extends CharsetDecoder {
    private byte[] mask = new byte[]{127, 63, 31, 15, 7, 3, 1};
    private int bitpos = 0;
    private int decodedBytes = 0;
    private byte leftOver;
    private GSMCharset cs;
    private boolean escape;
    private GSMCharsetDecodingData encodingData;

    protected GSMCharsetDecoder(Charset cs, float averageCharsPerByte, float maxCharsPerByte) {
        super(cs, averageCharsPerByte, maxCharsPerByte);
        this.implReset();
        this.cs = (GSMCharset)cs;
    }

    public void setGSMCharsetDecodingData(GSMCharsetDecodingData encodingData) {
        this.encodingData = encodingData;
    }

    public GSMCharsetDecodingData getGSMCharsetDecodingData() {
        return this.encodingData;
    }

    @Override
    protected void implReset() {
        this.bitpos = 0;
        this.decodedBytes = 0;
        this.leftOver = 0;
        this.escape = false;
    }

    @Override
    protected CoderResult implFlush(CharBuffer out) {
        return CoderResult.UNDERFLOW;
    }

    @Override
    protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
        while (in.hasRemaining()) {
            if (!out.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            byte data = in.get();
            if (this.encodingData != null && this.encodingData.encodingStyle == Gsm7EncodingStyle.bit8_smpp_style) {
                this.putChar(data, out);
                continue;
            }
            byte tempData = data;
            byte tempCurrHol = (byte)((data & 0xFF) >>> 7 - this.bitpos);
            data = (byte)(data & this.mask[this.bitpos]);
            if (this.bitpos != 0) {
                data = (byte)(data << this.bitpos);
                data = (byte)(data | this.leftOver);
                this.putChar(data, out);
                if (this.bitpos == 6) {
                    data = (byte)((tempData & 0xFE) >>> 1);
                    if (this.encodingData == null || this.encodingData.encodingStyle != Gsm7EncodingStyle.bit7_ussd_style || data != 13 || in.hasRemaining()) {
                        this.putChar(data, out);
                    }
                }
            } else {
                this.putChar(data, out);
            }
            this.leftOver = tempCurrHol;
            ++this.bitpos;
            if (this.bitpos != 7) continue;
            this.bitpos = 0;
        }
        return CoderResult.UNDERFLOW;
    }

    private void putChar(byte data, CharBuffer out) {
        ++this.decodedBytes;
        if (this.encodingData != null) {
            if (this.decodedBytes <= this.encodingData.leadingSeptetSkipCount) {
                return;
            }
            if (this.encodingData.totalSeptetCount >= 0 && this.decodedBytes > this.encodingData.totalSeptetCount) {
                return;
            }
        }
        int code = 0;
        if (data >= 0 && data < 128) {
            if (this.escape) {
                this.escape = false;
                if (this.cs.extensionTable != null) {
                    code = this.cs.extensionTable[data];
                }
            } else {
                if (data == 27) {
                    this.escape = true;
                    return;
                }
                code = this.cs.mainTable[data];
            }
        }
        if (code == 0) {
            out.put(' ');
        } else {
            out.put((char)code);
        }
    }
}

