/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javolution.util.FastList;
import javolution.util.FastMap;
import org.apache.log4j.Logger;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.MAPDialogImpl;
import org.mobicents.protocols.ss7.map.MAPParameterFactoryImpl;
import org.mobicents.protocols.ss7.map.MAPServiceBaseImpl;
import org.mobicents.protocols.ss7.map.MAPSmsTpduParameterFactoryImpl;
import org.mobicents.protocols.ss7.map.MAPStackImpl;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContext;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContextName;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContextVersion;
import org.mobicents.protocols.ss7.map.api.MAPDialog;
import org.mobicents.protocols.ss7.map.api.MAPDialogListener;
import org.mobicents.protocols.ss7.map.api.MAPDialogueAS;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParameterFactory;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPProvider;
import org.mobicents.protocols.ss7.map.api.MAPServiceBase;
import org.mobicents.protocols.ss7.map.api.MAPSmsTpduParameterFactory;
import org.mobicents.protocols.ss7.map.api.dialog.MAPAbortProviderReason;
import org.mobicents.protocols.ss7.map.api.dialog.MAPAbortSource;
import org.mobicents.protocols.ss7.map.api.dialog.MAPDialogState;
import org.mobicents.protocols.ss7.map.api.dialog.MAPNoticeProblemDiagnostic;
import org.mobicents.protocols.ss7.map.api.dialog.MAPProviderAbortReason;
import org.mobicents.protocols.ss7.map.api.dialog.MAPRefuseReason;
import org.mobicents.protocols.ss7.map.api.dialog.MAPUserAbortChoice;
import org.mobicents.protocols.ss7.map.api.dialog.Reason;
import org.mobicents.protocols.ss7.map.api.dialog.ServingCheckData;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessage;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessageFactory;
import org.mobicents.protocols.ss7.map.api.primitives.AddressString;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.callhandling.MAPServiceCallHandling;
import org.mobicents.protocols.ss7.map.api.service.lsm.MAPServiceLsm;
import org.mobicents.protocols.ss7.map.api.service.mobility.MAPServiceMobility;
import org.mobicents.protocols.ss7.map.api.service.oam.MAPServiceOam;
import org.mobicents.protocols.ss7.map.api.service.pdpContextActivation.MAPServicePdpContextActivation;
import org.mobicents.protocols.ss7.map.api.service.sms.MAPServiceSms;
import org.mobicents.protocols.ss7.map.api.service.supplementary.MAPServiceSupplementary;
import org.mobicents.protocols.ss7.map.dialog.MAPAcceptInfoImpl;
import org.mobicents.protocols.ss7.map.dialog.MAPOpenInfoImpl;
import org.mobicents.protocols.ss7.map.dialog.MAPProviderAbortInfoImpl;
import org.mobicents.protocols.ss7.map.dialog.MAPRefuseInfoImpl;
import org.mobicents.protocols.ss7.map.dialog.MAPUserAbortInfoImpl;
import org.mobicents.protocols.ss7.map.errors.MAPErrorMessageFactoryImpl;
import org.mobicents.protocols.ss7.map.errors.MAPErrorMessageImpl;
import org.mobicents.protocols.ss7.map.service.callhandling.MAPServiceCallHandlingImpl;
import org.mobicents.protocols.ss7.map.service.lsm.MAPServiceLsmImpl;
import org.mobicents.protocols.ss7.map.service.mobility.MAPServiceMobilityImpl;
import org.mobicents.protocols.ss7.map.service.oam.MAPServiceOamImpl;
import org.mobicents.protocols.ss7.map.service.pdpContextActivation.MAPServicePdpContextActivationImpl;
import org.mobicents.protocols.ss7.map.service.sms.MAPServiceSmsImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.MAPServiceSupplementaryImpl;
import org.mobicents.protocols.ss7.sccp.NetworkIdState;
import org.mobicents.protocols.ss7.tcap.DialogImpl;
import org.mobicents.protocols.ss7.tcap.api.MessageType;
import org.mobicents.protocols.ss7.tcap.api.TCAPProvider;
import org.mobicents.protocols.ss7.tcap.api.TCAPSendException;
import org.mobicents.protocols.ss7.tcap.api.TCListener;
import org.mobicents.protocols.ss7.tcap.api.tc.component.InvokeClass;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.Dialog;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCBeginIndication;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCBeginRequest;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCContinueIndication;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCContinueRequest;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCEndIndication;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCEndRequest;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCNoticeIndication;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCPAbortIndication;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCUniIndication;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCUserAbortIndication;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCUserAbortRequest;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TerminationType;
import org.mobicents.protocols.ss7.tcap.asn.ApplicationContextName;
import org.mobicents.protocols.ss7.tcap.asn.DialogServiceProviderType;
import org.mobicents.protocols.ss7.tcap.asn.DialogServiceUserType;
import org.mobicents.protocols.ss7.tcap.asn.InvokeImpl;
import org.mobicents.protocols.ss7.tcap.asn.ResultSourceDiagnostic;
import org.mobicents.protocols.ss7.tcap.asn.TcapFactory;
import org.mobicents.protocols.ss7.tcap.asn.UserInformation;
import org.mobicents.protocols.ss7.tcap.asn.comp.Component;
import org.mobicents.protocols.ss7.tcap.asn.comp.ComponentType;
import org.mobicents.protocols.ss7.tcap.asn.comp.ErrorCodeType;
import org.mobicents.protocols.ss7.tcap.asn.comp.Invoke;
import org.mobicents.protocols.ss7.tcap.asn.comp.InvokeProblemType;
import org.mobicents.protocols.ss7.tcap.asn.comp.OperationCode;
import org.mobicents.protocols.ss7.tcap.asn.comp.OperationCodeType;
import org.mobicents.protocols.ss7.tcap.asn.comp.PAbortCauseType;
import org.mobicents.protocols.ss7.tcap.asn.comp.Parameter;
import org.mobicents.protocols.ss7.tcap.asn.comp.Problem;
import org.mobicents.protocols.ss7.tcap.asn.comp.ProblemType;
import org.mobicents.protocols.ss7.tcap.asn.comp.Reject;
import org.mobicents.protocols.ss7.tcap.asn.comp.ReturnError;
import org.mobicents.protocols.ss7.tcap.asn.comp.ReturnErrorProblemType;
import org.mobicents.protocols.ss7.tcap.asn.comp.ReturnResult;
import org.mobicents.protocols.ss7.tcap.asn.comp.ReturnResultLast;
import org.mobicents.protocols.ss7.tcap.asn.comp.ReturnResultProblemType;

public class MAPProviderImpl
implements MAPProvider,
TCListener {
    protected final transient Logger loger;
    private transient Collection<MAPDialogListener> dialogListeners = new FastList().shared();
    protected transient ConcurrentHashMap<Long, MAPDialogImpl> dialogs = new ConcurrentHashMap();
    private transient TCAPProvider tcapProvider = null;
    private final transient MAPParameterFactory MAPParameterFactory = new MAPParameterFactoryImpl();
    private final transient MAPSmsTpduParameterFactory mapSmsTpduParameterFactory = new MAPSmsTpduParameterFactoryImpl();
    private final transient MAPErrorMessageFactory mapErrorMessageFactory = new MAPErrorMessageFactoryImpl();
    protected transient Set<MAPServiceBase> mapServices = new HashSet<MAPServiceBase>();
    private final transient MAPServiceMobility mapServiceMobility = new MAPServiceMobilityImpl(this);
    private final transient MAPServiceCallHandling mapServiceCallHandling = new MAPServiceCallHandlingImpl(this);
    private final transient MAPServiceOam mapServiceOam = new MAPServiceOamImpl(this);
    private final transient MAPServicePdpContextActivation mapServicePdpContextActivation = new MAPServicePdpContextActivationImpl(this);
    private final transient MAPServiceSupplementary mapServiceSupplementary = new MAPServiceSupplementaryImpl(this);
    private final transient MAPServiceSms mapServiceSms = new MAPServiceSmsImpl(this);
    private final transient MAPServiceLsm mapServiceLsm = new MAPServiceLsmImpl(this);

    public MAPProviderImpl(String name, TCAPProvider tcapProvider) {
        this.loger = Logger.getLogger((String)(MAPStackImpl.class.getCanonicalName() + "-" + name));
        this.tcapProvider = tcapProvider;
        this.mapServices.add((MAPServiceBase)this.mapServiceMobility);
        this.mapServices.add((MAPServiceBase)this.mapServiceCallHandling);
        this.mapServices.add((MAPServiceBase)this.mapServiceOam);
        this.mapServices.add((MAPServiceBase)this.mapServicePdpContextActivation);
        this.mapServices.add((MAPServiceBase)this.mapServiceSupplementary);
        this.mapServices.add((MAPServiceBase)this.mapServiceSms);
        this.mapServices.add((MAPServiceBase)this.mapServiceLsm);
    }

    public TCAPProvider getTCAPProvider() {
        return this.tcapProvider;
    }

    public MAPServiceMobility getMAPServiceMobility() {
        return this.mapServiceMobility;
    }

    public MAPServiceCallHandling getMAPServiceCallHandling() {
        return this.mapServiceCallHandling;
    }

    public MAPServiceOam getMAPServiceOam() {
        return this.mapServiceOam;
    }

    public MAPServicePdpContextActivation getMAPServicePdpContextActivation() {
        return this.mapServicePdpContextActivation;
    }

    public MAPServiceSupplementary getMAPServiceSupplementary() {
        return this.mapServiceSupplementary;
    }

    public MAPServiceSms getMAPServiceSms() {
        return this.mapServiceSms;
    }

    public MAPServiceLsm getMAPServiceLsm() {
        return this.mapServiceLsm;
    }

    public void addMAPDialogListener(MAPDialogListener mapDialogListener) {
        this.dialogListeners.add(mapDialogListener);
    }

    public MAPParameterFactory getMAPParameterFactory() {
        return this.MAPParameterFactory;
    }

    public MAPSmsTpduParameterFactory getMAPSmsTpduParameterFactory() {
        return this.mapSmsTpduParameterFactory;
    }

    public MAPErrorMessageFactory getMAPErrorMessageFactory() {
        return this.mapErrorMessageFactory;
    }

    public void removeMAPDialogListener(MAPDialogListener mapDialogListener) {
        this.dialogListeners.remove(mapDialogListener);
    }

    public MAPDialog getMAPDialog(Long dialogId) {
        return this.dialogs.get(dialogId);
    }

    public void start() {
        this.tcapProvider.addTCListener((TCListener)this);
    }

    public void stop() {
        this.tcapProvider.removeTCListener((TCListener)this);
        this.dialogs.clear();
    }

    protected void addDialog(MAPDialogImpl dialog) {
        this.dialogs.put(dialog.getLocalDialogId(), dialog);
    }

    protected MAPDialogImpl removeDialog(Long dialogId) {
        return this.dialogs.remove(dialogId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTCBegin(TCBeginIndication tcBeginIndication) {
        StringBuffer s;
        ApplicationContextName acn = tcBeginIndication.getApplicationContextName();
        Component[] comps = tcBeginIndication.getComponents();
        if (acn == null && comps == null) {
            this.loger.error((Object)String.format("Received TCBeginIndication=%s, both ApplicationContextName and Component[] are null. Send TC-U-ABORT to peer and not notifying the User", tcBeginIndication));
            try {
                this.fireTCAbortV1(tcBeginIndication.getDialog(), false);
            }
            catch (MAPException e) {
                this.loger.error((Object)"Error while firing TC-U-ABORT. ", (Throwable)e);
            }
            return;
        }
        MAPApplicationContext mapAppCtx = null;
        MAPServiceBase perfSer = null;
        if (acn == null) {
            OperationCode oc;
            Invoke invoke = null;
            int operationCode = -1;
            for (Component c : comps) {
                if (c.getType() != ComponentType.Invoke) continue;
                invoke = (Invoke)c;
                break;
            }
            if (invoke != null && (oc = invoke.getOperationCode()) != null && oc.getOperationType() == OperationCodeType.Local) {
                operationCode = (int)oc.getLocalOperationCode().longValue();
            }
            if (operationCode != -1) {
                for (MAPServiceBase ser : this.mapServices) {
                    MAPApplicationContext ac = ((MAPServiceBaseImpl)ser).getMAPv1ApplicationContext(operationCode, invoke);
                    if (ac == null) continue;
                    perfSer = ser;
                    mapAppCtx = ac;
                    break;
                }
            }
            if (mapAppCtx == null) {
                try {
                    this.fireTCAbortV1(tcBeginIndication.getDialog(), false);
                    return;
                }
                catch (MAPException e) {
                    this.loger.error((Object)"Error while firing TC-U-ABORT. ", (Throwable)e);
                }
            }
        } else {
            if (MAPApplicationContext.getProtocolVersion((long[])acn.getOid()) < 2) {
                this.loger.error((Object)"Bad version of ApplicationContext if ApplicationContext exists. Must be 2 or greater");
                try {
                    this.fireTCAbortProvider(tcBeginIndication.getDialog(), MAPProviderAbortReason.abnormalDialogue, null, false);
                }
                catch (MAPException e) {
                    this.loger.error((Object)"Error while firing TC-U-ABORT. ", (Throwable)e);
                }
                return;
            }
            mapAppCtx = MAPApplicationContext.getInstance((long[])acn.getOid());
            if (mapAppCtx == null) {
                StringBuffer s2 = new StringBuffer();
                s2.append("Unrecognizable ApplicationContextName is received: ");
                for (long l : acn.getOid()) {
                    s2.append(l).append(", ");
                }
                this.loger.error((Object)s2.toString());
                try {
                    this.fireTCAbortACNNotSupported(tcBeginIndication.getDialog(), null, null, false);
                }
                catch (MAPException e) {
                    this.loger.error((Object)"Error while firing TC-U-ABORT. ", (Throwable)e);
                }
                return;
            }
        }
        AddressString destReference = null;
        AddressString origReference = null;
        MAPExtensionContainer extensionContainer = null;
        boolean eriStyle = false;
        AddressString eriMsisdn = null;
        AddressString eriVlrNo = null;
        UserInformation userInfo = tcBeginIndication.getUserInformation();
        if (userInfo == null) {
            if (mapAppCtx.getApplicationContextName() == MAPApplicationContextName.callCompletionContext || mapAppCtx.getApplicationContextName() == MAPApplicationContextName.networkFunctionalSsContext || mapAppCtx.getApplicationContextName() == MAPApplicationContextName.networkUnstructuredSsContext) {
                this.loger.error((Object)("When parsing TC-BEGIN: userInfo is mandatory for ACN==" + mapAppCtx.getApplicationContextName() + " but not found"));
                try {
                    this.fireTCAbortProvider(tcBeginIndication.getDialog(), MAPProviderAbortReason.abnormalDialogue, null, false);
                }
                catch (MAPException e) {
                    this.loger.error((Object)"Error while firing TC-U-ABORT. ", (Throwable)e);
                }
                return;
            }
        } else {
            MAPOpenInfoImpl mapOpenInfoImpl = new MAPOpenInfoImpl();
            if (!userInfo.isOid()) {
                this.loger.error((Object)"When parsing TC-BEGIN: userInfo.isOid() check failed");
                try {
                    this.fireTCAbortProvider(tcBeginIndication.getDialog(), MAPProviderAbortReason.invalidPDU, null, false);
                }
                catch (MAPException e) {
                    this.loger.error((Object)"Error while firing TC-U-ABORT. ", (Throwable)e);
                }
                return;
            }
            long[] oid = userInfo.getOidValue();
            MAPDialogueAS mapDialAs = MAPDialogueAS.getInstance((long[])oid);
            if (mapDialAs == null) {
                this.loger.error((Object)"When parsing TC-BEGIN: Expected MAPDialogueAS.MAP_DialogueAS but is null");
                try {
                    this.fireTCAbortProvider(tcBeginIndication.getDialog(), MAPProviderAbortReason.invalidPDU, null, false);
                }
                catch (MAPException e) {
                    this.loger.error((Object)"Error while firing TC-U-ABORT. ", (Throwable)e);
                }
                return;
            }
            if (!userInfo.isAsn()) {
                this.loger.error((Object)"When parsing TC-BEGIN: userInfo.isAsn() check failed");
                try {
                    this.fireTCAbortProvider(tcBeginIndication.getDialog(), MAPProviderAbortReason.invalidPDU, null, false);
                }
                catch (MAPException e) {
                    this.loger.error((Object)"Error while firing TC-U-ABORT. ", (Throwable)e);
                }
                return;
            }
            try {
                byte[] asnData = userInfo.getEncodeType();
                AsnInputStream ais = new AsnInputStream(asnData);
                int tag = ais.readTag();
                if (tag != 0) {
                    this.loger.error((Object)"When parsing TC-BEGIN: MAP-OPEN dialog PDU must be received");
                    try {
                        this.fireTCAbortProvider(tcBeginIndication.getDialog(), MAPProviderAbortReason.invalidPDU, null, false);
                    }
                    catch (MAPException e) {
                        this.loger.error((Object)"Error while firing TC-U-ABORT. ", (Throwable)e);
                    }
                    return;
                }
                mapOpenInfoImpl.decodeAll(ais);
                destReference = mapOpenInfoImpl.getDestReference();
                origReference = mapOpenInfoImpl.getOrigReference();
                extensionContainer = mapOpenInfoImpl.getExtensionContainer();
                eriStyle = mapOpenInfoImpl.getEriStyle();
                eriMsisdn = mapOpenInfoImpl.getEriMsisdn();
                eriVlrNo = mapOpenInfoImpl.getEriVlrNo();
            }
            catch (AsnException e) {
                e.printStackTrace();
                this.loger.error((Object)("AsnException when parsing MAP-OPEN Pdu: " + e.getMessage()), (Throwable)e);
                try {
                    this.fireTCAbortProvider(tcBeginIndication.getDialog(), MAPProviderAbortReason.invalidPDU, null, false);
                }
                catch (MAPException e1) {
                    this.loger.error((Object)"Error while firing TC-U-ABORT. ", (Throwable)e1);
                }
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                this.loger.error((Object)("IOException when parsing MAP-OPEN Pdu: " + e.getMessage()));
                try {
                    this.fireTCAbortProvider(tcBeginIndication.getDialog(), MAPProviderAbortReason.invalidPDU, null, false);
                }
                catch (MAPException e1) {
                    this.loger.error((Object)"Error while firing TC-U-ABORT. ", (Throwable)e1);
                }
                return;
            }
            catch (MAPParsingComponentException e) {
                e.printStackTrace();
                this.loger.error((Object)("MAPException when parsing MAP-OPEN Pdu: " + e.getMessage()));
                try {
                    this.fireTCAbortProvider(tcBeginIndication.getDialog(), MAPProviderAbortReason.invalidPDU, null, false);
                }
                catch (MAPException e1) {
                    this.loger.error((Object)"Error while firing TC-U-ABORT. ", (Throwable)e1);
                }
                return;
            }
        }
        if (perfSer == null) {
            for (MAPServiceBase ser : this.mapServices) {
                ServingCheckData chkRes = ser.isServingService(mapAppCtx);
                switch (chkRes.getResult()) {
                    case AC_Serving: {
                        perfSer = ser;
                        break;
                    }
                    case AC_VersionIncorrect: {
                        try {
                            this.fireTCAbortACNNotSupported(tcBeginIndication.getDialog(), null, chkRes.getAlternativeApplicationContext(), false);
                            break;
                        }
                        catch (MAPException e1) {
                            this.loger.error((Object)"Error while firing TC-U-ABORT. ", (Throwable)e1);
                        }
                    }
                }
                if (perfSer == null) continue;
                break;
            }
        }
        if (perfSer == null) {
            s = new StringBuffer();
            s.append("Unsupported ApplicationContextName is received: ");
            if (acn != null) {
                for (long l : acn.getOid()) {
                    s.append(l).append(", ");
                }
            } else {
                s.append("MAP V1");
            }
            this.loger.error((Object)s.toString());
            try {
                this.fireTCAbortACNNotSupported(tcBeginIndication.getDialog(), null, null, false);
            }
            catch (MAPException e1) {
                this.loger.error((Object)"Error while firing TC-U-ABORT. ", (Throwable)e1);
            }
            return;
        }
        if (!perfSer.isActivated()) {
            s = new StringBuffer();
            s.append("ApplicationContextName of non activated MAPService is received. Will send back TCAP Abort : ");
            if (acn != null) {
                for (long l : acn.getOid()) {
                    s.append(l).append(", ");
                }
            } else {
                s.append("MAP V1");
            }
            this.loger.warn((Object)s.toString());
            try {
                this.fireTCAbortACNNotSupported(tcBeginIndication.getDialog(), null, null, false);
            }
            catch (MAPException e1) {
                this.loger.error((Object)"Error while firing TC-U-ABORT. ", (Throwable)e1);
            }
            return;
        }
        MAPDialogImpl mapDialogImpl = ((MAPServiceBaseImpl)perfSer).createNewDialogIncoming(mapAppCtx, tcBeginIndication.getDialog());
        try {
            mapDialogImpl.getTcapDialog().getDialogLock().lock();
            this.addDialog(mapDialogImpl);
            mapDialogImpl.tcapMessageType = MessageType.Begin;
            mapDialogImpl.receivedOrigReference = origReference;
            mapDialogImpl.receivedDestReference = destReference;
            mapDialogImpl.receivedExtensionContainer = extensionContainer;
            mapDialogImpl.setState(MAPDialogState.INITIAL_RECEIVED);
            mapDialogImpl.delayedAreaState = MAPDialogImpl.DelayedAreaState.No;
            if (eriStyle) {
                this.deliverDialogRequestEri(mapDialogImpl, destReference, origReference, eriMsisdn, eriVlrNo);
            } else {
                this.deliverDialogRequest(mapDialogImpl, destReference, origReference, extensionContainer);
            }
            if (mapDialogImpl.getState() == MAPDialogState.EXPUNGED) {
                return;
            }
            if (comps != null) {
                this.processComponents(mapDialogImpl, comps);
            }
            this.deliverDialogDelimiter(mapDialogImpl);
            this.finishComponentProcessingState(mapDialogImpl);
            if (this.getTCAPProvider().getPreviewMode()) {
                DialogImpl dimp = (DialogImpl)tcBeginIndication.getDialog();
                dimp.getPrevewDialogData().setUpperDialog((Object)mapDialogImpl);
            }
        }
        finally {
            mapDialogImpl.getTcapDialog().getDialogLock().unlock();
        }
    }

    private void finishComponentProcessingState(MAPDialogImpl mapDialogImpl) {
        if (mapDialogImpl.getState() == MAPDialogState.EXPUNGED) {
            return;
        }
        try {
            switch (mapDialogImpl.delayedAreaState) {
                case Continue: {
                    mapDialogImpl.send();
                    break;
                }
                case End: {
                    mapDialogImpl.close(false);
                    break;
                }
                case PrearrangedEnd: {
                    mapDialogImpl.close(true);
                }
            }
        }
        catch (MAPException e) {
            this.loger.error((Object)("Error while finishComponentProcessingState, delayedAreaState=" + (Object)((Object)mapDialogImpl.delayedAreaState)), (Throwable)e);
        }
        mapDialogImpl.delayedAreaState = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onTCContinue(TCContinueIndication tcContinueIndication) {
        tcapDialog = tcContinueIndication.getDialog();
        mapDialogImpl = this.getTCAPProvider().getPreviewMode() != false ? (MAPDialogImpl)((DialogImpl)tcapDialog).getPrevewDialogData().getUpperDialog() : (MAPDialogImpl)this.getMAPDialog(tcapDialog.getLocalDialogId());
        if (mapDialogImpl == null) {
            this.loger.error((Object)("MAP Dialog not found for Dialog Id " + tcapDialog.getLocalDialogId()));
            try {
                this.fireTCAbortProvider(tcapDialog, MAPProviderAbortReason.abnormalDialogue, null, false);
                return;
            }
            catch (MAPException e) {
                this.loger.error((Object)"Error while firing TC-U-ABORT. ", (Throwable)e);
            }
            return;
        }
        try {
            block36: {
                mapDialogImpl.getTcapDialog().getDialogLock().lock();
                mapDialogImpl.tcapMessageType = MessageType.Continue;
                if (!this.getTCAPProvider().getPreviewMode()) break block36;
                extensionContainer = null;
                userInfo = tcContinueIndication.getUserInformation();
                if (userInfo == null) ** GOTO lbl40
                mapAcceptInfoImpl = new MAPAcceptInfoImpl();
                if (!userInfo.isOid() || (mapDialAs = MAPDialogueAS.getInstance((long[])(oid = userInfo.getOidValue()))) == null || !userInfo.isAsn()) ** GOTO lbl40
                try {
                    asnData = userInfo.getEncodeType();
                    ais = new AsnInputStream(asnData);
                    tag = ais.readTag();
                    if (tag == 1) {
                        mapAcceptInfoImpl.decodeAll(ais);
                        extensionContainer = mapAcceptInfoImpl.getExtensionContainer();
                    }
                    ** GOTO lbl40
                }
                catch (AsnException e) {
                    e.printStackTrace();
                    this.loger.error((Object)("AsnException when parsing MAP-ACCEPT Pdu: " + e.getMessage()), (Throwable)e);
                    mapDialogImpl.getTcapDialog().getDialogLock().unlock();
                    return;
                }
                catch (IOException e) {
                    block37: {
                        e.printStackTrace();
                        this.loger.error((Object)("IOException when parsing MAP-ACCEPT Pdu: " + e.getMessage()), (Throwable)e);
                        break block37;
                        catch (MAPParsingComponentException e) {
                            e.printStackTrace();
                            this.loger.error((Object)("MAPException when parsing MAP-ACCEPT Pdu: " + e.getMessage()), (Throwable)e);
                        }
                    }
                    if (tcContinueIndication.getApplicationContextName() != null) {
                        this.deliverDialogAccept(mapDialogImpl, extensionContainer);
                    }
                    if ((comps = tcContinueIndication.getComponents()) != null) {
                        this.processComponents(mapDialogImpl, comps);
                    }
                    this.deliverDialogDelimiter(mapDialogImpl);
                    return;
                }
            }
            if (mapDialogImpl.getState() != MAPDialogState.INITIAL_SENT) ** GOTO lbl107
            acn = tcContinueIndication.getApplicationContextName();
            if (acn == null) {
                if (mapDialogImpl.getApplicationContext().getApplicationContextVersion() != MAPApplicationContextVersion.version1) {
                    this.loger.error((Object)String.format("Received first TC-CONTINUE for MAPDialog=%s. But no application-context-name included", new Object[]{mapDialogImpl}));
                    try {
                        this.fireTCAbortProvider(tcapDialog, MAPProviderAbortReason.abnormalDialogue, null, mapDialogImpl.getReturnMessageOnError());
                    }
                    catch (MAPException e) {
                        this.loger.error((Object)"Error while firing TC-U-ABORT. ", (Throwable)e);
                    }
                    this.deliverDialogProviderAbort(mapDialogImpl, MAPAbortProviderReason.AbnormalMAPDialogueLocal, MAPAbortSource.MAPProblem, null);
                    mapDialogImpl.setState(MAPDialogState.EXPUNGED);
                    return;
                }
            } else {
                mapAcn = MAPApplicationContext.getInstance((long[])acn.getOid());
                if (mapAcn == null || !mapAcn.equals((Object)mapDialogImpl.getApplicationContext())) {
                    this.loger.error((Object)String.format("Received first TC-CONTINUE. MAPDialog=%s. But MAPApplicationContext=%s", new Object[]{mapDialogImpl, mapAcn}));
                    try {
                        this.fireTCAbortProvider(tcapDialog, MAPProviderAbortReason.abnormalDialogue, null, mapDialogImpl.getReturnMessageOnError());
                    }
                    catch (MAPException e) {
                        this.loger.error((Object)"Error while firing TC-U-ABORT. ", (Throwable)e);
                    }
                    this.deliverDialogProviderAbort(mapDialogImpl, MAPAbortProviderReason.AbnormalMAPDialogueLocal, MAPAbortSource.MAPProblem, null);
                    mapDialogImpl.setState(MAPDialogState.EXPUNGED);
                    return;
                }
            }
            extensionContainer = null;
            userInfo = tcContinueIndication.getUserInformation();
            if (userInfo == null) ** GOTO lbl99
            mapAcceptInfoImpl = new MAPAcceptInfoImpl();
            if (!userInfo.isOid() || (mapDialAs = MAPDialogueAS.getInstance((long[])(oid = userInfo.getOidValue()))) == null || !userInfo.isAsn()) ** GOTO lbl99
            try {
                asnData = userInfo.getEncodeType();
                ais = new AsnInputStream(asnData);
                tag = ais.readTag();
                if (tag == 1) {
                    mapAcceptInfoImpl.decodeAll(ais);
                    extensionContainer = mapAcceptInfoImpl.getExtensionContainer();
                }
                ** GOTO lbl99
            }
            catch (AsnException e) {
                e.printStackTrace();
                this.loger.error((Object)("AsnException when parsing MAP-ACCEPT Pdu: " + e.getMessage()), (Throwable)e);
                mapDialogImpl.getTcapDialog().getDialogLock().unlock();
                return;
            }
            catch (IOException e) {
                block38: {
                    e.printStackTrace();
                    this.loger.error((Object)("IOException when parsing MAP-ACCEPT Pdu: " + e.getMessage()), (Throwable)e);
                    break block38;
                    catch (MAPParsingComponentException e) {
                        e.printStackTrace();
                        this.loger.error((Object)("MAPException when parsing MAP-ACCEPT Pdu: " + e.getMessage()), (Throwable)e);
                    }
                }
                mapDialogImpl.delayedAreaState = MAPDialogImpl.DelayedAreaState.No;
                mapDialogImpl.setState(MAPDialogState.ACTIVE);
                this.deliverDialogAccept(mapDialogImpl, extensionContainer);
                if (mapDialogImpl.getState() == MAPDialogState.EXPUNGED) {
                    this.finishComponentProcessingState(mapDialogImpl);
                    return;
                }
lbl107:
                // 1 sources

                mapDialogImpl.delayedAreaState = MAPDialogImpl.DelayedAreaState.No;
                finally {
                }
            }
            if (mapDialogImpl.getState() == MAPDialogState.INITIAL_SENT || mapDialogImpl.getState() == MAPDialogState.ACTIVE) {
                comps = tcContinueIndication.getComponents();
                if (comps != null) {
                    this.processComponents(mapDialogImpl, comps);
                }
            } else {
                this.loger.error((Object)String.format("Received TC-CONTINUE. MAPDialog=%s. But state is neither InitialSent or Active", new Object[]{mapDialogImpl}));
            }
            this.deliverDialogDelimiter(mapDialogImpl);
            this.finishComponentProcessingState(mapDialogImpl);
            return;
        }
        finally {
            mapDialogImpl.getTcapDialog().getDialogLock().unlock();
        }
    }

    /*
     * Exception decompiling
     */
    public void onTCEnd(TCEndIndication tcEndIndication) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 19[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void onTCUni(TCUniIndication arg0) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onInvokeTimeout(Invoke invoke) {
        MAPDialogImpl mapDialogImpl = (MAPDialogImpl)this.getMAPDialog(((InvokeImpl)invoke).getDialog().getLocalDialogId());
        if (mapDialogImpl != null) {
            try {
                mapDialogImpl.getTcapDialog().getDialogLock().lock();
                if (mapDialogImpl.getState() != MAPDialogState.EXPUNGED) {
                    MAPServiceBaseImpl perfSer = (MAPServiceBaseImpl)mapDialogImpl.getService();
                    if (invoke.getInvokeClass() == InvokeClass.Class4) {
                        return;
                    }
                    perfSer.deliverInvokeTimeout(mapDialogImpl, invoke);
                }
            }
            finally {
                mapDialogImpl.getTcapDialog().getDialogLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDialogTimeout(Dialog tcapDialog) {
        MAPDialogImpl mapDialogImpl = (MAPDialogImpl)this.getMAPDialog(tcapDialog.getLocalDialogId());
        if (mapDialogImpl != null) {
            try {
                mapDialogImpl.getTcapDialog().getDialogLock().lock();
                if (mapDialogImpl.getState() != MAPDialogState.EXPUNGED) {
                    this.deliverDialogTimeout(mapDialogImpl);
                }
            }
            finally {
                mapDialogImpl.getTcapDialog().getDialogLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDialogReleased(Dialog tcapDialog) {
        MAPDialogImpl mapDialogImpl = this.removeDialog(tcapDialog.getLocalDialogId());
        if (mapDialogImpl != null) {
            try {
                mapDialogImpl.getTcapDialog().getDialogLock().lock();
                this.deliverDialogRelease(mapDialogImpl);
            }
            finally {
                mapDialogImpl.getTcapDialog().getDialogLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTCPAbort(TCPAbortIndication tcPAbortIndication) {
        Dialog tcapDialog = tcPAbortIndication.getDialog();
        MAPDialogImpl mapDialogImpl = this.getTCAPProvider().getPreviewMode() ? (MAPDialogImpl)((DialogImpl)tcapDialog).getPrevewDialogData().getUpperDialog() : (MAPDialogImpl)this.getMAPDialog(tcapDialog.getLocalDialogId());
        if (mapDialogImpl == null) {
            this.loger.error((Object)("MAP Dialog not found for Dialog Id " + tcapDialog.getLocalDialogId()));
            return;
        }
        try {
            mapDialogImpl.getTcapDialog().getDialogLock().lock();
            mapDialogImpl.tcapMessageType = MessageType.Abort;
            PAbortCauseType pAbortCause = tcPAbortIndication.getPAbortCause();
            MAPAbortProviderReason abortProviderReason = MAPAbortProviderReason.ProviderMalfunction;
            MAPAbortSource abortSource = MAPAbortSource.TCProblem;
            switch (pAbortCause) {
                case UnrecognizedMessageType: 
                case BadlyFormattedTxPortion: 
                case AbnormalDialogue: 
                case NoReasonGiven: {
                    abortProviderReason = MAPAbortProviderReason.ProviderMalfunction;
                    break;
                }
                case UnrecognizedTxID: {
                    abortProviderReason = MAPAbortProviderReason.SupportingDialogueTransactionReleased;
                    break;
                }
                case IncorrectTxPortion: {
                    if (mapDialogImpl.getState() == MAPDialogState.INITIAL_SENT) {
                        abortProviderReason = MAPAbortProviderReason.VersionIncompatibility;
                        break;
                    }
                    abortProviderReason = MAPAbortProviderReason.ProviderMalfunction;
                    break;
                }
                case ResourceLimitation: {
                    abortProviderReason = MAPAbortProviderReason.ResourceLimitation;
                    break;
                }
                case NoCommonDialoguePortion: {
                    abortProviderReason = MAPAbortProviderReason.VersionIncompatibilityTcap;
                }
            }
            if (abortProviderReason == MAPAbortProviderReason.VersionIncompatibility) {
                this.deliverDialogReject(mapDialogImpl, MAPRefuseReason.PotentialVersionIncompatibility, null, null);
            } else if (abortProviderReason == MAPAbortProviderReason.VersionIncompatibilityTcap) {
                this.deliverDialogReject(mapDialogImpl, MAPRefuseReason.PotentialVersionIncompatibilityTcap, null, null);
            } else {
                this.deliverDialogProviderAbort(mapDialogImpl, abortProviderReason, abortSource, null);
            }
            mapDialogImpl.setState(MAPDialogState.EXPUNGED);
        }
        finally {
            mapDialogImpl.getTcapDialog().getDialogLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTCUserAbort(TCUserAbortIndication tcUserAbortIndication) {
        Dialog tcapDialog = tcUserAbortIndication.getDialog();
        MAPDialogImpl mapDialogImpl = this.getTCAPProvider().getPreviewMode() ? (MAPDialogImpl)((DialogImpl)tcapDialog).getPrevewDialogData().getUpperDialog() : (MAPDialogImpl)this.getMAPDialog(tcapDialog.getLocalDialogId());
        if (mapDialogImpl == null) {
            this.loger.error((Object)("MAP Dialog not found for Dialog Id " + tcapDialog.getLocalDialogId()));
            return;
        }
        try {
            ResultSourceDiagnostic resultSourceDiagnostic;
            mapDialogImpl.getTcapDialog().getDialogLock().lock();
            mapDialogImpl.tcapMessageType = MessageType.Abort;
            UserInformation userInfo = tcUserAbortIndication.getUserInformation();
            ParsePduResult parsePduResult = ParsePduResult.NoUserInfo;
            MAPRefuseReason mapRefuseReason = MAPRefuseReason.NoReasonGiven;
            MAPUserAbortChoice mapUserAbortChoice = null;
            MAPProviderAbortReason mapProviderAbortReason = null;
            MAPAbortProviderReason abortProviderReason = MAPAbortProviderReason.AbnormalMAPDialogueFromPeer;
            MAPExtensionContainer extensionContainer = null;
            if (userInfo != null) {
                if (!userInfo.isOid()) {
                    this.loger.error((Object)"When parsing TCUserAbortIndication indication: userInfo.isOid() check failed");
                    parsePduResult = ParsePduResult.BadUserInfo;
                } else {
                    long[] oid = userInfo.getOidValue();
                    MAPDialogueAS mapDialAs = MAPDialogueAS.getInstance((long[])oid);
                    if (mapDialAs == null) {
                        this.loger.error((Object)"When parsing TCUserAbortIndication indication: userInfo.getOidValue() must be userInfoMAPDialogueAS.MAP_DialogueAS");
                        parsePduResult = ParsePduResult.BadUserInfo;
                    } else if (!userInfo.isAsn()) {
                        this.loger.error((Object)"When parsing TCUserAbortIndication indication: userInfo.isAsn() check failed");
                        parsePduResult = ParsePduResult.BadUserInfo;
                    } else {
                        try {
                            byte[] asnData = userInfo.getEncodeType();
                            AsnInputStream ais = new AsnInputStream(asnData);
                            int tag = ais.readTag();
                            switch (tag) {
                                case 3: {
                                    MAPRefuseInfoImpl mapRefuseInfoImpl = new MAPRefuseInfoImpl();
                                    mapRefuseInfoImpl.decodeAll(ais);
                                    switch (mapRefuseInfoImpl.getReason()) {
                                        case invalidOriginatingReference: {
                                            mapRefuseReason = MAPRefuseReason.InvalidOriginatingReference;
                                            break;
                                        }
                                        case invalidDestinationReference: {
                                            mapRefuseReason = MAPRefuseReason.InvalidDestinationReference;
                                        }
                                    }
                                    extensionContainer = mapRefuseInfoImpl.getExtensionContainer();
                                    parsePduResult = ParsePduResult.MapRefuse;
                                    break;
                                }
                                case 4: {
                                    MAPUserAbortInfoImpl mapUserAbortInfoImpl = new MAPUserAbortInfoImpl();
                                    mapUserAbortInfoImpl.decodeAll(ais);
                                    mapUserAbortChoice = mapUserAbortInfoImpl.getMAPUserAbortChoice();
                                    extensionContainer = mapUserAbortInfoImpl.getExtensionContainer();
                                    parsePduResult = ParsePduResult.MapUserAbort;
                                    break;
                                }
                                case 5: {
                                    MAPProviderAbortInfoImpl mapProviderAbortInfoImpl = new MAPProviderAbortInfoImpl();
                                    mapProviderAbortInfoImpl.decodeAll(ais);
                                    mapProviderAbortReason = mapProviderAbortInfoImpl.getMAPProviderAbortReason();
                                    switch (mapProviderAbortReason) {
                                        case abnormalDialogue: {
                                            abortProviderReason = MAPAbortProviderReason.AbnormalMAPDialogueFromPeer;
                                            break;
                                        }
                                        case invalidPDU: {
                                            abortProviderReason = MAPAbortProviderReason.InvalidPDU;
                                        }
                                    }
                                    extensionContainer = mapProviderAbortInfoImpl.getExtensionContainer();
                                    parsePduResult = ParsePduResult.MapProviderAbort;
                                    break;
                                }
                                default: {
                                    this.loger.error((Object)"When parsing TCUserAbortIndication indication: userInfogetEncodeType().Tag must be either MAP_REFUSE_INFO_TAG or MAP_USER_ABORT_INFO_TAG or MAP_PROVIDER_ABORT_INFO_TAG");
                                    parsePduResult = ParsePduResult.BadUserInfo;
                                    break;
                                }
                            }
                        }
                        catch (AsnException e) {
                            this.loger.error((Object)("When parsing TCUserAbortIndication indication: AsnException" + e.getMessage()), (Throwable)e);
                            parsePduResult = ParsePduResult.BadUserInfo;
                        }
                        catch (IOException e) {
                            this.loger.error((Object)("When parsing TCUserAbortIndication indication: IOException" + e.getMessage()), (Throwable)e);
                            parsePduResult = ParsePduResult.BadUserInfo;
                        }
                        catch (MAPParsingComponentException e) {
                            this.loger.error((Object)("When parsing TCUserAbortIndication indication: MAPParsingComponentException" + e.getMessage()), (Throwable)e);
                            parsePduResult = ParsePduResult.BadUserInfo;
                        }
                    }
                }
            }
            if (tcUserAbortIndication.IsAareApdu().booleanValue() && (resultSourceDiagnostic = tcUserAbortIndication.getResultSourceDiagnostic()) != null) {
                if (resultSourceDiagnostic.getDialogServiceUserType() == DialogServiceUserType.AcnNotSupported) {
                    if (mapDialogImpl.getState() == MAPDialogState.INITIAL_SENT) {
                        this.deliverDialogReject(mapDialogImpl, MAPRefuseReason.ApplicationContextNotSupported, tcUserAbortIndication.getApplicationContextName(), extensionContainer);
                        mapDialogImpl.setState(MAPDialogState.EXPUNGED);
                        return;
                    }
                    parsePduResult = ParsePduResult.BadUserInfo;
                } else if (resultSourceDiagnostic.getDialogServiceProviderType() == DialogServiceProviderType.NoCommonDialogPortion) {
                    if (mapDialogImpl.getState() == MAPDialogState.INITIAL_SENT) {
                        this.deliverDialogReject(mapDialogImpl, MAPRefuseReason.PotentialVersionIncompatibilityTcap, null, null);
                        mapDialogImpl.setState(MAPDialogState.EXPUNGED);
                        return;
                    }
                    parsePduResult = ParsePduResult.BadUserInfo;
                }
            }
            switch (parsePduResult) {
                case NoUserInfo: {
                    if (mapDialogImpl.getState() == MAPDialogState.INITIAL_SENT) {
                        this.deliverDialogReject(mapDialogImpl, MAPRefuseReason.NoReasonGiven, null, null);
                        break;
                    }
                    this.deliverDialogProviderAbort(mapDialogImpl, MAPAbortProviderReason.AbnormalMAPDialogueLocal, MAPAbortSource.MAPProblem, null);
                    break;
                }
                case BadUserInfo: {
                    this.deliverDialogProviderAbort(mapDialogImpl, MAPAbortProviderReason.AbnormalMAPDialogueLocal, MAPAbortSource.MAPProblem, null);
                    break;
                }
                case MapRefuse: {
                    if (mapDialogImpl.getState() == MAPDialogState.INITIAL_SENT) {
                        this.deliverDialogReject(mapDialogImpl, mapRefuseReason, null, extensionContainer);
                        break;
                    }
                    this.deliverDialogProviderAbort(mapDialogImpl, MAPAbortProviderReason.AbnormalMAPDialogueLocal, MAPAbortSource.MAPProblem, null);
                    break;
                }
                case MapUserAbort: {
                    this.deliverDialogUserAbort(mapDialogImpl, mapUserAbortChoice, extensionContainer);
                    break;
                }
                case MapProviderAbort: {
                    this.deliverDialogProviderAbort(mapDialogImpl, abortProviderReason, MAPAbortSource.MAPProblem, extensionContainer);
                }
            }
            mapDialogImpl.setState(MAPDialogState.EXPUNGED);
        }
        finally {
            mapDialogImpl.getTcapDialog().getDialogLock().unlock();
        }
    }

    private void processComponents(MAPDialogImpl mapDialogImpl, Component[] components) {
        for (Component c : components) {
            this.doProcessComponent(mapDialogImpl, c);
        }
    }

    private void doProcessComponent(MAPDialogImpl mapDialogImpl, Component c) {
        MAPServiceBaseImpl perfSer = (MAPServiceBaseImpl)mapDialogImpl.getService();
        try {
            Parameter parameter;
            OperationCode oc;
            ComponentType compType = c.getType();
            Long invokeId = c.getInvokeId();
            Long linkedId = 0L;
            Invoke linkedInvoke = null;
            switch (compType) {
                case Invoke: {
                    Invoke comp = (Invoke)c;
                    oc = comp.getOperationCode();
                    parameter = comp.getParameter();
                    linkedId = comp.getLinkedId();
                    if (linkedId == null) break;
                    linkedInvoke = comp.getLinkedInvoke();
                    long[] lstInv = perfSer.getLinkedOperationList(linkedInvoke.getOperationCode().getLocalOperationCode());
                    if (lstInv == null) {
                        Problem problem = this.getTCAPProvider().getComponentPrimitiveFactory().createProblem(ProblemType.Invoke);
                        problem.setInvokeProblemType(InvokeProblemType.LinkedResponseUnexpected);
                        mapDialogImpl.sendRejectComponent(invokeId, problem);
                        perfSer.deliverRejectComponent(mapDialogImpl, invokeId, problem, true);
                        return;
                    }
                    boolean found = false;
                    if (lstInv != null) {
                        for (long l : lstInv) {
                            if (l != comp.getOperationCode().getLocalOperationCode()) continue;
                            found = true;
                            break;
                        }
                    }
                    if (found) break;
                    Problem problem = this.getTCAPProvider().getComponentPrimitiveFactory().createProblem(ProblemType.Invoke);
                    problem.setInvokeProblemType(InvokeProblemType.UnexpectedLinkedOperation);
                    mapDialogImpl.sendRejectComponent(invokeId, problem);
                    perfSer.deliverRejectComponent(mapDialogImpl, invokeId, problem, true);
                    return;
                }
                case ReturnResult: {
                    Invoke comp = (ReturnResult)c;
                    oc = comp.getOperationCode();
                    parameter = comp.getParameter();
                    break;
                }
                case ReturnResultLast: {
                    Invoke comp = (ReturnResultLast)c;
                    oc = comp.getOperationCode();
                    parameter = comp.getParameter();
                    break;
                }
                case ReturnError: {
                    ReturnError comp = (ReturnError)c;
                    long errorCode = 0L;
                    if (comp.getErrorCode() != null && comp.getErrorCode().getErrorType() == ErrorCodeType.Local) {
                        errorCode = comp.getErrorCode().getLocalErrorCode();
                    }
                    if (errorCode < 1L || errorCode > 72L) {
                        Problem problem = this.getTCAPProvider().getComponentPrimitiveFactory().createProblem(ProblemType.ReturnError);
                        problem.setReturnErrorProblemType(ReturnErrorProblemType.UnrecognizedError);
                        mapDialogImpl.sendRejectComponent(invokeId, problem);
                        perfSer.deliverRejectComponent(mapDialogImpl, invokeId, problem, true);
                        return;
                    }
                    MAPErrorMessage msgErr = this.mapErrorMessageFactory.createMessageFromErrorCode(Long.valueOf(errorCode));
                    try {
                        Parameter p = comp.getParameter();
                        if (p != null && p.getData() != null) {
                            byte[] data = p.getData();
                            AsnInputStream ais = new AsnInputStream(data, p.getTagClass(), p.isPrimitive(), p.getTag());
                            ((MAPErrorMessageImpl)msgErr).decodeData(ais, data.length);
                        }
                    }
                    catch (MAPParsingComponentException e) {
                        Problem problem = this.getTCAPProvider().getComponentPrimitiveFactory().createProblem(ProblemType.ReturnError);
                        problem.setReturnErrorProblemType(ReturnErrorProblemType.MistypedParameter);
                        mapDialogImpl.sendRejectComponent(invokeId, problem);
                        perfSer.deliverRejectComponent(mapDialogImpl, invokeId, problem, true);
                        return;
                    }
                    perfSer.deliverErrorComponent(mapDialogImpl, comp.getInvokeId(), msgErr);
                    return;
                }
                case Reject: {
                    Reject rej = (Reject)c;
                    perfSer.deliverRejectComponent(mapDialogImpl, rej.getInvokeId(), rej.getProblem(), rej.isLocalOriginated());
                    return;
                }
                default: {
                    return;
                }
            }
            try {
                perfSer.processComponent(compType, oc, parameter, mapDialogImpl, invokeId, linkedId, linkedInvoke);
            }
            catch (MAPParsingComponentException e) {
                this.loger.error((Object)("MAPParsingComponentException when parsing components: " + e.getReason().toString() + " - " + e.getMessage()), (Throwable)e);
                switch (e.getReason()) {
                    case UnrecognizedOperation: {
                        Problem problem;
                        if (compType == ComponentType.Invoke) {
                            problem = this.getTCAPProvider().getComponentPrimitiveFactory().createProblem(ProblemType.Invoke);
                            problem.setInvokeProblemType(InvokeProblemType.UnrecognizedOperation);
                            mapDialogImpl.sendRejectComponent(invokeId, problem);
                            perfSer.deliverRejectComponent(mapDialogImpl, invokeId, problem, true);
                            break;
                        }
                        problem = this.getTCAPProvider().getComponentPrimitiveFactory().createProblem(ProblemType.ReturnResult);
                        problem.setReturnResultProblemType(ReturnResultProblemType.MistypedParameter);
                        mapDialogImpl.sendRejectComponent(invokeId, problem);
                        perfSer.deliverRejectComponent(mapDialogImpl, invokeId, problem, true);
                        break;
                    }
                    case MistypedParameter: {
                        Problem problem;
                        if (compType == ComponentType.Invoke) {
                            problem = this.getTCAPProvider().getComponentPrimitiveFactory().createProblem(ProblemType.Invoke);
                            problem.setInvokeProblemType(InvokeProblemType.MistypedParameter);
                            mapDialogImpl.sendRejectComponent(invokeId, problem);
                            perfSer.deliverRejectComponent(mapDialogImpl, invokeId, problem, true);
                            break;
                        }
                        problem = this.getTCAPProvider().getComponentPrimitiveFactory().createProblem(ProblemType.ReturnResult);
                        problem.setReturnResultProblemType(ReturnResultProblemType.MistypedParameter);
                        mapDialogImpl.sendRejectComponent(invokeId, problem);
                        perfSer.deliverRejectComponent(mapDialogImpl, invokeId, problem, true);
                    }
                }
            }
        }
        catch (MAPException e) {
            this.loger.error((Object)("Error processing a Component: " + e.getMessage() + "\nComponent" + c), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTCNotice(TCNoticeIndication ind) {
        if (this.getTCAPProvider().getPreviewMode()) {
            return;
        }
        Dialog tcapDialog = ind.getDialog();
        if (tcapDialog == null) {
            return;
        }
        MAPDialogImpl mapDialogImpl = (MAPDialogImpl)this.getMAPDialog(tcapDialog.getLocalDialogId());
        if (mapDialogImpl == null) {
            this.loger.error((Object)("MAP Dialog not found for Dialog Id " + tcapDialog.getLocalDialogId()));
            return;
        }
        try {
            mapDialogImpl.getTcapDialog().getDialogLock().lock();
            if (mapDialogImpl.getState() == MAPDialogState.INITIAL_SENT) {
                this.deliverDialogReject(mapDialogImpl, MAPRefuseReason.RemoteNodeNotReachable, null, null);
                mapDialogImpl.setState(MAPDialogState.EXPUNGED);
            } else if (mapDialogImpl.getState() == MAPDialogState.ACTIVE) {
                this.deliverDialogNotice(mapDialogImpl, MAPNoticeProblemDiagnostic.MessageCannotBeDeliveredToThePeer);
            }
        }
        finally {
            mapDialogImpl.getTcapDialog().getDialogLock().unlock();
        }
    }

    private void deliverDialogDelimiter(MAPDialog mapDialog) {
        for (MAPDialogListener listener : this.dialogListeners) {
            listener.onDialogDelimiter(mapDialog);
        }
    }

    private void deliverDialogRequest(MAPDialog mapDialog, AddressString destReference, AddressString origReference, MAPExtensionContainer extensionContainer) {
        for (MAPDialogListener listener : this.dialogListeners) {
            listener.onDialogRequest(mapDialog, destReference, origReference, extensionContainer);
        }
    }

    private void deliverDialogRequestEri(MAPDialog mapDialog, AddressString destReference, AddressString origReference, AddressString eriMsisdn, AddressString eriVlrNo) {
        for (MAPDialogListener listener : this.dialogListeners) {
            listener.onDialogRequestEricsson(mapDialog, destReference, origReference, eriMsisdn, eriVlrNo);
        }
    }

    private void deliverDialogAccept(MAPDialog mapDialog, MAPExtensionContainer extensionContainer) {
        for (MAPDialogListener listener : this.dialogListeners) {
            listener.onDialogAccept(mapDialog, extensionContainer);
        }
    }

    private void deliverDialogReject(MAPDialog mapDialog, MAPRefuseReason refuseReason, ApplicationContextName alternativeApplicationContext, MAPExtensionContainer extensionContainer) {
        for (MAPDialogListener listener : this.dialogListeners) {
            listener.onDialogReject(mapDialog, refuseReason, alternativeApplicationContext, extensionContainer);
        }
    }

    private void deliverDialogClose(MAPDialog mapDialog) {
        for (MAPDialogListener listener : this.dialogListeners) {
            listener.onDialogClose(mapDialog);
        }
    }

    private void deliverDialogProviderAbort(MAPDialog mapDialog, MAPAbortProviderReason abortProviderReason, MAPAbortSource abortSource, MAPExtensionContainer extensionContainer) {
        for (MAPDialogListener listener : this.dialogListeners) {
            listener.onDialogProviderAbort(mapDialog, abortProviderReason, abortSource, extensionContainer);
        }
    }

    private void deliverDialogUserAbort(MAPDialog mapDialog, MAPUserAbortChoice userReason, MAPExtensionContainer extensionContainer) {
        for (MAPDialogListener listener : this.dialogListeners) {
            listener.onDialogUserAbort(mapDialog, userReason, extensionContainer);
        }
    }

    protected void deliverDialogNotice(MAPDialog mapDialog, MAPNoticeProblemDiagnostic noticeProblemDiagnostic) {
        for (MAPDialogListener listener : this.dialogListeners) {
            listener.onDialogNotice(mapDialog, noticeProblemDiagnostic);
        }
    }

    protected void deliverDialogRelease(MAPDialog mapDialog) {
        for (MAPDialogListener listener : this.dialogListeners) {
            listener.onDialogRelease(mapDialog);
        }
    }

    protected void deliverDialogTimeout(MAPDialog mapDialog) {
        for (MAPDialogListener listener : this.dialogListeners) {
            listener.onDialogTimeout(mapDialog);
        }
    }

    protected void fireTCBegin(Dialog tcapDialog, ApplicationContextName acn, AddressString destReference, AddressString origReference, MAPExtensionContainer mapExtensionContainer, boolean isEriStyle, AddressString eriMsisdn, AddressString vlrNoEri, boolean returnMessageOnError) throws MAPException {
        if (this.getTCAPProvider().getPreviewMode()) {
            return;
        }
        TCBeginRequest tcBeginReq = this.encodeTCBegin(tcapDialog, acn, destReference, origReference, mapExtensionContainer, isEriStyle, eriMsisdn, vlrNoEri);
        if (returnMessageOnError) {
            tcBeginReq.setReturnMessageOnError(true);
        }
        try {
            tcapDialog.send(tcBeginReq);
        }
        catch (TCAPSendException e) {
            throw new MAPException(e.getMessage(), (Throwable)e);
        }
    }

    protected TCBeginRequest encodeTCBegin(Dialog tcapDialog, ApplicationContextName acn, AddressString destReference, AddressString origReference, MAPExtensionContainer mapExtensionContainer, boolean eriStyle, AddressString eriMsisdn, AddressString eriVlrNo) throws MAPException {
        TCBeginRequest tcBeginReq = this.getTCAPProvider().getDialogPrimitiveFactory().createBegin(tcapDialog);
        if (MAPApplicationContext.getProtocolVersion((long[])acn.getOid()) > 1) {
            tcBeginReq.setApplicationContextName(acn);
        }
        if ((destReference != null || origReference != null || mapExtensionContainer != null || eriStyle) && MAPApplicationContext.getProtocolVersion((long[])acn.getOid()) > 1) {
            MAPOpenInfoImpl mapOpn = new MAPOpenInfoImpl();
            mapOpn.setDestReference(destReference);
            mapOpn.setOrigReference(origReference);
            mapOpn.setExtensionContainer(mapExtensionContainer);
            mapOpn.setEriStyle(eriStyle);
            mapOpn.setEriMsisdn(eriMsisdn);
            mapOpn.setEriVlrNo(eriVlrNo);
            AsnOutputStream localasnOs = new AsnOutputStream();
            mapOpn.encodeAll(localasnOs);
            UserInformation userInformation = TcapFactory.createUserInformation();
            userInformation.setOid(true);
            userInformation.setOidValue(MAPDialogueAS.MAP_DialogueAS.getOID());
            userInformation.setAsn(true);
            userInformation.setEncodeType(localasnOs.toByteArray());
            tcBeginReq.setUserInformation(userInformation);
        }
        return tcBeginReq;
    }

    protected void fireTCContinue(Dialog tcapDialog, Boolean sendMapAcceptInfo, ApplicationContextName acn, MAPExtensionContainer mapExtensionContainer, boolean returnMessageOnError) throws MAPException {
        if (this.getTCAPProvider().getPreviewMode()) {
            return;
        }
        TCContinueRequest tcContinueReq = this.encodeTCContinue(tcapDialog, sendMapAcceptInfo, acn, mapExtensionContainer);
        if (returnMessageOnError) {
            tcContinueReq.setReturnMessageOnError(true);
        }
        try {
            tcapDialog.send(tcContinueReq);
        }
        catch (TCAPSendException e) {
            throw new MAPException(e.getMessage(), (Throwable)e);
        }
    }

    protected TCContinueRequest encodeTCContinue(Dialog tcapDialog, Boolean sendMapAcceptInfo, ApplicationContextName acn, MAPExtensionContainer mapExtensionContainer) throws MAPException {
        TCContinueRequest tcContinueReq = this.getTCAPProvider().getDialogPrimitiveFactory().createContinue(tcapDialog);
        if (acn != null && MAPApplicationContext.getProtocolVersion((long[])acn.getOid()) > 1) {
            tcContinueReq.setApplicationContextName(acn);
        }
        if (sendMapAcceptInfo.booleanValue() && mapExtensionContainer != null && MAPApplicationContext.getProtocolVersion((long[])acn.getOid()) > 1) {
            MAPAcceptInfoImpl mapAccept = new MAPAcceptInfoImpl();
            mapAccept.setExtensionContainer(mapExtensionContainer);
            AsnOutputStream localasnOs = new AsnOutputStream();
            mapAccept.encodeAll(localasnOs);
            UserInformation userInformation = TcapFactory.createUserInformation();
            userInformation.setOid(true);
            userInformation.setOidValue(MAPDialogueAS.MAP_DialogueAS.getOID());
            userInformation.setAsn(true);
            userInformation.setEncodeType(localasnOs.toByteArray());
            tcContinueReq.setUserInformation(userInformation);
        }
        return tcContinueReq;
    }

    protected void fireTCEnd(Dialog tcapDialog, Boolean sendMapCloseInfo, boolean prearrangedEnd, ApplicationContextName acn, MAPExtensionContainer mapExtensionContainer, boolean returnMessageOnError) throws MAPException {
        if (this.getTCAPProvider().getPreviewMode()) {
            return;
        }
        TCEndRequest endRequest = this.encodeTCEnd(tcapDialog, sendMapCloseInfo, prearrangedEnd, acn, mapExtensionContainer);
        if (returnMessageOnError) {
            endRequest.setReturnMessageOnError(true);
        }
        try {
            tcapDialog.send(endRequest);
        }
        catch (TCAPSendException e) {
            throw new MAPException(e.getMessage(), (Throwable)e);
        }
    }

    protected TCEndRequest encodeTCEnd(Dialog tcapDialog, Boolean sendMapCloseInfo, boolean prearrangedEnd, ApplicationContextName acn, MAPExtensionContainer mapExtensionContainer) throws MAPException {
        TCEndRequest endRequest = this.getTCAPProvider().getDialogPrimitiveFactory().createEnd(tcapDialog);
        if (!prearrangedEnd) {
            endRequest.setTermination(TerminationType.Basic);
        } else {
            endRequest.setTermination(TerminationType.PreArranged);
        }
        if (acn != null && MAPApplicationContext.getProtocolVersion((long[])acn.getOid()) > 1) {
            endRequest.setApplicationContextName(acn);
        }
        if (sendMapCloseInfo.booleanValue() && mapExtensionContainer != null && MAPApplicationContext.getProtocolVersion((long[])acn.getOid()) > 1) {
            MAPAcceptInfoImpl mapAccept = new MAPAcceptInfoImpl();
            mapAccept.setExtensionContainer(mapExtensionContainer);
            AsnOutputStream localasnOs = new AsnOutputStream();
            mapAccept.encodeAll(localasnOs);
            UserInformation userInformation = TcapFactory.createUserInformation();
            userInformation.setOid(true);
            userInformation.setOidValue(MAPDialogueAS.MAP_DialogueAS.getOID());
            userInformation.setAsn(true);
            userInformation.setEncodeType(localasnOs.toByteArray());
            endRequest.setUserInformation(userInformation);
        }
        return endRequest;
    }

    private void fireTCAbortACNNotSupported(Dialog tcapDialog, MAPExtensionContainer mapExtensionContainer, ApplicationContextName alternativeApplicationContext, boolean returnMessageOnError) throws MAPException {
        if (this.getTCAPProvider().getPreviewMode()) {
            return;
        }
        if (tcapDialog.getApplicationContextName() == null) {
            this.fireTCAbortV1(tcapDialog, returnMessageOnError);
        }
        TCUserAbortRequest tcUserAbort = this.getTCAPProvider().getDialogPrimitiveFactory().createUAbort(tcapDialog);
        MAPRefuseInfoImpl mapRefuseInfoImpl = new MAPRefuseInfoImpl();
        mapRefuseInfoImpl.setReason(Reason.noReasonGiven);
        AsnOutputStream localasnOs = new AsnOutputStream();
        mapRefuseInfoImpl.encodeAll(localasnOs);
        UserInformation userInformation = TcapFactory.createUserInformation();
        userInformation.setOid(true);
        userInformation.setOidValue(MAPDialogueAS.MAP_DialogueAS.getOID());
        userInformation.setAsn(true);
        userInformation.setEncodeType(localasnOs.toByteArray());
        if (returnMessageOnError) {
            tcUserAbort.setReturnMessageOnError(true);
        }
        if (alternativeApplicationContext != null) {
            tcUserAbort.setApplicationContextName(alternativeApplicationContext);
        } else {
            tcUserAbort.setApplicationContextName(tcapDialog.getApplicationContextName());
        }
        tcUserAbort.setDialogServiceUserType(DialogServiceUserType.AcnNotSupported);
        tcUserAbort.setUserInformation(userInformation);
        try {
            tcapDialog.send(tcUserAbort);
        }
        catch (TCAPSendException e) {
            throw new MAPException(e.getMessage(), (Throwable)e);
        }
    }

    protected void fireTCAbortRefused(Dialog tcapDialog, Reason reason, MAPExtensionContainer mapExtensionContainer, boolean returnMessageOnError) throws MAPException {
        if (this.getTCAPProvider().getPreviewMode()) {
            return;
        }
        if (tcapDialog.getApplicationContextName() == null) {
            this.fireTCAbortV1(tcapDialog, returnMessageOnError);
        }
        TCUserAbortRequest tcUserAbort = this.getTCAPProvider().getDialogPrimitiveFactory().createUAbort(tcapDialog);
        MAPRefuseInfoImpl mapRefuseInfoImpl = new MAPRefuseInfoImpl();
        mapRefuseInfoImpl.setReason(reason);
        mapRefuseInfoImpl.setExtensionContainer(mapExtensionContainer);
        AsnOutputStream localasnOs = new AsnOutputStream();
        mapRefuseInfoImpl.encodeAll(localasnOs);
        UserInformation userInformation = TcapFactory.createUserInformation();
        userInformation.setOid(true);
        userInformation.setOidValue(MAPDialogueAS.MAP_DialogueAS.getOID());
        userInformation.setAsn(true);
        userInformation.setEncodeType(localasnOs.toByteArray());
        tcUserAbort.setApplicationContextName(tcapDialog.getApplicationContextName());
        tcUserAbort.setDialogServiceUserType(DialogServiceUserType.NoReasonGive);
        tcUserAbort.setUserInformation(userInformation);
        if (returnMessageOnError) {
            tcUserAbort.setReturnMessageOnError(true);
        }
        try {
            tcapDialog.send(tcUserAbort);
        }
        catch (TCAPSendException e) {
            throw new MAPException(e.getMessage(), (Throwable)e);
        }
    }

    protected void fireTCAbortUser(Dialog tcapDialog, MAPUserAbortChoice mapUserAbortChoice, MAPExtensionContainer mapExtensionContainer, boolean returnMessageOnError) throws MAPException {
        if (this.getTCAPProvider().getPreviewMode()) {
            return;
        }
        if (tcapDialog.getApplicationContextName() == null) {
            this.fireTCAbortV1(tcapDialog, returnMessageOnError);
        }
        TCUserAbortRequest tcUserAbort = this.getTCAPProvider().getDialogPrimitiveFactory().createUAbort(tcapDialog);
        MAPUserAbortInfoImpl mapUserAbortInfoImpl = new MAPUserAbortInfoImpl();
        mapUserAbortInfoImpl.setMAPUserAbortChoice(mapUserAbortChoice);
        mapUserAbortInfoImpl.setExtensionContainer(mapExtensionContainer);
        AsnOutputStream localasnOs = new AsnOutputStream();
        mapUserAbortInfoImpl.encodeAll(localasnOs);
        UserInformation userInformation = TcapFactory.createUserInformation();
        userInformation.setOid(true);
        userInformation.setOidValue(MAPDialogueAS.MAP_DialogueAS.getOID());
        userInformation.setAsn(true);
        userInformation.setEncodeType(localasnOs.toByteArray());
        if (returnMessageOnError) {
            tcUserAbort.setReturnMessageOnError(true);
        }
        tcUserAbort.setUserInformation(userInformation);
        try {
            tcapDialog.send(tcUserAbort);
        }
        catch (TCAPSendException e) {
            throw new MAPException(e.getMessage(), (Throwable)e);
        }
    }

    protected void fireTCAbortProvider(Dialog tcapDialog, MAPProviderAbortReason mapProviderAbortReason, MAPExtensionContainer mapExtensionContainer, boolean returnMessageOnError) throws MAPException {
        if (this.getTCAPProvider().getPreviewMode()) {
            return;
        }
        if (tcapDialog.getApplicationContextName() == null) {
            this.fireTCAbortV1(tcapDialog, returnMessageOnError);
        }
        TCUserAbortRequest tcUserAbort = this.getTCAPProvider().getDialogPrimitiveFactory().createUAbort(tcapDialog);
        MAPProviderAbortInfoImpl mapProviderAbortInfo = new MAPProviderAbortInfoImpl();
        mapProviderAbortInfo.setMAPProviderAbortReason(mapProviderAbortReason);
        mapProviderAbortInfo.setExtensionContainer(mapExtensionContainer);
        AsnOutputStream localasnOs = new AsnOutputStream();
        mapProviderAbortInfo.encodeAll(localasnOs);
        UserInformation userInformation = TcapFactory.createUserInformation();
        userInformation.setOid(true);
        userInformation.setOidValue(MAPDialogueAS.MAP_DialogueAS.getOID());
        userInformation.setAsn(true);
        userInformation.setEncodeType(localasnOs.toByteArray());
        if (returnMessageOnError) {
            tcUserAbort.setReturnMessageOnError(true);
        }
        tcUserAbort.setUserInformation(userInformation);
        try {
            tcapDialog.send(tcUserAbort);
        }
        catch (TCAPSendException e) {
            throw new MAPException(e.getMessage(), (Throwable)e);
        }
    }

    protected void fireTCAbortV1(Dialog tcapDialog, boolean returnMessageOnError) throws MAPException {
        if (this.getTCAPProvider().getPreviewMode()) {
            return;
        }
        TCUserAbortRequest tcUserAbort = this.getTCAPProvider().getDialogPrimitiveFactory().createUAbort(tcapDialog);
        if (returnMessageOnError) {
            tcUserAbort.setReturnMessageOnError(true);
        }
        try {
            tcapDialog.send(tcUserAbort);
        }
        catch (TCAPSendException e) {
            throw new MAPException(e.getMessage(), (Throwable)e);
        }
    }

    public FastMap<Integer, NetworkIdState> getNetworkIdStateList() {
        return this.tcapProvider.getNetworkIdStateList();
    }

    public NetworkIdState getNetworkIdState(int networkId) {
        return this.tcapProvider.getNetworkIdState(networkId);
    }

    public void setUserPartCongestionLevel(String congObject, int level) {
        this.tcapProvider.setUserPartCongestionLevel(congObject, level);
    }

    public int getMemoryCongestionLevel() {
        return this.tcapProvider.getMemoryCongestionLevel();
    }

    public int getExecutorCongestionLevel() {
        return this.tcapProvider.getExecutorCongestionLevel();
    }

    public int getCumulativeCongestionLevel() {
        return this.tcapProvider.getCumulativeCongestionLevel();
    }

    public int getCurrentDialogsCount() {
        return this.tcapProvider.getCurrentDialogsCount();
    }

    private static enum ParsePduResult {
        NoUserInfo,
        BadUserInfo,
        MapRefuse,
        MapUserAbort,
        MapProviderAbort;

    }
}

