/*
 * Decompiled with CFR 0.152.
 */
package org.meruvian.yama.webapi.config;

import javax.inject.Inject;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.web.DispatcherServletAutoConfiguration;
import org.springframework.boot.context.embedded.FilterRegistrationBean;
import org.springframework.boot.context.embedded.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@AutoConfigureAfter(value={DispatcherServletAutoConfiguration.class})
public class WebConfig
extends WebMvcConfigurerAdapter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Inject
    private ResourceLoader resourceLoader;

    public void addViewControllers(ViewControllerRegistry registry) {
        this.log.debug("Configure view controllers");
        super.addViewControllers(registry);
        registry.addViewController("/login").setViewName("forward:/login.html");
        registry.addViewController("/register").setViewName("forward:/register.html");
        registry.addRedirectViewController("/oauth/approval", "/oauth_approval").setKeepQueryParams(true);
        registry.addViewController("/oauth_approval").setViewName("forward:/oauth_approval.html");
    }

    @Bean
    public FilterRegistrationBean urlRewriteFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean((Filter)new /* Unavailable Anonymous Inner Class!! */, new ServletRegistrationBean[0]);
        filter.addInitParameter("logLevel", "slf4j");
        return filter;
    }

    static /* synthetic */ ResourceLoader access$000(WebConfig x0) {
        return x0.resourceLoader;
    }
}

