/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.client.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.mariadb.jdbc.Configuration;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.ServerPreparedStatement;
import org.mariadb.jdbc.Statement;
import org.mariadb.jdbc.client.Client;
import org.mariadb.jdbc.client.Completion;
import org.mariadb.jdbc.client.Context;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.client.context.BaseContext;
import org.mariadb.jdbc.client.context.RedoContext;
import org.mariadb.jdbc.client.impl.ConnectionHelper;
import org.mariadb.jdbc.client.impl.PrepareCache;
import org.mariadb.jdbc.client.result.Result;
import org.mariadb.jdbc.client.result.StreamingResult;
import org.mariadb.jdbc.client.socket.Reader;
import org.mariadb.jdbc.client.socket.Writer;
import org.mariadb.jdbc.client.socket.impl.CompressInputStream;
import org.mariadb.jdbc.client.socket.impl.CompressOutputStream;
import org.mariadb.jdbc.client.socket.impl.PacketReader;
import org.mariadb.jdbc.client.socket.impl.PacketWriter;
import org.mariadb.jdbc.client.socket.impl.ReadAheadBufferedStream;
import org.mariadb.jdbc.client.socket.impl.UnixDomainSocket;
import org.mariadb.jdbc.client.tls.MariaDbX509EphemeralTrustingManager;
import org.mariadb.jdbc.client.util.ClosableLock;
import org.mariadb.jdbc.client.util.MutableByte;
import org.mariadb.jdbc.export.ExceptionFactory;
import org.mariadb.jdbc.export.MaxAllowedPacketException;
import org.mariadb.jdbc.export.Prepare;
import org.mariadb.jdbc.export.SslMode;
import org.mariadb.jdbc.message.ClientMessage;
import org.mariadb.jdbc.message.client.ClosePreparePacket;
import org.mariadb.jdbc.message.client.HandshakeResponse;
import org.mariadb.jdbc.message.client.QueryPacket;
import org.mariadb.jdbc.message.client.QuitPacket;
import org.mariadb.jdbc.message.client.SslRequestPacket;
import org.mariadb.jdbc.message.server.AuthSwitchPacket;
import org.mariadb.jdbc.message.server.ErrorPacket;
import org.mariadb.jdbc.message.server.InitialHandshakePacket;
import org.mariadb.jdbc.message.server.OkPacket;
import org.mariadb.jdbc.message.server.PrepareResultPacket;
import org.mariadb.jdbc.plugin.AuthenticationPlugin;
import org.mariadb.jdbc.plugin.Credential;
import org.mariadb.jdbc.plugin.CredentialPlugin;
import org.mariadb.jdbc.plugin.TlsSocketPlugin;
import org.mariadb.jdbc.plugin.authentication.AuthenticationPluginLoader;
import org.mariadb.jdbc.plugin.authentication.addon.ClearPasswordPlugin;
import org.mariadb.jdbc.plugin.authentication.standard.NativePasswordPlugin;
import org.mariadb.jdbc.plugin.tls.TlsSocketPluginLoader;
import org.mariadb.jdbc.util.Security;
import org.mariadb.jdbc.util.StringUtils;
import org.mariadb.jdbc.util.log.Logger;
import org.mariadb.jdbc.util.log.Loggers;

public class StandardClient
implements Client,
AutoCloseable {
    private static final Logger logger = Loggers.getLogger(StandardClient.class);
    protected final ExceptionFactory exceptionFactory;
    private static final Pattern REDIRECT_PATTERN = Pattern.compile("(mariadb|mysql):\\/\\/(([^/@:]+)?(:([^/]+))?@)?(([^/:]+)(:([0-9]+))?)(\\/([^?]+)(\\?(.*))?)?$", 34);
    private Socket socket;
    private final MutableByte sequence = new MutableByte();
    private final MutableByte compressionSequence = new MutableByte();
    private final ClosableLock lock;
    private Configuration conf;
    private AuthenticationPlugin authPlugin;
    private HostAddress hostAddress;
    private final boolean disablePipeline;
    protected Context context;
    protected Writer writer;
    private boolean closed = false;
    private Reader reader;
    private byte[] certFingerprint = null;
    private Statement streamStmt = null;
    private ClientMessage streamMsg = null;
    private int socketTimeout;
    private final Consumer<String> redirectConsumer = this::redirect;

    public StandardClient(Configuration conf, HostAddress hostAddress, ClosableLock lock, boolean skipPostCommands) throws SQLException {
        this.conf = conf;
        this.lock = lock;
        this.hostAddress = hostAddress;
        this.exceptionFactory = new ExceptionFactory(conf, hostAddress);
        this.disablePipeline = conf.disablePipeline();
        String host = hostAddress != null ? hostAddress.host : null;
        this.socketTimeout = conf.socketTimeout();
        this.socket = ConnectionHelper.connectSocket(conf, hostAddress);
        try {
            OutputStream out = this.socket.getOutputStream();
            FilterInputStream in = conf.useReadAheadInput() ? new ReadAheadBufferedStream(this.socket.getInputStream()) : new BufferedInputStream(this.socket.getInputStream(), 16384);
            this.assignStream(out, in, conf, null);
            if (conf.connectTimeout() > 0) {
                this.setSocketTimeout(conf.connectTimeout());
            } else if (conf.socketTimeout() > 0) {
                this.setSocketTimeout(conf.socketTimeout());
            }
            ReadableByteBuf buf = this.reader.readReusablePacket(logger.isTraceEnabled());
            if (buf.getByte() == -1) {
                ErrorPacket errorPacket = new ErrorPacket(buf, null);
                throw this.exceptionFactory.create(errorPacket.getMessage(), errorPacket.getSqlState(), errorPacket.getErrorCode());
            }
            InitialHandshakePacket handshake = InitialHandshakePacket.decode(buf);
            this.exceptionFactory.setThreadId(handshake.getThreadId());
            long clientCapabilities = ConnectionHelper.initializeClientCapabilities(conf, handshake.getCapabilities(), hostAddress);
            this.context = conf.transactionReplay() ? new RedoContext(hostAddress, handshake, clientCapabilities, conf, this.exceptionFactory, new PrepareCache(conf.prepStmtCacheSize(), this)) : new BaseContext(hostAddress, handshake, clientCapabilities, conf, this.exceptionFactory, conf.cachePrepStmts() ? new PrepareCache(conf.prepStmtCacheSize(), this) : null);
            this.reader.setServerThreadId(handshake.getThreadId(), hostAddress);
            this.writer.setServerThreadId(handshake.getThreadId(), hostAddress);
            SSLSocket sslSocket = this.sslWrapper(hostAddress, this.socket, clientCapabilities, (byte)handshake.getDefaultCollation(), this.context, this.writer);
            if (sslSocket != null) {
                out = new BufferedOutputStream(sslSocket.getOutputStream(), 16384);
                in = conf.useReadAheadInput() ? new ReadAheadBufferedStream(sslSocket.getInputStream()) : new BufferedInputStream(sslSocket.getInputStream(), 16384);
                this.assignStream(out, in, conf, handshake.getThreadId());
            }
            String authenticationPluginType = handshake.getAuthenticationPluginType();
            CredentialPlugin credentialPlugin = conf.credentialPlugin();
            if (credentialPlugin != null && credentialPlugin.defaultAuthenticationPluginType() != null) {
                authenticationPluginType = credentialPlugin.defaultAuthenticationPluginType();
            }
            Credential credential = ConnectionHelper.loadCredential(credentialPlugin, conf, hostAddress);
            new HandshakeResponse(credential, authenticationPluginType, this.context.getSeed(), conf, host, clientCapabilities, (byte)handshake.getDefaultCollation()).encode(this.writer, this.context);
            this.authPlugin = "mysql_clear_password".equals(authenticationPluginType) ? new ClearPasswordPlugin() : new NativePasswordPlugin();
            this.writer.flush();
            this.authenticationHandler(credential);
            if ((clientCapabilities & 0x20L) != 0L) {
                this.assignStream(new CompressOutputStream(out, this.compressionSequence), new CompressInputStream(in, this.compressionSequence), conf, handshake.getThreadId());
            }
            if (!skipPostCommands) {
                this.postConnectionQueries();
            }
            this.setSocketTimeout(conf.socketTimeout());
        }
        catch (IOException ioException) {
            this.destroySocket();
            String errorMsg = String.format("Could not connect to %s:%s : %s", host, this.socket.getPort(), ioException.getMessage());
            if (host == null) {
                errorMsg = String.format("Could not connect to socket : %s", ioException.getMessage());
            }
            throw this.exceptionFactory.create(errorMsg, "08000", ioException);
        }
        catch (SQLException sqlException) {
            this.destroySocket();
            throw sqlException;
        }
    }

    public void authenticationHandler(Credential credential) throws IOException, SQLException {
        this.writer.permitTrace(true);
        Configuration conf = this.context.getConf();
        ReadableByteBuf buf = this.reader.readReusablePacket();
        block5: while (true) {
            switch (buf.getByte() & 0xFF) {
                case 254: {
                    AuthSwitchPacket authSwitchPacket = AuthSwitchPacket.decode(buf);
                    this.authPlugin = AuthenticationPluginLoader.get(authSwitchPacket.getPlugin(), conf);
                    if (this.authPlugin.requireSsl() && !this.context.hasClientCapability(2048L)) {
                        throw this.context.getExceptionFactory().create("Cannot use authentication plugin " + this.authPlugin.type() + " if SSL is not enabled.", "08000");
                    }
                    this.authPlugin.initialize(credential.getPassword(), authSwitchPacket.getSeed(), conf);
                    buf = this.authPlugin.process(this.writer, this.reader, this.context);
                    continue block5;
                }
                case 255: {
                    ErrorPacket errorPacket = new ErrorPacket(buf, this.context);
                    throw this.context.getExceptionFactory().create(errorPacket.getMessage(), errorPacket.getSqlState(), errorPacket.getErrorCode());
                }
                case 0: {
                    OkPacket okPacket = new OkPacket(buf, this.context);
                    if (this.certFingerprint != null) {
                        if (this.socket instanceof UnixDomainSocket) break block5;
                        if (!this.authPlugin.isMitMProof() || credential.getPassword() == null || credential.getPassword().isEmpty() || !StandardClient.validateFingerPrint(this.authPlugin, okPacket.getInfo(), this.certFingerprint, credential, this.context.getSeed())) {
                            throw this.context.getExceptionFactory().create("Self signed certificates. Either set sslMode=trust, set a password or provide server certificate to client", "08000");
                        }
                    }
                    if (this.context.getRedirectUrl() == null || !conf.permitRedirect()) break block5;
                    this.redirect(this.context.getRedirectUrl());
                    break block5;
                }
                default: {
                    throw this.context.getExceptionFactory().create("unexpected data during authentication (header=" + buf.getUnsignedByte(), "08000");
                }
            }
            break;
        }
        this.writer.permitTrace(true);
    }

    private static boolean validateFingerPrint(AuthenticationPlugin authPlugin, byte[] validationHash, byte[] fingerPrint, Credential credential, byte[] seed) {
        if (validationHash.length == 0) {
            return false;
        }
        try {
            assert (validationHash[0] == 1);
            byte[] hash = authPlugin.hash(credential);
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(hash);
            messageDigest.update(seed);
            messageDigest.update(fingerPrint);
            byte[] digest = messageDigest.digest();
            String hashHex = StringUtils.byteArrayToHexString(digest);
            String serverValidationHex = new String(validationHash, 1, validationHash.length - 1, StandardCharsets.US_ASCII);
            return hashHex.equals(serverValidationHex);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-256 MessageDigest expected to be not available", e);
        }
    }

    public void redirect(String redirectUrl) {
        if (this.conf.permitRedirect() && redirectUrl != null) {
            if ((this.context.getServerStatus() & 1) == 0) {
                this.context.setRedirectUrl(null);
                Matcher matcher = REDIRECT_PATTERN.matcher(redirectUrl);
                if (!matcher.matches()) {
                    logger.error("error parsing redirection string '" + redirectUrl + "'. format must be 'mariadb/mysql://[<user>[:<password>]@]<host>[:<port>]/[<db>[?<opt1>=<value1>[&<opt2>=<value2>]]]'");
                    return;
                }
                try {
                    int redirectPort;
                    String redirectHost = matcher.group(7) != null ? URLDecoder.decode(matcher.group(7), "utf8") : matcher.group(6);
                    int n = redirectPort = matcher.group(9) != null ? Integer.parseInt(matcher.group(9)) : 3306;
                    if (this.getHostAddress() != null && redirectHost.equals(this.getHostAddress().host) && redirectPort == this.getHostAddress().port) {
                        return;
                    }
                    String redirectUser = matcher.group(3);
                    String redirectPwd = matcher.group(5);
                    Configuration.Builder redirectConfBuilder = this.context.getConf().toBuilder().addresses(HostAddress.from(redirectHost, redirectPort, true));
                    if (redirectUser != null) {
                        redirectConfBuilder.user(redirectUser);
                    }
                    if (redirectPwd != null) {
                        redirectConfBuilder.password(redirectPwd);
                    }
                    try {
                        Configuration redirectConf = redirectConfBuilder.build();
                        HostAddress redirectHostAddress = redirectConf.addresses().get(0);
                        StandardClient redirectClient = new StandardClient(redirectConf, redirectHostAddress, this.lock, false);
                        this.close();
                        logger.info("redirecting connection " + this.hostAddress + " to " + redirectUrl);
                        this.closed = false;
                        this.socket = redirectClient.socket;
                        this.conf = redirectConf;
                        this.hostAddress = redirectHostAddress;
                        this.context = redirectClient.context;
                        this.writer = redirectClient.writer;
                        this.reader = redirectClient.reader;
                    }
                    catch (SQLException e) {
                        logger.error("fail to redirect to '" + redirectUrl + "'");
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            } else {
                this.context.setRedirectUrl(redirectUrl);
            }
        } else {
            this.context.setRedirectUrl(null);
        }
    }

    public SSLSocket sslWrapper(HostAddress hostAddress, Socket socket, long clientCapabilities, byte exchangeCharset, Context context, Writer writer) throws IOException, SQLException {
        Configuration conf = context.getConf();
        if (conf.sslMode() != SslMode.DISABLE) {
            SSLSocketFactory sslSocketFactory;
            if (!context.hasServerCapability(2048L)) {
                throw context.getExceptionFactory().create("Trying to connect with ssl, but ssl not enabled in the server", "08000");
            }
            SslRequestPacket.create(clientCapabilities |= 0x800L, exchangeCharset).encode(writer, context);
            TlsSocketPlugin socketPlugin = TlsSocketPluginLoader.get(conf.tlsSocketType());
            TrustManager[] trustManagers = socketPlugin.getTrustManager(conf, context.getExceptionFactory());
            try {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(socketPlugin.getKeyManager(conf, context.getExceptionFactory()), trustManagers, null);
                sslSocketFactory = sslContext.getSocketFactory();
            }
            catch (KeyManagementException keyManagementEx) {
                throw context.getExceptionFactory().create("Could not initialize SSL context", "08000", keyManagementEx);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmEx) {
                throw context.getExceptionFactory().create("SSLContext TLS Algorithm not unknown", "08000", noSuchAlgorithmEx);
            }
            SSLSocket sslSocket = socketPlugin.createSocket(socket, sslSocketFactory);
            ConnectionHelper.enabledSslProtocolSuites(sslSocket, conf);
            ConnectionHelper.enabledSslCipherSuites(sslSocket, conf);
            sslSocket.setUseClientMode(true);
            sslSocket.startHandshake();
            if (trustManagers.length > 0 && trustManagers[0] instanceof MariaDbX509EphemeralTrustingManager) {
                this.certFingerprint = ((MariaDbX509EphemeralTrustingManager)trustManagers[0]).getFingerprint();
            }
            if (this.certFingerprint == null && conf.sslMode() == SslMode.VERIFY_FULL && hostAddress != null) {
                SSLSession session = sslSocket.getSession();
                try {
                    socketPlugin.verify(hostAddress.host, session, context.getThreadId());
                }
                catch (SSLException ex) {
                    throw context.getExceptionFactory().create("SSL hostname verification failed : " + ex.getMessage() + "\nThis verification can be disabled using the sslMode to VERIFY_CA but won't prevent man-in-the-middle attacks anymore", "08006");
                }
            }
            return sslSocket;
        }
        return null;
    }

    private void assignStream(OutputStream out, InputStream in, Configuration conf, Long threadId) {
        this.writer = new PacketWriter(out, conf.maxQuerySizeToLog(), conf.maxAllowedPacket(), this.sequence, this.compressionSequence);
        this.writer.setServerThreadId(threadId, this.hostAddress);
        this.reader = new PacketReader(in, conf, this.sequence);
        this.reader.setServerThreadId(threadId, this.hostAddress);
    }

    protected void destroySocket() {
        this.closed = true;
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void handleTimezone() throws SQLException {
        if (this.conf.connectionTimeZone() == null || "LOCAL".equalsIgnoreCase(this.conf.connectionTimeZone())) {
            this.context.setConnectionTimeZone(TimeZone.getDefault());
        } else {
            String zoneId;
            block12: {
                zoneId = this.conf.connectionTimeZone();
                if ("SERVER".equalsIgnoreCase(zoneId)) {
                    try {
                        Result res = (Result)this.execute(new QueryPacket("SELECT @@time_zone, @@system_time_zone"), true).get(0);
                        res.next();
                        zoneId = res.getString(1);
                        if ("SYSTEM".equals(zoneId)) {
                            zoneId = res.getString(2);
                        }
                    }
                    catch (SQLException sqle) {
                        Result res = (Result)this.execute(new QueryPacket("SHOW VARIABLES WHERE Variable_name in ('system_time_zone','time_zone')"), true).get(0);
                        String systemTimeZone = null;
                        while (res.next()) {
                            if ("system_time_zone".equals(res.getString(1))) {
                                systemTimeZone = res.getString(2);
                                continue;
                            }
                            zoneId = res.getString(2);
                        }
                        if (!"SYSTEM".equals(zoneId)) break block12;
                        zoneId = systemTimeZone;
                    }
                }
            }
            try {
                this.context.setConnectionTimeZone(TimeZone.getTimeZone(ZoneId.of(zoneId).normalized()));
            }
            catch (DateTimeException e) {
                try {
                    this.context.setConnectionTimeZone(TimeZone.getTimeZone(ZoneId.of(zoneId, ZoneId.SHORT_IDS).normalized()));
                }
                catch (DateTimeException e2) {
                    throw new SQLException(String.format("Unknown zoneId %s", zoneId), e);
                }
            }
        }
    }

    private void postConnectionQueries() throws SQLException {
        List galeraAllowedStates;
        ArrayList<String> commands = new ArrayList<String>();
        List<Object> list = galeraAllowedStates = this.conf.galeraAllowedState() == null ? Collections.emptyList() : Arrays.asList(this.conf.galeraAllowedState().split(","));
        if (this.hostAddress != null && Boolean.TRUE.equals(this.hostAddress.primary) && !galeraAllowedStates.isEmpty()) {
            commands.add("show status like 'wsrep_local_state'");
        }
        this.handleTimezone();
        String sessionVariableQuery = this.createSessionVariableQuery(this.context);
        if (sessionVariableQuery != null) {
            commands.add(sessionVariableQuery);
        }
        if (this.conf.database() != null && this.conf.createDatabaseIfNotExist() && (this.hostAddress == null || this.hostAddress.primary.booleanValue())) {
            String escapedDb = this.conf.database().replace("`", "``");
            commands.add(String.format("CREATE DATABASE IF NOT EXISTS `%s`", escapedDb));
            commands.add(String.format("USE `%s`", escapedDb));
        }
        if (this.conf.initSql() != null) {
            commands.add(this.conf.initSql());
        }
        if (this.conf.nonMappedOptions().containsKey("initSql")) {
            String[] initialCommands = this.conf.nonMappedOptions().get("initSql").toString().split(";");
            Collections.addAll(commands, initialCommands);
        }
        if (!commands.isEmpty()) {
            QueryPacket query;
            List<Completion> res;
            ResultSet rs;
            try {
                ClientMessage[] msgs = new ClientMessage[commands.size()];
                for (int i = 0; i < commands.size(); ++i) {
                    msgs[i] = new QueryPacket((String)commands.get(i));
                }
                List<Completion> res2 = this.executePipeline(msgs, null, 0, 0L, 1007, 1003, false, true);
                if (this.hostAddress != null && Boolean.TRUE.equals(this.hostAddress.primary) && !galeraAllowedStates.isEmpty()) {
                    ResultSet rs2 = (ResultSet)((Object)res2.get(0));
                    if (rs2.next()) {
                        if (!galeraAllowedStates.contains(rs2.getString(2))) {
                            throw this.exceptionFactory.create(String.format("fail to validate Galera state (State is %s)", rs2.getString(2)));
                        }
                    } else {
                        throw this.exceptionFactory.create("fail to validate Galera state (unknown 'wsrep_local_state' state)");
                    }
                    res2.remove(0);
                }
            }
            catch (SQLException sqlException) {
                if (this.conf.timezone() != null && !"disable".equalsIgnoreCase(this.conf.timezone())) {
                    throw this.exceptionFactory.create(String.format("Setting configured timezone '%s' fail on server.\nLook at https://mariadb.com/kb/en/mysql_tzinfo_to_sql/ to load tz data on server, or set timezone=disable to disable setting client timezone.", this.conf.timezone()), "HY000", sqlException);
                }
                throw this.exceptionFactory.create("Initialization command fail", "08000", sqlException);
            }
            if (this.conf.returnMultiValuesGeneratedIds() && (rs = (ResultSet)((Object)(res = this.execute(query = new QueryPacket("SELECT @@auto_increment_increment"), true)).get(0))).next()) {
                this.context.setAutoIncrement(rs.getLong(1));
            }
        }
    }

    public String createSessionVariableQuery(Context context) {
        TimeZone connectionTz;
        ZoneId connectionZoneId;
        boolean canRelyOnConnectionFlag;
        ArrayList<String> sessionCommands = new ArrayList<String>();
        boolean bl = canRelyOnConnectionFlag = context.getVersion().isMariaDBServer() && (context.getVersion().versionFixedMajorMinorGreaterOrEqual(10, 4, 33) || context.getVersion().versionFixedMajorMinorGreaterOrEqual(10, 5, 24) || context.getVersion().versionFixedMajorMinorGreaterOrEqual(10, 6, 17) || context.getVersion().versionFixedMajorMinorGreaterOrEqual(10, 11, 7) || context.getVersion().versionFixedMajorMinorGreaterOrEqual(11, 0, 5) || context.getVersion().versionFixedMajorMinorGreaterOrEqual(11, 1, 4) || context.getVersion().versionFixedMajorMinorGreaterOrEqual(11, 2, 3));
        if (this.conf.autocommit() == null && (context.getServerStatus() & 2) == 0 || this.conf.autocommit() != null && !canRelyOnConnectionFlag || this.conf.autocommit() != null && canRelyOnConnectionFlag && (context.getServerStatus() & 2) > 0 != this.conf.autocommit()) {
            sessionCommands.add("autocommit=" + (this.conf.autocommit() == null || this.conf.autocommit() != false ? "1" : "0"));
        }
        if (this.conf.jdbcCompliantTruncation()) {
            sessionCommands.add("sql_mode=CONCAT(@@sql_mode,',STRICT_TRANS_TABLES')");
        }
        if (context.hasClientCapability(0x800000L) && (context.getVersion().isMariaDBServer() && context.getVersion().versionGreaterOrEqual(10, 2, 2) || context.getVersion().versionGreaterOrEqual(5, 7, 0))) {
            String concatValues = "," + (context.canUseTransactionIsolation() ? "transaction_isolation" : "tx_isolation");
            if (this.conf.returnMultiValuesGeneratedIds()) {
                concatValues = concatValues + ",auto_increment_increment";
            }
            sessionCommands.add("session_track_system_variables = CONCAT(@@global.session_track_system_variables,'" + concatValues + "')");
        }
        if (this.conf.sessionVariables() != null) {
            sessionCommands.add(Security.parseSessionVariables(this.conf.sessionVariables()));
        }
        if ((this.conf.forceConnectionTimeZoneToSession() == null || this.conf.forceConnectionTimeZoneToSession().booleanValue()) && !(connectionZoneId = (connectionTz = context.getConnectionTimeZone()).toZoneId()).normalized().equals(TimeZone.getDefault().toZoneId())) {
            if (connectionZoneId.getRules().isFixedOffset()) {
                ZoneOffset zoneOffset = connectionZoneId.getRules().getOffset(Instant.now());
                if (zoneOffset.getTotalSeconds() == 0) {
                    sessionCommands.add("time_zone='+00:00'");
                } else {
                    sessionCommands.add("time_zone='" + zoneOffset.getId() + "'");
                }
            } else {
                sessionCommands.add("time_zone='" + connectionZoneId.normalized() + "'");
            }
        }
        if (this.conf.transactionIsolation() != null) {
            sessionCommands.add(String.format("@@session.%s='%s'", context.canUseTransactionIsolation() ? "transaction_isolation" : "tx_isolation", this.conf.transactionIsolation().getValue()));
        }
        if (this.hostAddress != null && !this.hostAddress.primary.booleanValue() && context.getVersion().versionGreaterOrEqual(5, 6, 5)) {
            sessionCommands.add(String.format("@@session.%s=1", context.canUseTransactionIsolation() ? "transaction_read_only" : "tx_read_only"));
        }
        if (context.getCharset() == null || !"utf8mb4".equals(context.getCharset())) {
            sessionCommands.add("NAMES utf8mb4");
        }
        if (!sessionCommands.isEmpty()) {
            return "set " + sessionCommands.stream().collect(Collectors.joining(","));
        }
        return null;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.closed) {
            throw new SQLNonTransientConnectionException("Connection is closed", "08000", 1220);
        }
    }

    public int sendQuery(ClientMessage message) throws SQLException {
        this.checkNotClosed();
        try {
            if (logger.isDebugEnabled() && message.description() != null) {
                logger.debug("execute query: {}", message.description());
            }
            return message.encode(this.writer, this.context);
        }
        catch (IOException ioException) {
            if (ioException instanceof MaxAllowedPacketException) {
                if (((MaxAllowedPacketException)ioException).isMustReconnect()) {
                    this.destroySocket();
                    throw this.exceptionFactory.withSql(message.description()).create("Packet too big for current server max_allowed_packet value", "08000", ioException);
                }
                throw this.exceptionFactory.withSql(message.description()).create("Packet too big for current server max_allowed_packet value", "HZ000", ioException);
            }
            this.destroySocket();
            throw this.exceptionFactory.withSql(message.description()).create("Socket error", "08000", ioException);
        }
    }

    @Override
    public List<Completion> execute(ClientMessage message, boolean canRedo) throws SQLException {
        return this.execute(message, null, 0, 0L, 1007, 1003, false, canRedo);
    }

    @Override
    public List<Completion> execute(ClientMessage message, Statement stmt, boolean canRedo) throws SQLException {
        return this.execute(message, stmt, 0, 0L, 1007, 1003, false, canRedo);
    }

    @Override
    public List<Completion> executePipeline(ClientMessage[] messages, Statement stmt, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion, boolean canRedo) throws SQLException {
        ArrayList<Completion> results = new ArrayList<Completion>();
        int perMsgCounter = 0;
        int readCounter = 0;
        int[] responseMsg = new int[messages.length];
        try {
            if (this.disablePipeline) {
                for (readCounter = 0; readCounter < messages.length; ++readCounter) {
                    results.addAll(this.execute(messages[readCounter], stmt, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion, canRedo));
                }
            } else {
                for (int i = 0; i < messages.length; ++i) {
                    responseMsg[i] = this.sendQuery(messages[i]);
                }
                while (readCounter < messages.length) {
                    ++readCounter;
                    for (perMsgCounter = 0; perMsgCounter < responseMsg[readCounter - 1]; ++perMsgCounter) {
                        results.addAll(this.readResponse(stmt, messages[readCounter - 1], fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion));
                    }
                }
            }
            return results;
        }
        catch (SQLException sqlException) {
            if (!this.closed) {
                results.add(null);
                ++perMsgCounter;
                while (perMsgCounter < responseMsg[readCounter - 1]) {
                    try {
                        results.addAll(this.readResponse(stmt, messages[readCounter - 1], fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion));
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    ++perMsgCounter;
                }
                for (int i = readCounter; i < messages.length; ++i) {
                    for (int j = 0; j < responseMsg[i]; ++j) {
                        try {
                            results.addAll(this.readResponse(stmt, messages[i], fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion));
                            continue;
                        }
                        catch (SQLException e) {
                            results.add(null);
                        }
                    }
                }
                for (Completion result : results) {
                    if (!(result instanceof PrepareResultPacket) || !(stmt instanceof ServerPreparedStatement)) continue;
                    try {
                        ((PrepareResultPacket)result).decrementUse(this, (ServerPreparedStatement)stmt);
                    }
                    catch (SQLException sQLException) {}
                }
            }
            int batchUpdateLength = 0;
            for (ClientMessage message : messages) {
                batchUpdateLength += message.batchUpdateLength();
            }
            throw this.exceptionFactory.createBatchUpdate(results, batchUpdateLength, responseMsg, sqlException);
        }
    }

    @Override
    public List<Completion> execute(ClientMessage message, Statement stmt, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion, boolean canRedo) throws SQLException {
        int nbResp = this.sendQuery(message);
        if (nbResp == 1) {
            return this.readResponse(stmt, message, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion);
        }
        if (this.streamStmt != null) {
            this.streamStmt.fetchRemaining();
            this.streamStmt = null;
        }
        ArrayList<Completion> completions = new ArrayList<Completion>();
        try {
            while (nbResp-- > 0) {
                this.readResults(stmt, message, completions, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion);
            }
            return completions;
        }
        catch (SQLException e) {
            while (nbResp-- > 0) {
                try {
                    this.readResults(stmt, message, completions, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion);
                }
                catch (SQLException sQLException) {}
            }
            throw e;
        }
    }

    public List<Completion> readResponse(Statement stmt, ClientMessage message, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion) throws SQLException {
        this.checkNotClosed();
        if (this.streamStmt != null) {
            this.streamStmt.fetchRemaining();
            this.streamStmt = null;
        }
        ArrayList<Completion> completions = new ArrayList<Completion>();
        this.readResults(stmt, message, completions, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion);
        return completions;
    }

    public void readResponse(ClientMessage message) throws SQLException {
        this.checkNotClosed();
        if (this.streamStmt != null) {
            this.streamStmt.fetchRemaining();
            this.streamStmt = null;
        }
        ArrayList<Completion> completions = new ArrayList<Completion>();
        this.readResults(null, message, completions, 0, 0L, 1007, 1003, false);
    }

    @Override
    public void closePrepare(Prepare prepare) throws SQLException {
        this.checkNotClosed();
        try {
            new ClosePreparePacket(prepare.getStatementId()).encode(this.writer, this.context);
        }
        catch (IOException ioException) {
            this.destroySocket();
            throw this.exceptionFactory.create("Socket error during post connection queries: " + ioException.getMessage(), "08000", ioException);
        }
    }

    @Override
    public void readStreamingResults(List<Completion> completions, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion) throws SQLException {
        if (this.streamStmt != null) {
            this.readResults(this.streamStmt, this.streamMsg, completions, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion);
        }
    }

    private void readResults(Statement stmt, ClientMessage message, List<Completion> completions, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion) throws SQLException {
        completions.add(this.readPacket(stmt, message, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion));
        while ((this.context.getServerStatus() & 8) > 0) {
            completions.add(this.readPacket(stmt, message, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion));
        }
    }

    public Completion readPacket(ClientMessage message) throws SQLException {
        return this.readPacket(null, message, 0, 0L, 1007, 1003, false);
    }

    public Completion readPacket(Statement stmt, ClientMessage message, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion) throws SQLException {
        try {
            boolean traceEnable = logger.isTraceEnabled();
            Completion completion = message.readPacket(stmt, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion, this.reader, this.writer, this.context, this.exceptionFactory, this.lock, traceEnable, message, this.redirectConsumer);
            if (completion instanceof StreamingResult && !((StreamingResult)completion).loaded()) {
                this.streamStmt = stmt;
                this.streamMsg = message;
            }
            return completion;
        }
        catch (IOException ioException) {
            this.destroySocket();
            throw this.exceptionFactory.withSql(message.description()).create(ioException instanceof SocketTimeoutException ? "Socket timout error" : "Socket error", "08000", ioException);
        }
    }

    protected void checkNotClosed() throws SQLException {
        if (this.closed) {
            throw this.exceptionFactory.create("Connection is closed", "08000", 1220);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSocket() {
        try {
            try {
                long maxCurrentMillis = System.currentTimeMillis() + 10L;
                this.socket.shutdownOutput();
                this.socket.setSoTimeout(3);
                InputStream is = this.socket.getInputStream();
                while (is.read() != -1 && System.currentTimeMillis() < maxCurrentMillis) {
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.writer.close();
            this.reader.close();
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (executor == null) {
            throw this.exceptionFactory.create("Cannot abort the connection: null executor passed");
        }
        boolean lockStatus = this.lock.tryLock();
        if (!this.closed) {
            this.closed = true;
            logger.debug("aborting connection {}", this.context.getThreadId());
            if (!lockStatus) {
                try (StandardClient cli = new StandardClient(this.conf, this.hostAddress, new ClosableLock(), true);){
                    cli.execute(new QueryPacket("KILL " + this.context.getThreadId()), false);
                }
                catch (SQLException sQLException) {}
            } else {
                try {
                    QuitPacket.INSTANCE.encode(this.writer, this.context);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.streamStmt != null) {
                this.streamStmt.abort();
            }
            this.closeSocket();
        }
        if (lockStatus) {
            this.lock.unlock();
        }
    }

    @Override
    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    @Override
    public void setSocketTimeout(int milliseconds) throws SQLException {
        try {
            this.socketTimeout = milliseconds;
            this.socket.setSoTimeout(milliseconds);
        }
        catch (SocketException se) {
            throw this.exceptionFactory.create("Cannot set the network timeout", "42000", se);
        }
    }

    @Override
    public void close() {
        boolean locked = this.lock.tryLock();
        if (!this.closed) {
            this.closed = true;
            try {
                QuitPacket.INSTANCE.encode(this.writer, this.context);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.closeSocket();
        }
        if (locked) {
            this.lock.unlock();
        }
    }

    @Override
    public String getSocketIp() {
        return this.socket.getInetAddress() == null ? null : this.socket.getInetAddress().getHostAddress();
    }

    @Override
    public boolean isPrimary() {
        return this.hostAddress.primary;
    }

    @Override
    public ExceptionFactory getExceptionFactory() {
        return this.exceptionFactory;
    }

    @Override
    public HostAddress getHostAddress() {
        return this.hostAddress;
    }

    @Override
    public void reset() {
        this.context.resetStateFlag();
        this.context.resetPrepareCache();
    }
}

