/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.ConnectionEvent;
import org.mariadb.jdbc.ClientPreparedStatement;
import org.mariadb.jdbc.Configuration;
import org.mariadb.jdbc.DatabaseMetaData;
import org.mariadb.jdbc.FunctionStatement;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.MariaDbBlob;
import org.mariadb.jdbc.MariaDbClob;
import org.mariadb.jdbc.MariaDbPoolConnection;
import org.mariadb.jdbc.ProcedureStatement;
import org.mariadb.jdbc.ServerPreparedStatement;
import org.mariadb.jdbc.Statement;
import org.mariadb.jdbc.client.Client;
import org.mariadb.jdbc.client.Context;
import org.mariadb.jdbc.client.impl.StandardClient;
import org.mariadb.jdbc.client.util.ClosableLock;
import org.mariadb.jdbc.export.ExceptionFactory;
import org.mariadb.jdbc.message.client.ChangeDbPacket;
import org.mariadb.jdbc.message.client.PingPacket;
import org.mariadb.jdbc.message.client.QueryPacket;
import org.mariadb.jdbc.message.client.ResetPacket;
import org.mariadb.jdbc.util.NativeSql;
import org.mariadb.jdbc.util.constants.CatalogTerm;
import org.mariadb.jdbc.util.timeout.NoOpQueryTimeoutHandler;
import org.mariadb.jdbc.util.timeout.QueryTimeoutHandler;
import org.mariadb.jdbc.util.timeout.QueryTimeoutHandlerImpl;

public class Connection
implements java.sql.Connection {
    private static final Pattern CALLABLE_STATEMENT_PATTERN = Pattern.compile("^(\\s*\\{)?\\s*((\\?\\s*=)?(\\s*/\\*([^*]|\\*[^/])*\\*/)*\\s*call(\\s*/\\*([^*]|\\*[^/])*\\*/)*\\s*((((`[^`]+`)|([^`\\}]+))\\.)?((`[^`]+`)|([^`\\}(]+)))\\s*(\\(.*\\))?(\\s*/\\*([^*]|\\*[^/])*\\*/)*\\s*(#.*)?)\\s*(\\}\\s*)?$", 34);
    private final ClosableLock lock;
    private final Configuration conf;
    private final Client client;
    private final Properties clientInfo = new Properties();
    private final AtomicInteger savepointId = new AtomicInteger();
    private final boolean canUseServerTimeout;
    private final boolean canCachePrepStmts;
    private final boolean canUseServerMaxRows;
    private final int defaultFetchSize;
    private final boolean forceTransactionEnd;
    private ExceptionFactory exceptionFactory;
    private int lowercaseTableNames = -1;
    private boolean readOnly;
    private MariaDbPoolConnection poolConnection;
    private QueryTimeoutHandler queryTimeoutHandler;

    public Connection(Configuration conf, ClosableLock lock, Client client) {
        this.conf = conf;
        this.forceTransactionEnd = Boolean.parseBoolean(conf.nonMappedOptions().getProperty("forceTransactionEnd", "false"));
        this.lock = lock;
        this.exceptionFactory = client.getExceptionFactory().setConnection(this);
        this.client = client;
        Context context = this.client.getContext();
        this.canUseServerTimeout = context.getVersion().isMariaDBServer() && context.getVersion().versionGreaterOrEqual(10, 1, 2);
        this.queryTimeoutHandler = this.canUseServerTimeout ? NoOpQueryTimeoutHandler.INSTANCE : new QueryTimeoutHandlerImpl(this, lock);
        this.canUseServerMaxRows = context.getVersion().isMariaDBServer() && context.getVersion().versionGreaterOrEqual(10, 3, 0);
        this.canCachePrepStmts = context.getConf().cachePrepStmts();
        this.defaultFetchSize = context.getConf().defaultFetchSize();
    }

    public void setPoolConnection(MariaDbPoolConnection poolConnection) {
        this.poolConnection = poolConnection;
        this.exceptionFactory = this.exceptionFactory.setPoolConnection(poolConnection);
    }

    public void cancelCurrentQuery() throws SQLException {
        String currentIp = this.client.getSocketIp();
        HostAddress hostAddress = currentIp == null ? this.client.getHostAddress() : HostAddress.from(currentIp, this.client.getHostAddress().port, this.client.getHostAddress().primary);
        try (StandardClient cli = new StandardClient(this.conf, hostAddress, new ClosableLock(), true);){
            cli.execute(new QueryPacket("KILL QUERY " + this.client.getContext().getThreadId()), false);
        }
    }

    @Override
    public Statement createStatement() {
        return new Statement(this, this.lock, this.canUseServerTimeout, this.canUseServerMaxRows, 1, 1003, 1007, this.defaultFetchSize);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareInternal(sql, 2, 1003, 1007, this.conf.useServerPrepStmts());
    }

    public PreparedStatement prepareInternal(String sql, int autoGeneratedKeys, int resultSetType, int resultSetConcurrency, boolean useBinary) throws SQLException {
        this.checkNotClosed();
        if (useBinary && !sql.startsWith("/*client prepare*/")) {
            try {
                return new ServerPreparedStatement(NativeSql.parse(sql, this.client.getContext()), this, this.lock, this.canUseServerTimeout, this.canUseServerMaxRows, this.canCachePrepStmts, autoGeneratedKeys, resultSetType, resultSetConcurrency, this.defaultFetchSize);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return new ClientPreparedStatement(NativeSql.parse(sql, this.client.getContext()), this, this.lock, this.canUseServerTimeout, this.canUseServerMaxRows, autoGeneratedKeys, resultSetType, resultSetConcurrency, this.defaultFetchSize);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1003, 1007);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return NativeSql.parse(sql, this.client.getContext());
    }

    @Override
    public boolean getAutoCommit() {
        return (this.client.getContext().getServerStatus() & 2) > 0;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (autoCommit == this.getAutoCommit()) {
            return;
        }
        try (ClosableLock ignore = this.lock.closeableLock();){
            this.getContext().addStateFlag(8);
            this.client.execute(new QueryPacket(autoCommit ? "set autocommit=1" : "set autocommit=0"), true);
        }
    }

    @Override
    public void commit() throws SQLException {
        try (ClosableLock ignore = this.lock.closeableLock();){
            if (this.forceTransactionEnd || (this.client.getContext().getServerStatus() & 1) > 0) {
                this.client.execute(new QueryPacket("COMMIT"), false);
            }
        }
    }

    @Override
    public void rollback() throws SQLException {
        try (ClosableLock ignore = this.lock.closeableLock();){
            if (this.forceTransactionEnd || (this.client.getContext().getServerStatus() & 1) > 0) {
                this.client.execute(new QueryPacket("ROLLBACK"), true);
            }
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.poolConnection != null) {
            this.poolConnection.fireConnectionClosed(new ConnectionEvent(this.poolConnection));
            return;
        }
        this.client.close();
    }

    @Override
    public boolean isClosed() {
        return this.client.isClosed();
    }

    public Context getContext() {
        return this.client.getContext();
    }

    public int getLowercaseTableNames() throws SQLException {
        if (this.lowercaseTableNames == -1) {
            try (Statement st = this.createStatement();
                 ResultSet rs = st.executeQuery("select @@lower_case_table_names");){
                rs.next();
                this.lowercaseTableNames = rs.getInt(1);
            }
        }
        return this.lowercaseTableNames;
    }

    @Override
    public DatabaseMetaData getMetaData() {
        return new DatabaseMetaData(this, this.conf);
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        try (ClosableLock ignore = this.lock.closeableLock();){
            if (this.readOnly != readOnly) {
                this.client.setReadOnly(readOnly);
            }
            this.readOnly = readOnly;
            this.getContext().addStateFlag(4);
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        if (this.conf.useCatalogTerm() == CatalogTerm.UseCatalog) {
            return this.getDatabase();
        }
        return "def";
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        if (this.conf.useCatalogTerm() == CatalogTerm.UseCatalog) {
            this.setDatabase(catalog);
        }
    }

    @Override
    public String getSchema() throws SQLException {
        if (this.conf.useCatalogTerm() == CatalogTerm.UseSchema) {
            return this.getDatabase();
        }
        return null;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        if (this.conf.useCatalogTerm() == CatalogTerm.UseSchema) {
            this.setDatabase(schema);
        }
    }

    private String getDatabase() throws SQLException {
        if (this.client.getContext().hasClientCapability(0x800000L)) {
            return this.client.getContext().getDatabase();
        }
        try (Statement stmt = this.createStatement();){
            ResultSet rs = stmt.executeQuery("select database()");
            rs.next();
            this.client.getContext().setDatabase(rs.getString(1));
            String string = this.client.getContext().getDatabase();
            return string;
        }
    }

    private void setDatabase(String database) throws SQLException {
        if (database == null || this.client.getContext().hasClientCapability(0x800000L) && database.equals(this.client.getContext().getDatabase())) {
            return;
        }
        try (ClosableLock ignore = this.lock.closeableLock();){
            this.getContext().addStateFlag(2);
            this.client.execute(new ChangeDbPacket(database), true);
            this.client.getContext().setDatabase(database);
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        boolean useContextState;
        boolean bl = useContextState = this.conf.useLocalSessionState() || this.client.getContext().hasClientCapability(0x800000L) && (this.client.getContext().getVersion().isMariaDBServer() && this.client.getContext().getVersion().versionGreaterOrEqual(10, 2, 2) || this.client.getContext().getVersion().versionGreaterOrEqual(5, 7, 0));
        if (useContextState && this.client.getContext().getTransactionIsolationLevel() != null) {
            return this.client.getContext().getTransactionIsolationLevel();
        }
        String sql = this.client.getContext().canUseTransactionIsolation() ? "SELECT @@session.transaction_isolation" : "SELECT @@session.tx_isolation";
        try (Statement stmt = this.createStatement();){
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                String response;
                switch (response = rs.getString(1)) {
                    case "REPEATABLE-READ": {
                        int n = 4;
                        return n;
                    }
                    case "READ-UNCOMMITTED": {
                        int n = 1;
                        return n;
                    }
                    case "READ-COMMITTED": {
                        int n = 2;
                        return n;
                    }
                    case "SERIALIZABLE": {
                        int n = 8;
                        return n;
                    }
                }
                throw this.exceptionFactory.create(String.format("Could not get transaction isolation level: Invalid value \"%s\"", response));
            }
            throw this.exceptionFactory.create("Failed to retrieve transaction isolation");
        }
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        boolean useContextState;
        boolean bl = useContextState = this.conf.useLocalSessionState() || this.client.getContext().hasClientCapability(0x800000L) && (this.client.getContext().getVersion().isMariaDBServer() && this.client.getContext().getVersion().versionGreaterOrEqual(10, 2, 2) || this.client.getContext().getVersion().versionGreaterOrEqual(5, 7, 0));
        if (useContextState && this.client.getContext().getTransactionIsolationLevel() != null && level == this.client.getContext().getTransactionIsolationLevel()) {
            return;
        }
        String query = "SET SESSION TRANSACTION ISOLATION LEVEL";
        switch (level) {
            case 1: {
                query = query + " READ UNCOMMITTED";
                break;
            }
            case 2: {
                query = query + " READ COMMITTED";
                break;
            }
            case 4: {
                query = query + " REPEATABLE READ";
                break;
            }
            case 8: {
                query = query + " SERIALIZABLE";
                break;
            }
            default: {
                throw new SQLException("Unsupported transaction isolation level");
            }
        }
        try (ClosableLock ignore = this.lock.closeableLock();){
            this.checkNotClosed();
            this.getContext().addStateFlag(16);
            if (this.conf.useLocalSessionState()) {
                this.client.getContext().setTransactionIsolationLevel(level);
            }
            this.client.execute(new QueryPacket(query), true);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkNotClosed();
        if (this.client.getContext().getWarning() == 0) {
            return null;
        }
        SQLWarning last = null;
        SQLWarning first = null;
        try (Statement st = this.createStatement();
             ResultSet rs = st.executeQuery("show warnings");){
            while (rs.next()) {
                int code = rs.getInt(2);
                String message = rs.getString(3);
                SQLWarning warning = new SQLWarning(message, null, code);
                if (first == null) {
                    first = warning;
                } else {
                    last.setNextWarning(warning);
                }
                last = warning;
            }
        }
        return first;
    }

    @Override
    public void clearWarnings() {
        this.client.getContext().setWarning(0);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkNotClosed();
        return new Statement(this, this.lock, this.canUseServerTimeout, this.canUseServerMaxRows, 1, resultSetType, resultSetConcurrency, this.defaultFetchSize);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareInternal(sql, 1, resultSetType, resultSetConcurrency, this.conf.useServerPrepStmts());
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkNotClosed();
        Matcher matcher = CALLABLE_STATEMENT_PATTERN.matcher(sql);
        if (!matcher.matches()) {
            throw new SQLSyntaxErrorException("invalid callable syntax. must be like {[?=]call <procedure/function name>[(?,?, ...)]}\n but was : " + sql);
        }
        String query = NativeSql.parse(matcher.group(2), this.client.getContext());
        boolean isFunction = matcher.group(3) != null;
        String databaseAndProcedure = matcher.group(8);
        String database = matcher.group(10);
        String procedureName = matcher.group(13);
        String arguments = matcher.group(16);
        if (database == null) {
            database = this.getCatalog();
        }
        if (isFunction) {
            return new FunctionStatement(this, database, databaseAndProcedure, arguments == null ? "()" : arguments, this.lock, this.canUseServerTimeout, this.canUseServerMaxRows, this.canCachePrepStmts, resultSetType, resultSetConcurrency);
        }
        return new ProcedureStatement(this, query, database, procedureName, this.lock, this.canUseServerTimeout, this.canUseServerMaxRows, this.canCachePrepStmts, resultSetType, resultSetConcurrency);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() {
        return new HashMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw this.exceptionFactory.notSupported("TypeMap are not supported");
    }

    @Override
    public int getHoldability() {
        return 1;
    }

    @Override
    public void setHoldability(int holdability) {
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        MariaDbSavepoint savepoint = new MariaDbSavepoint(this.savepointId.incrementAndGet());
        this.client.execute(new QueryPacket("SAVEPOINT `" + savepoint.rawValue() + "`"), true);
        return savepoint;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        MariaDbSavepoint savepoint = new MariaDbSavepoint(name.replace("`", "``"));
        this.client.execute(new QueryPacket("SAVEPOINT `" + savepoint.rawValue() + "`"), true);
        return savepoint;
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        block7: {
            this.checkNotClosed();
            try (ClosableLock ignore = this.lock.closeableLock();){
                if ((this.client.getContext().getServerStatus() & 1) <= 0) break block7;
                if (savepoint instanceof MariaDbSavepoint) {
                    this.client.execute(new QueryPacket("ROLLBACK TO SAVEPOINT `" + ((MariaDbSavepoint)savepoint).rawValue() + "`"), true);
                    break block7;
                }
                throw this.exceptionFactory.create("Unknown savepoint type");
            }
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        block7: {
            this.checkNotClosed();
            try (ClosableLock ignore = this.lock.closeableLock();){
                if ((this.client.getContext().getServerStatus() & 1) <= 0) break block7;
                if (savepoint instanceof MariaDbSavepoint) {
                    this.client.execute(new QueryPacket("RELEASE SAVEPOINT `" + ((MariaDbSavepoint)savepoint).rawValue() + "`"), true);
                    break block7;
                }
                throw this.exceptionFactory.create("Unknown savepoint type");
            }
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkNotClosed();
        return new Statement(this, this.lock, this.canUseServerTimeout, this.canUseServerMaxRows, 2, resultSetType, resultSetConcurrency, this.defaultFetchSize);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.prepareInternal(sql, autoGeneratedKeys, 1003, 1007, this.conf.useServerPrepStmts());
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.prepareStatement(sql, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.prepareStatement(sql, 1);
    }

    @Override
    public Clob createClob() {
        return new MariaDbClob();
    }

    @Override
    public Blob createBlob() {
        return new MariaDbBlob();
    }

    @Override
    public NClob createNClob() {
        return new MariaDbClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw this.exceptionFactory.notSupported("SQLXML type is not supported");
    }

    private void checkNotClosed() throws SQLException {
        if (this.client.isClosed()) {
            throw this.exceptionFactory.create("Connection is closed", "08000", 1220);
        }
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw this.exceptionFactory.create("the value supplied for timeout is negative");
        }
        ClosableLock ignore = this.lock.closeableLock();
        try {
            this.client.execute(PingPacket.INSTANCE, true);
            boolean bl = true;
            if (ignore != null) {
                ignore.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (ignore != null) {
                    try {
                        ignore.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException sqle) {
                if (this.poolConnection != null) {
                    MariaDbPoolConnection poolConnection = this.poolConnection;
                    poolConnection.fireConnectionErrorOccurred(sqle);
                    poolConnection.close();
                }
                return false;
            }
        }
    }

    @Override
    public void setClientInfo(String name, String value) {
        this.clientInfo.put(name, value);
    }

    @Override
    public String getClientInfo(String name) {
        return (String)this.clientInfo.get(name);
    }

    @Override
    public Properties getClientInfo() {
        return this.clientInfo;
    }

    @Override
    public void setClientInfo(Properties properties) {
        this.clientInfo.putAll((Map<?, ?>)properties);
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw this.exceptionFactory.notSupported("Array type is not supported");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw this.exceptionFactory.notSupported("Struct type is not supported");
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (this.poolConnection != null) {
            MariaDbPoolConnection poolConnection = this.poolConnection;
            poolConnection.close();
            return;
        }
        this.client.abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        if (this.isClosed()) {
            throw this.exceptionFactory.create("Connection.setNetworkTimeout cannot be called on a closed connection");
        }
        if (milliseconds < 0) {
            throw this.exceptionFactory.create("Connection.setNetworkTimeout cannot be called with a negative timeout");
        }
        this.getContext().addStateFlag(1);
        try (ClosableLock ignore = this.lock.closeableLock();){
            this.client.setSocketTimeout(milliseconds);
        }
    }

    @Override
    public int getNetworkTimeout() {
        return this.client.getSocketTimeout();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return iface.cast(this);
        }
        throw new SQLException("The receiver is not a wrapper for " + iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isInstance(this);
    }

    public Client getClient() {
        return this.client;
    }

    public void reset() throws SQLException {
        int stateFlag;
        boolean useComReset;
        boolean bl = useComReset = this.conf.useResetConnection() && this.getContext().getVersion().isMariaDBServer() && (this.getContext().getVersion().versionGreaterOrEqual(10, 3, 13) || this.getContext().getVersion().getMajorVersion() == 10 && this.getContext().getVersion().getMinorVersion() == 2 && this.getContext().getVersion().versionGreaterOrEqual(10, 2, 22));
        if (useComReset) {
            this.client.execute(ResetPacket.INSTANCE, true);
        }
        if (this.forceTransactionEnd || (this.client.getContext().getServerStatus() & 1) > 0) {
            this.client.execute(new QueryPacket("ROLLBACK"), true);
        }
        if ((stateFlag = this.getContext().getStateFlag()) != 0) {
            try {
                if ((stateFlag & 1) != 0) {
                    this.setNetworkTimeout(null, this.conf.socketTimeout());
                }
                if ((stateFlag & 8) != 0) {
                    this.setAutoCommit(this.conf.autocommit() == null || this.conf.autocommit() != false);
                }
                if ((stateFlag & 2) != 0) {
                    this.setCatalog(this.conf.database());
                }
                if ((stateFlag & 4) != 0) {
                    this.setReadOnly(false);
                }
                if (!useComReset && (stateFlag & 0x10) != 0) {
                    this.setTransactionIsolation(this.conf.transactionIsolation() == null ? 4 : this.conf.transactionIsolation().getLevel());
                }
            }
            catch (SQLException sqle) {
                throw this.exceptionFactory.create("error resetting connection");
            }
        }
        this.client.reset();
        this.clearWarnings();
    }

    public long getThreadId() {
        return this.client.getContext().getThreadId();
    }

    public void fireStatementClosed(PreparedStatement prep) {
        if (this.poolConnection != null) {
            this.poolConnection.fireStatementClosed(prep);
        }
    }

    protected ExceptionFactory getExceptionFactory() {
        return this.exceptionFactory;
    }

    public QueryTimeoutHandler handleTimeout(int queryTimeout) {
        return this.queryTimeoutHandler.create(queryTimeout);
    }

    public String __test_host() {
        return this.client.getHostAddress().toString();
    }

    class MariaDbSavepoint
    implements Savepoint {
        private final String name;
        private final Integer id;

        public MariaDbSavepoint(String name) {
            this.name = name;
            this.id = null;
        }

        public MariaDbSavepoint(int savepointId) {
            this.id = savepointId;
            this.name = null;
        }

        @Override
        public int getSavepointId() throws SQLException {
            if (this.id == null) {
                throw Connection.this.exceptionFactory.create("Cannot retrieve savepoint id of a named savepoint");
            }
            return this.id;
        }

        @Override
        public String getSavepointName() throws SQLException {
            if (this.id != null) {
                throw Connection.this.exceptionFactory.create("Cannot retrieve savepoint name of an unnamed savepoint");
            }
            return this.name;
        }

        public String rawValue() {
            if (this.id != null) {
                return "_jid_" + this.id;
            }
            return this.name;
        }
    }
}

