/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.message.client;

import java.io.IOException;
import java.sql.SQLException;
import org.mariadb.jdbc.client.context.Context;
import org.mariadb.jdbc.client.socket.PacketWriter;
import org.mariadb.jdbc.codec.Parameter;
import org.mariadb.jdbc.codec.list.ByteArrayCodec;
import org.mariadb.jdbc.message.client.RedoableClientMessage;
import org.mariadb.jdbc.util.ClientParser;
import org.mariadb.jdbc.util.ParameterList;

public final class QueryWithParametersPacket
implements RedoableClientMessage {
    private final String preSqlCmd;
    private final ClientParser parser;
    private ParameterList parameters;

    public QueryWithParametersPacket(String preSqlCmd, ClientParser parser, ParameterList parameters) {
        this.preSqlCmd = preSqlCmd;
        this.parser = parser;
        this.parameters = parameters;
    }

    @Override
    public void ensureReplayable(Context context) throws IOException, SQLException {
        int parameterCount = this.parameters.size();
        for (int i = 0; i < parameterCount; ++i) {
            Parameter<?> p = this.parameters.get(i);
            if (p.isNull() || !p.canEncodeLongData()) continue;
            this.parameters.set(i, new Parameter<byte[]>(ByteArrayCodec.INSTANCE, p.encodeData()));
        }
    }

    @Override
    public void saveParameters() {
        this.parameters = this.parameters.clone();
    }

    @Override
    public int encode(PacketWriter encoder, Context context) throws IOException, SQLException {
        encoder.initPacket();
        encoder.writeByte(3);
        if (!this.preSqlCmd.isEmpty()) {
            encoder.writeAscii(this.preSqlCmd);
        }
        if (this.parser.getParamCount() == 0) {
            encoder.writeBytes(this.parser.getQueryParts().get(0));
        } else {
            encoder.writeBytes(this.parser.getQueryParts().get(0));
            for (int i = 0; i < this.parser.getParamCount(); ++i) {
                if (this.parameters.get(i).isNull()) {
                    encoder.writeAscii("null");
                } else {
                    this.parameters.get(i).encodeText(encoder, context);
                }
                encoder.writeBytes(this.parser.getQueryParts().get(i + 1));
            }
        }
        encoder.flush();
        return 1;
    }

    @Override
    public int batchUpdateLength() {
        return 1;
    }

    @Override
    public String description() {
        return this.parser.getSql();
    }
}

