/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.codec.list;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.sql.SQLDataException;
import java.util.Calendar;
import java.util.EnumSet;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.client.context.Context;
import org.mariadb.jdbc.client.socket.PacketWriter;
import org.mariadb.jdbc.codec.DataType;
import org.mariadb.jdbc.message.server.ColumnDefinitionPacket;
import org.mariadb.jdbc.plugin.Codec;

public class ReaderCodec
implements Codec<Reader> {
    public static final ReaderCodec INSTANCE = new ReaderCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.STRING, new DataType[]{DataType.VARCHAR, DataType.VARSTRING, DataType.BLOB, DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB});

    @Override
    public boolean canDecode(ColumnDefinitionPacket column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && type.isAssignableFrom(Reader.class);
    }

    @Override
    public String className() {
        return Reader.class.getName();
    }

    @Override
    public Reader decodeText(ReadableByteBuf buf, int length, ColumnDefinitionPacket column, Calendar cal) throws SQLDataException {
        switch (column.getType()) {
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                if (column.isBinary()) {
                    buf.skip(length);
                    throw new SQLDataException(String.format("Data type %s cannot be decoded as Reader", new Object[]{column.getType()}));
                }
            }
            case STRING: 
            case VARCHAR: 
            case VARSTRING: {
                return new StringReader(buf.readString(length));
            }
        }
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Reader", new Object[]{column.getType()}));
    }

    @Override
    public Reader decodeBinary(ReadableByteBuf buf, int length, ColumnDefinitionPacket column, Calendar cal) throws SQLDataException {
        return this.decodeText(buf, length, column, cal);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Reader;
    }

    @Override
    public void encodeText(PacketWriter encoder, Context context, Object val, Calendar cal, Long maxLen) throws IOException {
        Reader reader = (Reader)val;
        encoder.writeByte(39);
        char[] buf = new char[4096];
        if (maxLen == null) {
            int len;
            while ((len = reader.read(buf)) >= 0) {
                byte[] data = new String(buf, 0, len).getBytes(StandardCharsets.UTF_8);
                encoder.writeBytesEscaped(data, data.length, (context.getServerStatus() & 0x200) != 0);
            }
        } else {
            int len;
            while ((len = reader.read(buf)) >= 0) {
                byte[] data = new String(buf, 0, Math.min(len, maxLen.intValue())).getBytes(StandardCharsets.UTF_8);
                maxLen = maxLen - (long)len;
                encoder.writeBytesEscaped(data, data.length, (context.getServerStatus() & 0x200) != 0);
            }
        }
        encoder.writeByte(39);
    }

    @Override
    public void encodeBinary(PacketWriter encoder, Object val, Calendar cal, Long maxLength) throws IOException {
        int len;
        long maxLen;
        byte[] clobBytes = new byte[4096];
        int pos = 0;
        char[] buf = new char[4096];
        Reader reader = (Reader)val;
        long l = maxLen = maxLength != null ? maxLength : Long.MAX_VALUE;
        while (maxLen > 0L && (len = reader.read(buf)) > 0) {
            byte[] data = new String(buf, 0, (int)Math.min((long)len, maxLen)).getBytes(StandardCharsets.UTF_8);
            if (clobBytes.length - pos < data.length) {
                byte[] newBlobBytes = new byte[clobBytes.length + 65536];
                System.arraycopy(clobBytes, 0, newBlobBytes, 0, pos);
                clobBytes = newBlobBytes;
            }
            System.arraycopy(data, 0, clobBytes, pos, data.length);
            pos += data.length;
            maxLen -= (long)len;
        }
        encoder.writeLength(pos);
        encoder.writeBytes(clobBytes, 0, pos);
    }

    @Override
    public void encodeLongData(PacketWriter encoder, Reader reader, Long maxLength) throws IOException {
        int len;
        long maxLen;
        char[] buf = new char[4096];
        long l = maxLen = maxLength != null ? maxLength : Long.MAX_VALUE;
        while (maxLen > 0L && (len = reader.read(buf)) >= 0) {
            byte[] data = new String(buf, 0, (int)Math.min((long)len, maxLen)).getBytes(StandardCharsets.UTF_8);
            encoder.writeBytes(data, 0, data.length);
            maxLen -= (long)len;
        }
    }

    @Override
    public byte[] encodeData(Reader reader, Long maxLength) throws IOException {
        int len;
        long maxLen;
        ByteArrayOutputStream bb = new ByteArrayOutputStream();
        char[] buf = new char[4096];
        long l = maxLen = maxLength != null ? maxLength : Long.MAX_VALUE;
        while (maxLen > 0L && (len = reader.read(buf)) >= 0) {
            byte[] data = new String(buf, 0, (int)Math.min((long)len, maxLen)).getBytes(StandardCharsets.UTF_8);
            bb.write(data, 0, data.length);
            maxLen -= (long)len;
        }
        return bb.toByteArray();
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.VARSTRING.get();
    }

    @Override
    public boolean canEncodeLongData() {
        return true;
    }
}

