/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.client;

import java.nio.charset.StandardCharsets;
import org.mariadb.jdbc.MariaDbBlob;
import org.mariadb.jdbc.util.MutableInt;

public final class ReadableByteBuf {
    private final MutableInt sequence;
    private int limit;
    private byte[] buf;
    private int pos;
    private int mark;

    public ReadableByteBuf(MutableInt sequence, byte[] buf, int limit) {
        this.sequence = sequence;
        this.pos = 0;
        this.buf = buf;
        this.limit = limit;
        this.mark = -1;
    }

    public int readableBytes() {
        return this.limit - this.pos;
    }

    public int pos() {
        return this.pos;
    }

    public byte[] buf() {
        return this.buf;
    }

    public ReadableByteBuf buf(byte[] buf, int limit) {
        this.buf = buf;
        this.limit = limit;
        return this;
    }

    public void pos(int pos) {
        this.pos = pos;
    }

    public void mark() {
        this.mark = this.pos;
    }

    public void reset() {
        if (this.mark == -1) {
            throw new IllegalStateException("mark was not set");
        }
        this.pos = this.mark;
    }

    public void skip() {
        ++this.pos;
    }

    public ReadableByteBuf skip(int length) {
        this.pos += length;
        return this;
    }

    public MariaDbBlob readBlob(int length) {
        this.pos += length;
        return MariaDbBlob.safeMariaDbBlob(this.buf, this.pos - length, length);
    }

    public MutableInt getSequence() {
        return this.sequence;
    }

    public byte getByte() {
        return this.buf[this.pos];
    }

    public byte getByte(int index) {
        return this.buf[index];
    }

    public short getUnsignedByte() {
        return (short)(this.buf[this.pos] & 0xFF);
    }

    public int readLengthNotNull() {
        int type = this.buf[this.pos++] & 0xFF;
        switch (type) {
            case 252: {
                return this.readUnsignedShort();
            }
            case 253: {
                return this.readUnsignedMedium();
            }
            case 254: {
                return (int)this.readLong();
            }
        }
        return type;
    }

    public int skipIdentifier() {
        int type;
        if ((type = this.buf[this.pos++] & 0xFF) == 252) {
            this.pos += this.readUnsignedShort();
            return this.pos;
        }
        this.pos += type;
        return this.pos;
    }

    public Integer readLength() {
        short type = this.readUnsignedByte();
        switch (type) {
            case 251: {
                return null;
            }
            case 252: {
                return this.readUnsignedShort();
            }
            case 253: {
                return this.readUnsignedMedium();
            }
            case 254: {
                return (int)this.readLong();
            }
        }
        return type;
    }

    public byte readByte() {
        return this.buf[this.pos++];
    }

    public short readUnsignedByte() {
        return (short)(this.buf[this.pos++] & 0xFF);
    }

    public short readShort() {
        return (short)(this.buf[this.pos++] & 0xFF | this.buf[this.pos++] << 8);
    }

    public int readUnsignedShort() {
        return (this.buf[this.pos++] & 0xFF | this.buf[this.pos++] << 8) & 0xFFFF;
    }

    public int readMedium() {
        int value = this.readUnsignedMedium();
        if ((value & 0x800000) != 0) {
            value |= 0xFF000000;
        }
        return value;
    }

    public int readUnsignedMedium() {
        return (this.buf[this.pos++] & 0xFF) + ((this.buf[this.pos++] & 0xFF) << 8) + ((this.buf[this.pos++] & 0xFF) << 16);
    }

    public int readInt() {
        return (this.buf[this.pos++] & 0xFF) + ((this.buf[this.pos++] & 0xFF) << 8) + ((this.buf[this.pos++] & 0xFF) << 16) + ((this.buf[this.pos++] & 0xFF) << 24);
    }

    public int readIntBE() {
        return ((this.buf[this.pos++] & 0xFF) << 24) + ((this.buf[this.pos++] & 0xFF) << 16) + ((this.buf[this.pos++] & 0xFF) << 8) + (this.buf[this.pos++] & 0xFF);
    }

    public long readUnsignedInt() {
        return (long)((this.buf[this.pos++] & 0xFF) + ((this.buf[this.pos++] & 0xFF) << 8) + ((this.buf[this.pos++] & 0xFF) << 16)) + ((long)(this.buf[this.pos++] & 0xFF) << 24) & 0xFFFFFFFFL;
    }

    public long readLong() {
        return ((long)this.buf[this.pos++] & 0xFFL) + (((long)this.buf[this.pos++] & 0xFFL) << 8) + (((long)this.buf[this.pos++] & 0xFFL) << 16) + (((long)this.buf[this.pos++] & 0xFFL) << 24) + (((long)this.buf[this.pos++] & 0xFFL) << 32) + (((long)this.buf[this.pos++] & 0xFFL) << 40) + (((long)this.buf[this.pos++] & 0xFFL) << 48) + (((long)this.buf[this.pos++] & 0xFFL) << 56);
    }

    public long readLongBE() {
        return (((long)this.buf[this.pos++] & 0xFFL) << 56) + (((long)this.buf[this.pos++] & 0xFFL) << 48) + (((long)this.buf[this.pos++] & 0xFFL) << 40) + (((long)this.buf[this.pos++] & 0xFFL) << 32) + (((long)this.buf[this.pos++] & 0xFFL) << 24) + (((long)this.buf[this.pos++] & 0xFFL) << 16) + (((long)this.buf[this.pos++] & 0xFFL) << 8) + ((long)this.buf[this.pos++] & 0xFFL);
    }

    public ReadableByteBuf readBytes(byte[] dst) {
        System.arraycopy(this.buf, this.pos, dst, 0, dst.length);
        this.pos += dst.length;
        return this;
    }

    public byte[] readBytesNullEnd() {
        int initialPosition = this.pos;
        int cnt = 0;
        while (this.readableBytes() > 0 && this.buf[this.pos++] != 0) {
            ++cnt;
        }
        byte[] dst = new byte[cnt];
        System.arraycopy(this.buf, initialPosition, dst, 0, dst.length);
        return dst;
    }

    public ReadableByteBuf readLengthBuffer() {
        int len = this.readLengthNotNull();
        byte[] tmp = new byte[len];
        this.readBytes(tmp);
        return new ReadableByteBuf(this.sequence, tmp, len);
    }

    public String readString(int length) {
        this.pos += length;
        return new String(this.buf, this.pos - length, length, StandardCharsets.UTF_8);
    }

    public String readAscii(int length) {
        this.pos += length;
        return new String(this.buf, this.pos - length, length, StandardCharsets.US_ASCII);
    }

    public String readStringNullEnd() {
        int initialPosition = this.pos;
        int cnt = 0;
        while (this.readableBytes() > 0 && this.buf[this.pos++] != 0) {
            ++cnt;
        }
        return new String(this.buf, initialPosition, cnt, StandardCharsets.UTF_8);
    }

    public String readStringEof() {
        int initialPosition = this.pos;
        this.pos = this.limit;
        return new String(this.buf, initialPosition, this.pos - initialPosition, StandardCharsets.UTF_8);
    }

    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public double readDoubleBE() {
        return Double.longBitsToDouble(this.readLongBE());
    }
}

