/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.concurrent.locks.ReentrantLock;
import org.mariadb.jdbc.BaseCallableStatement;
import org.mariadb.jdbc.Connection;
import org.mariadb.jdbc.client.result.Result;
import org.mariadb.jdbc.util.ParameterList;

public class FunctionStatement
extends BaseCallableStatement
implements CallableStatement {
    public FunctionStatement(Connection con, String databaseName, String procedureName, String arguments, ReentrantLock lock, boolean canUseServerTimeout, boolean canUseServerMaxRows, int resultSetType, int resultSetConcurrency) throws SQLException {
        super("SELECT " + procedureName + arguments, con, lock, databaseName, procedureName, canUseServerTimeout, canUseServerMaxRows, resultSetType, resultSetConcurrency, 0);
        this.registerOutParameter(1, null);
    }

    @Override
    public boolean isFunction() {
        return true;
    }

    @Override
    protected void handleParameterOutput() throws SQLException {
        this.outputResult = (Result)this.results.remove(this.results.size() - 1);
        this.outputResult.next();
    }

    @Override
    public void registerOutParameter(int index, int sqlType) throws SQLException {
        if (index != 1) {
            throw this.exceptionFactory().create(String.format("wrong parameter index %s", index));
        }
        super.registerOutParameter(index, sqlType);
    }

    @Override
    protected void validParameters() throws SQLException {
        ParameterList newParameters = new ParameterList(this.parameters.size() - 1);
        for (int i = 0; i < this.parameters.size() - 1; ++i) {
            newParameters.set(i, this.parameters.get(i + 1));
        }
        this.parameters = newParameters;
        super.validParameters();
    }
}

