/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.lang.reflect.Field;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.SslMode;
import org.mariadb.jdbc.TransactionIsolation;
import org.mariadb.jdbc.plugin.Codec;
import org.mariadb.jdbc.plugin.CredentialPlugin;
import org.mariadb.jdbc.plugin.credential.CredentialPluginLoader;
import org.mariadb.jdbc.util.constants.HaMode;
import org.mariadb.jdbc.util.options.OptionAliases;

public class Configuration {
    private static final Pattern URL_PARAMETER = Pattern.compile("(/([^?]*))?(\\?(.+))*", 32);
    private String user = null;
    private String password = null;
    private String database = null;
    private List<HostAddress> addresses = null;
    private HaMode haMode = HaMode.NONE;
    private String initialUrl = null;
    private Properties nonMappedOptions = null;
    private String timezone = null;
    private boolean autocommit = true;
    private boolean useMysqlMetadata = false;
    private TransactionIsolation transactionIsolation = TransactionIsolation.REPEATABLE_READ;
    private int defaultFetchSize = 0;
    private int maxQuerySizeToLog = 1024;
    private String geometryDefaultType = null;
    private String restrictedAuth = null;
    private String socketFactory = null;
    private int connectTimeout = DriverManager.getLoginTimeout() > 0 ? DriverManager.getLoginTimeout() * 1000 : 30000;
    private String pipe = null;
    private String localSocket = null;
    private boolean tcpKeepAlive = false;
    private int tcpKeepIdle = 0;
    private int tcpKeepCount = 0;
    private int tcpKeepInterval = 0;
    private boolean tcpAbortiveClose = false;
    private String localSocketAddress = null;
    private int socketTimeout = 0;
    private boolean useReadAheadInput = true;
    private String tlsSocketType = null;
    private SslMode sslMode = SslMode.DISABLE;
    private String serverSslCert = null;
    private String keyStore = null;
    private String keyStorePassword = null;
    private String keyStoreType = null;
    private String enabledSslCipherSuites = null;
    private String enabledSslProtocolSuites = null;
    private boolean allowMultiQueries = false;
    private boolean allowLocalInfile = false;
    private boolean useCompression = false;
    private boolean useAffectedRows = false;
    private boolean useBulkStmts = true;
    private boolean cachePrepStmts = true;
    private int prepStmtCacheSize = 250;
    private boolean useServerPrepStmts = false;
    private CredentialPlugin credentialType = null;
    private String sessionVariables = null;
    private String connectionAttributes = null;
    private String servicePrincipalName = null;
    private boolean blankTableNameMeta = false;
    private boolean tinyInt1isBit = true;
    private boolean yearIsDateType = true;
    private boolean dumpQueriesOnException = false;
    private boolean includeInnodbStatusInDeadlockExceptions = false;
    private boolean includeThreadDumpInDeadlockExceptions = false;
    private int retriesAllDown = 120;
    private String galeraAllowedState = null;
    private boolean transactionReplay = false;
    private boolean pool = false;
    private String poolName = null;
    private int maxPoolSize = 8;
    private int minPoolSize = 8;
    private int maxIdleTime = 600000;
    private boolean registerJmxPool = true;
    private int poolValidMinDelay = 1000;
    private boolean useResetConnection = false;
    private String serverRsaPublicKeyFile = null;
    private boolean allowPublicKeyRetrieval = false;
    private Codec<?>[] codecs = null;

    private Configuration() {
    }

    private Configuration(String user, String password, String database, List<HostAddress> addresses, HaMode haMode, Properties nonMappedOptions, String timezone, boolean autocommit, boolean useMysqlMetadata, TransactionIsolation transactionIsolation, int defaultFetchSize, int maxQuerySizeToLog, String geometryDefaultType, String restrictedAuth, String socketFactory, int connectTimeout, String pipe, String localSocket, boolean tcpKeepAlive, int tcpKeepIdle, int tcpKeepCount, int tcpKeepInterval, boolean tcpAbortiveClose, String localSocketAddress, int socketTimeout, boolean useReadAheadInput, String tlsSocketType, SslMode sslMode, String serverSslCert, String keyStore, String keyStorePassword, String keyStoreType, String enabledSslCipherSuites, String enabledSslProtocolSuites, boolean allowMultiQueries, boolean allowLocalInfile, boolean useCompression, boolean useAffectedRows, boolean useBulkStmts, boolean cachePrepStmts, int prepStmtCacheSize, boolean useServerPrepStmts, CredentialPlugin credentialType, String sessionVariables, String connectionAttributes, String servicePrincipalName, boolean blankTableNameMeta, boolean tinyInt1isBit, boolean yearIsDateType, boolean dumpQueriesOnException, boolean includeInnodbStatusInDeadlockExceptions, boolean includeThreadDumpInDeadlockExceptions, int retriesAllDown, String galeraAllowedState, boolean transactionReplay, boolean pool, String poolName, int maxPoolSize, int minPoolSize, int maxIdleTime, boolean registerJmxPool, int poolValidMinDelay, boolean useResetConnection, String serverRsaPublicKeyFile, boolean allowPublicKeyRetrieval) {
        this.user = user;
        this.password = password;
        this.database = database;
        this.addresses = addresses;
        this.haMode = haMode;
        this.nonMappedOptions = nonMappedOptions;
        this.timezone = timezone;
        this.autocommit = autocommit;
        this.useMysqlMetadata = useMysqlMetadata;
        this.transactionIsolation = transactionIsolation;
        this.defaultFetchSize = defaultFetchSize;
        this.maxQuerySizeToLog = maxQuerySizeToLog;
        this.geometryDefaultType = geometryDefaultType;
        this.restrictedAuth = restrictedAuth;
        this.socketFactory = socketFactory;
        this.connectTimeout = connectTimeout;
        this.pipe = pipe;
        this.localSocket = localSocket;
        this.tcpKeepAlive = tcpKeepAlive;
        this.tcpKeepIdle = tcpKeepIdle;
        this.tcpKeepCount = tcpKeepCount;
        this.tcpKeepInterval = tcpKeepInterval;
        this.tcpAbortiveClose = tcpAbortiveClose;
        this.localSocketAddress = localSocketAddress;
        this.socketTimeout = socketTimeout;
        this.useReadAheadInput = useReadAheadInput;
        this.tlsSocketType = tlsSocketType;
        this.sslMode = sslMode;
        this.serverSslCert = serverSslCert;
        this.keyStore = keyStore;
        this.keyStorePassword = keyStorePassword;
        this.keyStoreType = keyStoreType;
        this.enabledSslCipherSuites = enabledSslCipherSuites;
        this.enabledSslProtocolSuites = enabledSslProtocolSuites;
        this.allowMultiQueries = allowMultiQueries;
        this.allowLocalInfile = allowLocalInfile;
        this.useCompression = useCompression;
        this.useAffectedRows = useAffectedRows;
        this.useBulkStmts = useBulkStmts;
        this.cachePrepStmts = cachePrepStmts;
        this.prepStmtCacheSize = prepStmtCacheSize;
        this.useServerPrepStmts = useServerPrepStmts;
        this.credentialType = credentialType;
        this.sessionVariables = sessionVariables;
        this.connectionAttributes = connectionAttributes;
        this.servicePrincipalName = servicePrincipalName;
        this.blankTableNameMeta = blankTableNameMeta;
        this.tinyInt1isBit = tinyInt1isBit;
        this.yearIsDateType = yearIsDateType;
        this.dumpQueriesOnException = dumpQueriesOnException;
        this.includeInnodbStatusInDeadlockExceptions = includeInnodbStatusInDeadlockExceptions;
        this.includeThreadDumpInDeadlockExceptions = includeThreadDumpInDeadlockExceptions;
        this.retriesAllDown = retriesAllDown;
        this.galeraAllowedState = galeraAllowedState;
        this.transactionReplay = transactionReplay;
        this.pool = pool;
        this.poolName = poolName;
        this.maxPoolSize = maxPoolSize;
        this.minPoolSize = minPoolSize;
        this.maxIdleTime = maxIdleTime;
        this.registerJmxPool = registerJmxPool;
        this.poolValidMinDelay = poolValidMinDelay;
        this.useResetConnection = useResetConnection;
        this.serverRsaPublicKeyFile = serverRsaPublicKeyFile;
        this.allowPublicKeyRetrieval = allowPublicKeyRetrieval;
        this.initialUrl = Configuration.buildUrl(this);
    }

    private Configuration(String database, List<HostAddress> addresses, HaMode haMode, String user, String password, String enabledSslProtocolSuites, String socketFactory, Integer connectTimeout, String pipe, String localSocket, Boolean tcpKeepAlive, Integer tcpKeepIdle, Integer tcpKeepCount, Integer tcpKeepInterval, Boolean tcpAbortiveClose, String localSocketAddress, Integer socketTimeout, Boolean allowMultiQueries, Boolean allowLocalInfile, Boolean useCompression, Boolean blankTableNameMeta, String credentialType, String sslMode, String transactionIsolation, String enabledSslCipherSuites, String sessionVariables, Boolean tinyInt1isBit, Boolean yearIsDateType, String timezone, Boolean dumpQueriesOnException, Integer prepStmtCacheSize, Boolean useAffectedRows, Boolean useServerPrepStmts, String connectionAttributes, Boolean useBulkStmts, Boolean autocommit, Boolean useMysqlMetadata, Boolean includeInnodbStatusInDeadlockExceptions, Boolean includeThreadDumpInDeadlockExceptions, String servicePrincipalName, Integer defaultFetchSize, String tlsSocketType, Integer maxQuerySizeToLog, Integer retriesAllDown, String galeraAllowedState, Boolean pool, String poolName, Integer maxPoolSize, Integer minPoolSize, Integer maxIdleTime, Boolean registerJmxPool, Integer poolValidMinDelay, Boolean useResetConnection, String serverRsaPublicKeyFile, Boolean allowPublicKeyRetrieval, String serverSslCert, String keyStore, String keyStorePassword, String keyStoreType, Boolean useReadAheadInput, Boolean cachePrepStmts, Boolean transactionReplay, String geometryDefaultType, String restrictedAuth, Properties nonMappedOptions) throws SQLException {
        this.database = database;
        this.addresses = addresses;
        this.nonMappedOptions = nonMappedOptions;
        if (haMode != null) {
            this.haMode = haMode;
        }
        this.credentialType = CredentialPluginLoader.get(credentialType);
        this.user = user;
        this.password = password;
        this.enabledSslProtocolSuites = enabledSslProtocolSuites;
        this.socketFactory = socketFactory;
        if (connectTimeout != null) {
            this.connectTimeout = connectTimeout;
        }
        this.pipe = pipe;
        this.localSocket = localSocket;
        if (tcpKeepAlive != null) {
            this.tcpKeepAlive = tcpKeepAlive;
        }
        if (tcpKeepIdle != null) {
            this.tcpKeepIdle = tcpKeepIdle;
        }
        if (tcpKeepCount != null) {
            this.tcpKeepCount = tcpKeepCount;
        }
        if (tcpKeepInterval != null) {
            this.tcpKeepInterval = tcpKeepInterval;
        }
        if (tcpAbortiveClose != null) {
            this.tcpAbortiveClose = tcpAbortiveClose;
        }
        this.localSocketAddress = localSocketAddress;
        if (socketTimeout != null) {
            this.socketTimeout = socketTimeout;
        }
        if (allowMultiQueries != null) {
            this.allowMultiQueries = allowMultiQueries;
        }
        if (allowLocalInfile != null) {
            this.allowLocalInfile = allowLocalInfile;
        }
        if (useCompression != null) {
            this.useCompression = useCompression;
        }
        if (blankTableNameMeta != null) {
            this.blankTableNameMeta = blankTableNameMeta;
        }
        if (this.credentialType != null && this.credentialType.mustUseSsl() && (sslMode == null || SslMode.from(sslMode) == SslMode.DISABLE)) {
            this.sslMode = SslMode.VERIFY_FULL;
        } else {
            SslMode sslMode2 = this.sslMode = sslMode != null ? SslMode.from(sslMode) : SslMode.DISABLE;
        }
        if (transactionIsolation != null) {
            this.transactionIsolation = TransactionIsolation.from(transactionIsolation);
        }
        this.enabledSslCipherSuites = enabledSslCipherSuites;
        this.sessionVariables = sessionVariables;
        if (tinyInt1isBit != null) {
            this.tinyInt1isBit = tinyInt1isBit;
        }
        if (yearIsDateType != null) {
            this.yearIsDateType = yearIsDateType;
        }
        this.timezone = timezone;
        if (dumpQueriesOnException != null) {
            this.dumpQueriesOnException = dumpQueriesOnException;
        }
        if (prepStmtCacheSize != null) {
            this.prepStmtCacheSize = prepStmtCacheSize;
        }
        if (useAffectedRows != null) {
            this.useAffectedRows = useAffectedRows;
        }
        if (useServerPrepStmts != null) {
            this.useServerPrepStmts = useServerPrepStmts;
        }
        this.connectionAttributes = connectionAttributes;
        if (useBulkStmts != null) {
            this.useBulkStmts = useBulkStmts;
        }
        if (autocommit != null) {
            this.autocommit = autocommit;
        }
        if (useMysqlMetadata != null) {
            this.useMysqlMetadata = useMysqlMetadata;
        }
        if (includeInnodbStatusInDeadlockExceptions != null) {
            this.includeInnodbStatusInDeadlockExceptions = includeInnodbStatusInDeadlockExceptions;
        }
        if (includeThreadDumpInDeadlockExceptions != null) {
            this.includeThreadDumpInDeadlockExceptions = includeThreadDumpInDeadlockExceptions;
        }
        if (servicePrincipalName != null) {
            this.servicePrincipalName = servicePrincipalName;
        }
        if (defaultFetchSize != null) {
            this.defaultFetchSize = defaultFetchSize;
        }
        if (tlsSocketType != null) {
            this.tlsSocketType = tlsSocketType;
        }
        if (maxQuerySizeToLog != null) {
            this.maxQuerySizeToLog = maxQuerySizeToLog;
        }
        if (retriesAllDown != null) {
            this.retriesAllDown = retriesAllDown;
        }
        if (galeraAllowedState != null) {
            this.galeraAllowedState = galeraAllowedState;
        }
        if (pool != null) {
            this.pool = pool;
        }
        if (poolName != null) {
            this.poolName = poolName;
        }
        if (maxPoolSize != null) {
            this.maxPoolSize = maxPoolSize;
        }
        this.minPoolSize = minPoolSize != null ? minPoolSize : this.maxPoolSize;
        if (maxIdleTime != null) {
            this.maxIdleTime = maxIdleTime;
        }
        if (registerJmxPool != null) {
            this.registerJmxPool = registerJmxPool;
        }
        if (poolValidMinDelay != null) {
            this.poolValidMinDelay = poolValidMinDelay;
        }
        if (useResetConnection != null) {
            this.useResetConnection = useResetConnection;
        }
        if (serverRsaPublicKeyFile != null) {
            this.serverRsaPublicKeyFile = serverRsaPublicKeyFile;
        }
        if (allowPublicKeyRetrieval != null) {
            this.allowPublicKeyRetrieval = allowPublicKeyRetrieval;
        }
        if (useReadAheadInput != null) {
            this.useReadAheadInput = useReadAheadInput;
        }
        if (cachePrepStmts != null) {
            this.cachePrepStmts = cachePrepStmts;
        }
        if (transactionReplay != null) {
            this.transactionReplay = transactionReplay;
        }
        if (geometryDefaultType != null) {
            this.geometryDefaultType = geometryDefaultType;
        }
        if (restrictedAuth != null) {
            this.restrictedAuth = restrictedAuth;
        }
        if (serverSslCert != null) {
            this.serverSslCert = serverSslCert;
        }
        if (keyStore != null) {
            this.keyStore = keyStore;
        }
        if (keyStorePassword != null) {
            this.keyStorePassword = keyStorePassword;
        }
        if (keyStoreType != null) {
            this.keyStoreType = keyStoreType;
        }
        boolean first = true;
        for (HostAddress host : addresses) {
            boolean primary;
            boolean bl = primary = haMode != HaMode.REPLICATION || first;
            if (host.primary == null) {
                host.primary = primary;
            }
            first = false;
        }
        Field[] fields = Configuration.class.getDeclaredFields();
        try {
            for (Field field : fields) {
                int val;
                if (!field.getType().equals(Integer.TYPE) || (val = field.getInt(this)) >= 0) continue;
                throw new SQLException(String.format("Value for %s must be >= 1 (value is %s)", field.getName(), val));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
    }

    public static boolean acceptsUrl(String url) {
        return url != null && url.startsWith("jdbc:mariadb:");
    }

    public static Configuration parse(String url) throws SQLException {
        return Configuration.parse(url, new Properties());
    }

    public static Configuration parse(String url, Properties prop) throws SQLException {
        if (Configuration.acceptsUrl(url)) {
            return Configuration.parseInternal(url, prop == null ? new Properties() : prop);
        }
        return null;
    }

    private static Configuration parseInternal(String url, Properties properties) throws SQLException {
        try {
            String additionalParameters;
            String hostAddressesString;
            Builder builder = new Builder();
            int separator = url.indexOf("//");
            if (separator == -1) {
                throw new IllegalArgumentException("url parsing error : '//' is not present in the url " + url);
            }
            builder.haMode(Configuration.parseHaMode(url, separator));
            String urlSecondPart = url.substring(separator + 2);
            int dbIndex = urlSecondPart.indexOf("/");
            int paramIndex = urlSecondPart.indexOf("?");
            if (dbIndex < paramIndex && dbIndex < 0 || dbIndex > paramIndex && paramIndex > -1) {
                hostAddressesString = urlSecondPart.substring(0, paramIndex);
                additionalParameters = urlSecondPart.substring(paramIndex);
            } else if (dbIndex < paramIndex || dbIndex > paramIndex) {
                hostAddressesString = urlSecondPart.substring(0, dbIndex);
                additionalParameters = urlSecondPart.substring(dbIndex);
            } else {
                hostAddressesString = urlSecondPart;
                additionalParameters = null;
            }
            if (additionalParameters != null) {
                String urlParameters;
                Matcher matcher = URL_PARAMETER.matcher(additionalParameters);
                matcher.find();
                String database = matcher.group(2);
                if (database != null && !database.isEmpty()) {
                    builder.database(database);
                }
                if ((urlParameters = matcher.group(4)) != null && !urlParameters.isEmpty()) {
                    String[] parameters;
                    for (String parameter : parameters = urlParameters.split("&")) {
                        int pos = parameter.indexOf(61);
                        if (pos == -1) {
                            properties.setProperty(parameter, "");
                            continue;
                        }
                        properties.setProperty(parameter.substring(0, pos), parameter.substring(pos + 1));
                    }
                }
            } else {
                builder.database(null);
            }
            Configuration.mapPropertiesToOption(builder, properties);
            builder._addresses = HostAddress.parse(hostAddressesString, builder._haMode);
            return builder.build();
        }
        catch (IllegalArgumentException i) {
            throw new SQLException("error parsing url : " + i.getMessage(), i);
        }
    }

    private static void mapPropertiesToOption(Builder builder, Properties properties) {
        Properties nonMappedOptions = new Properties();
        try {
            for (Object keyObj : properties.keySet()) {
                Object propertyValue;
                String realKey = OptionAliases.OPTIONS_ALIASES.get(keyObj);
                if (realKey == null) {
                    realKey = keyObj.toString();
                }
                if ((propertyValue = properties.get(keyObj)) == null || realKey == null) continue;
                try {
                    Field field = Builder.class.getDeclaredField(realKey);
                    field.setAccessible(true);
                    if (field.getGenericType().equals(String.class) && !propertyValue.toString().isEmpty()) {
                        field.set(builder, propertyValue);
                        continue;
                    }
                    if (field.getGenericType().equals(Boolean.class)) {
                        switch (propertyValue.toString().toLowerCase()) {
                            case "": 
                            case "1": 
                            case "true": {
                                field.set(builder, Boolean.TRUE);
                                break;
                            }
                            case "0": 
                            case "false": {
                                field.set(builder, Boolean.FALSE);
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException(String.format("Optional parameter %s must be boolean (true/false or 0/1) was '%s'", keyObj, propertyValue));
                            }
                        }
                        continue;
                    }
                    if (!field.getGenericType().equals(Integer.class)) continue;
                    try {
                        Integer value = Integer.parseInt(propertyValue.toString());
                        field.set(builder, value);
                    }
                    catch (NumberFormatException n) {
                        throw new IllegalArgumentException(String.format("Optional parameter %s must be Integer, was '%s'", keyObj, propertyValue));
                    }
                }
                catch (NoSuchFieldException nfe) {
                    nonMappedOptions.put(keyObj, propertyValue);
                }
            }
            if (Configuration.isSet("useSsl", nonMappedOptions) || Configuration.isSet("useSSL", nonMappedOptions)) {
                if (Configuration.isSet("trustServerCertificate", nonMappedOptions)) {
                    builder.sslMode("trust");
                } else if (Configuration.isSet("disableSslHostnameVerification", nonMappedOptions)) {
                    builder.sslMode("verify-ca");
                } else {
                    builder.sslMode("verify-full");
                }
            }
        }
        catch (IllegalAccessException | SecurityException s) {
            throw new IllegalArgumentException("Unexpected error", s);
        }
        builder._nonMappedOptions = nonMappedOptions;
    }

    private static boolean isSet(String key, Properties nonMappedOptions) {
        String value = nonMappedOptions.getProperty(key);
        return value != null && (value.equals("1") || value.equals("true") || value.isEmpty());
    }

    private static HaMode parseHaMode(String url, int separator) {
        int firstColonPos = url.indexOf(58);
        int secondColonPos = url.indexOf(58, firstColonPos + 1);
        int thirdColonPos = url.indexOf(58, secondColonPos + 1);
        if (thirdColonPos > separator || thirdColonPos == -1) {
            if (secondColonPos == separator - 1) {
                return HaMode.NONE;
            }
            thirdColonPos = separator;
        }
        try {
            String haModeString = url.substring(secondColonPos + 1, thirdColonPos);
            if ("FAILOVER".equalsIgnoreCase(haModeString)) {
                haModeString = "LOADBALANCE";
            }
            return HaMode.from(haModeString);
        }
        catch (IllegalArgumentException i) {
            throw new IllegalArgumentException("wrong failover parameter format in connection String " + url);
        }
    }

    public Configuration clone(String username, String password) {
        return new Configuration((String)(username != null && username.isEmpty() ? null : username), (String)(password != null && password.isEmpty() ? null : password), this.database, this.addresses, this.haMode, this.nonMappedOptions, this.timezone, this.autocommit, this.useMysqlMetadata, this.transactionIsolation, this.defaultFetchSize, this.maxQuerySizeToLog, this.geometryDefaultType, this.restrictedAuth, this.socketFactory, this.connectTimeout, this.pipe, this.localSocket, this.tcpKeepAlive, this.tcpKeepIdle, this.tcpKeepCount, this.tcpKeepInterval, this.tcpAbortiveClose, this.localSocketAddress, this.socketTimeout, this.useReadAheadInput, this.tlsSocketType, this.sslMode, this.serverSslCert, this.keyStore, this.keyStorePassword, this.keyStoreType, this.enabledSslCipherSuites, this.enabledSslProtocolSuites, this.allowMultiQueries, this.allowLocalInfile, this.useCompression, this.useAffectedRows, this.useBulkStmts, this.cachePrepStmts, this.prepStmtCacheSize, this.useServerPrepStmts, this.credentialType, this.sessionVariables, this.connectionAttributes, this.servicePrincipalName, this.blankTableNameMeta, this.tinyInt1isBit, this.yearIsDateType, this.dumpQueriesOnException, this.includeInnodbStatusInDeadlockExceptions, this.includeThreadDumpInDeadlockExceptions, this.retriesAllDown, this.galeraAllowedState, this.transactionReplay, this.pool, this.poolName, this.maxPoolSize, this.minPoolSize, this.maxIdleTime, this.registerJmxPool, this.poolValidMinDelay, this.useResetConnection, this.serverRsaPublicKeyFile, this.allowPublicKeyRetrieval);
    }

    public String database() {
        return this.database;
    }

    public List<HostAddress> addresses() {
        return this.addresses;
    }

    public HaMode haMode() {
        return this.haMode;
    }

    public CredentialPlugin credentialPlugin() {
        return this.credentialType;
    }

    public String user() {
        return this.user;
    }

    public String password() {
        return this.password;
    }

    public String initialUrl() {
        return this.initialUrl;
    }

    public String serverSslCert() {
        return this.serverSslCert;
    }

    public String keyStore() {
        return this.keyStore;
    }

    public String keyStorePassword() {
        return this.keyStorePassword;
    }

    public String keyStoreType() {
        return this.keyStoreType;
    }

    public String enabledSslProtocolSuites() {
        return this.enabledSslProtocolSuites;
    }

    public String socketFactory() {
        return this.socketFactory;
    }

    public int connectTimeout() {
        return this.connectTimeout;
    }

    public Configuration connectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public String pipe() {
        return this.pipe;
    }

    public String localSocket() {
        return this.localSocket;
    }

    public boolean tcpKeepAlive() {
        return this.tcpKeepAlive;
    }

    public int tcpKeepIdle() {
        return this.tcpKeepIdle;
    }

    public int tcpKeepCount() {
        return this.tcpKeepCount;
    }

    public int tcpKeepInterval() {
        return this.tcpKeepInterval;
    }

    public boolean tcpAbortiveClose() {
        return this.tcpAbortiveClose;
    }

    public String localSocketAddress() {
        return this.localSocketAddress;
    }

    public int socketTimeout() {
        return this.socketTimeout;
    }

    public boolean allowMultiQueries() {
        return this.allowMultiQueries;
    }

    public boolean allowLocalInfile() {
        return this.allowLocalInfile;
    }

    public boolean useCompression() {
        return this.useCompression;
    }

    public boolean blankTableNameMeta() {
        return this.blankTableNameMeta;
    }

    public SslMode sslMode() {
        return this.sslMode;
    }

    public TransactionIsolation transactionIsolation() {
        return this.transactionIsolation;
    }

    public String enabledSslCipherSuites() {
        return this.enabledSslCipherSuites;
    }

    public String sessionVariables() {
        return this.sessionVariables;
    }

    public boolean tinyInt1isBit() {
        return this.tinyInt1isBit;
    }

    public boolean yearIsDateType() {
        return this.yearIsDateType;
    }

    public String timezone() {
        return this.timezone;
    }

    public boolean dumpQueriesOnException() {
        return this.dumpQueriesOnException;
    }

    public int prepStmtCacheSize() {
        return this.prepStmtCacheSize;
    }

    public boolean useAffectedRows() {
        return this.useAffectedRows;
    }

    public boolean useServerPrepStmts() {
        return this.useServerPrepStmts;
    }

    public String connectionAttributes() {
        return this.connectionAttributes;
    }

    public boolean useBulkStmts() {
        return this.useBulkStmts;
    }

    public boolean autocommit() {
        return this.autocommit;
    }

    public boolean useMysqlMetadata() {
        return this.useMysqlMetadata;
    }

    public boolean includeInnodbStatusInDeadlockExceptions() {
        return this.includeInnodbStatusInDeadlockExceptions;
    }

    public boolean includeThreadDumpInDeadlockExceptions() {
        return this.includeThreadDumpInDeadlockExceptions;
    }

    public String servicePrincipalName() {
        return this.servicePrincipalName;
    }

    public int defaultFetchSize() {
        return this.defaultFetchSize;
    }

    public Properties nonMappedOptions() {
        return this.nonMappedOptions;
    }

    public String tlsSocketType() {
        return this.tlsSocketType;
    }

    public int maxQuerySizeToLog() {
        return this.maxQuerySizeToLog;
    }

    public int retriesAllDown() {
        return this.retriesAllDown;
    }

    public String galeraAllowedState() {
        return this.galeraAllowedState;
    }

    public boolean pool() {
        return this.pool;
    }

    public String poolName() {
        return this.poolName;
    }

    public int maxPoolSize() {
        return this.maxPoolSize;
    }

    public int minPoolSize() {
        return this.minPoolSize;
    }

    public int maxIdleTime() {
        return this.maxIdleTime;
    }

    public boolean registerJmxPool() {
        return this.registerJmxPool;
    }

    public int poolValidMinDelay() {
        return this.poolValidMinDelay;
    }

    public boolean useResetConnection() {
        return this.useResetConnection;
    }

    public String serverRsaPublicKeyFile() {
        return this.serverRsaPublicKeyFile;
    }

    public boolean allowPublicKeyRetrieval() {
        return this.allowPublicKeyRetrieval;
    }

    public boolean useReadAheadInput() {
        return this.useReadAheadInput;
    }

    public boolean cachePrepStmts() {
        return this.cachePrepStmts;
    }

    public boolean transactionReplay() {
        return this.transactionReplay;
    }

    public String geometryDefaultType() {
        return this.geometryDefaultType;
    }

    public String restrictedAuth() {
        return this.restrictedAuth;
    }

    public Codec<?>[] codecs() {
        return this.codecs;
    }

    public String toString() {
        return this.initialUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Configuration that = (Configuration)o;
        return this.initialUrl.equals(that.initialUrl);
    }

    protected static String buildUrl(Configuration conf) {
        Configuration defaultConf = new Configuration();
        StringBuilder sb = new StringBuilder();
        sb.append("jdbc:mariadb:");
        if (conf.haMode != HaMode.NONE) {
            sb.append(conf.haMode.toString().toLowerCase(Locale.ROOT)).append(":");
        }
        sb.append("//");
        for (int i = 0; i < conf.addresses.size(); ++i) {
            HostAddress hostAddress = conf.addresses.get(i);
            if (i > 0) {
                sb.append(",");
            }
            sb.append("address=(host=").append(hostAddress.host).append(")").append("(port=").append(hostAddress.port).append(")");
            sb.append("(type=").append(hostAddress.primary != false ? "primary" : "replica").append(")");
        }
        sb.append("/");
        if (conf.database != null) {
            sb.append(conf.database);
        }
        try {
            Field[] fields;
            boolean first = true;
            for (Field field : fields = Configuration.class.getDeclaredFields()) {
                Object obj;
                if ("database".equals(field.getName()) || "haMode".equals(field.getName()) || "$jacocoData".equals(field.getName()) || "addresses".equals(field.getName()) || (obj = field.get(conf)) == null || obj instanceof Properties && ((Properties)obj).size() <= 0) continue;
                if (field.getType().equals(String.class)) {
                    sb.append(first ? (char)'?' : '&');
                    first = false;
                    sb.append(field.getName()).append('=');
                    sb.append((String)obj);
                    continue;
                }
                if (field.getType().equals(Boolean.TYPE)) {
                    boolean defaultValue = field.getBoolean(defaultConf);
                    if (obj.equals(defaultValue)) continue;
                    sb.append(first ? (char)'?' : '&');
                    first = false;
                    sb.append(field.getName()).append('=');
                    sb.append(obj);
                    continue;
                }
                if (field.getType().equals(Integer.TYPE)) {
                    try {
                        int defaultValue = field.getInt(defaultConf);
                        if (obj.equals(defaultValue)) continue;
                        sb.append(first ? (char)'?' : '&');
                        sb.append(field.getName()).append('=').append(obj);
                        first = false;
                    }
                    catch (IllegalAccessException defaultValue) {}
                    continue;
                }
                if (field.getType().equals(Properties.class)) {
                    sb.append(first ? (char)'?' : '&');
                    first = false;
                    boolean firstProp = true;
                    Properties properties = (Properties)obj;
                    for (Object key : properties.keySet()) {
                        if (firstProp) {
                            firstProp = false;
                        } else {
                            sb.append('&');
                        }
                        sb.append(key).append('=');
                        sb.append(properties.get(key));
                    }
                    continue;
                }
                if (field.getType().equals(CredentialPlugin.class)) {
                    Object defaultValue = field.get(defaultConf);
                    if (obj.equals(defaultValue)) continue;
                    sb.append(first ? (char)'?' : '&');
                    first = false;
                    sb.append(field.getName()).append('=');
                    sb.append(((CredentialPlugin)obj).type());
                    continue;
                }
                Object defaultValue = field.get(defaultConf);
                if (obj.equals(defaultValue)) continue;
                sb.append(first ? (char)'?' : '&');
                first = false;
                sb.append(field.getName()).append('=');
                sb.append(obj);
            }
        }
        catch (IllegalAccessException n) {
            n.printStackTrace();
        }
        catch (SecurityException s) {
            throw new IllegalArgumentException("Security too restrictive : " + s.getMessage());
        }
        conf.loadCodecs();
        return sb.toString();
    }

    private void loadCodecs() {
        ServiceLoader<Codec> loader = ServiceLoader.load(Codec.class, Configuration.class.getClassLoader());
        ArrayList result = new ArrayList();
        loader.iterator().forEachRemaining(result::add);
        this.codecs = result.toArray(new Codec[0]);
    }

    public int hashCode() {
        return this.initialUrl.hashCode();
    }

    private static String nullOrEmpty(String val) {
        return val == null || val.isEmpty() ? null : val;
    }

    public static final class Builder
    implements Cloneable {
        private Properties _nonMappedOptions;
        private HaMode _haMode;
        private List<HostAddress> _addresses = new ArrayList<HostAddress>();
        private String user;
        private String password;
        private String database;
        private String timezone;
        private Boolean autocommit;
        private Boolean useMysqlMetadata;
        private Integer defaultFetchSize;
        private Integer maxQuerySizeToLog;
        private String geometryDefaultType;
        private String restrictedAuth;
        private String transactionIsolation;
        private String socketFactory;
        private Integer connectTimeout;
        private String pipe;
        private String localSocket;
        private Boolean tcpKeepAlive;
        private Integer tcpKeepIdle;
        private Integer tcpKeepCount;
        private Integer tcpKeepInterval;
        private Boolean tcpAbortiveClose;
        private String localSocketAddress;
        private Integer socketTimeout;
        private Boolean useReadAheadInput;
        private String tlsSocketType;
        private String sslMode;
        private String serverSslCert;
        private String keyStore;
        private String keyStorePassword;
        private String keyStoreType;
        private String enabledSslCipherSuites;
        private String enabledSslProtocolSuites;
        private Boolean allowMultiQueries;
        private Boolean allowLocalInfile;
        private Boolean useCompression;
        private Boolean useAffectedRows;
        private Boolean useBulkStmts;
        private Boolean cachePrepStmts;
        private Integer prepStmtCacheSize;
        private Boolean useServerPrepStmts;
        private String credentialType;
        private String sessionVariables;
        private String connectionAttributes;
        private String servicePrincipalName;
        private Boolean blankTableNameMeta;
        private Boolean tinyInt1isBit;
        private Boolean yearIsDateType;
        private Boolean dumpQueriesOnException;
        private Boolean includeInnodbStatusInDeadlockExceptions;
        private Boolean includeThreadDumpInDeadlockExceptions;
        private Integer retriesAllDown;
        private String galeraAllowedState;
        private Boolean transactionReplay;
        private Boolean pool;
        private String poolName;
        private Integer maxPoolSize;
        private Integer minPoolSize;
        private Integer maxIdleTime;
        private Boolean registerJmxPool;
        private Integer poolValidMinDelay;
        private Boolean useResetConnection;
        private String serverRsaPublicKeyFile;
        private Boolean allowPublicKeyRetrieval;

        public Builder user(String user) {
            this.user = Configuration.nullOrEmpty(user);
            return this;
        }

        public Builder serverSslCert(String serverSslCert) {
            this.serverSslCert = Configuration.nullOrEmpty(serverSslCert);
            return this;
        }

        public Builder keyStore(String keyStore) {
            this.keyStore = Configuration.nullOrEmpty(keyStore);
            return this;
        }

        public Builder keyStorePassword(String keyStorePassword) {
            this.keyStorePassword = Configuration.nullOrEmpty(keyStorePassword);
            return this;
        }

        public Builder keyStoreType(String keyStoreType) {
            this.keyStoreType = Configuration.nullOrEmpty(keyStoreType);
            return this;
        }

        public Builder password(String password) {
            this.password = Configuration.nullOrEmpty(password);
            return this;
        }

        public Builder enabledSslProtocolSuites(String enabledSslProtocolSuites) {
            this.enabledSslProtocolSuites = Configuration.nullOrEmpty(enabledSslProtocolSuites);
            return this;
        }

        public Builder database(String database) {
            this.database = database;
            return this;
        }

        public Builder haMode(HaMode haMode) {
            this._haMode = haMode;
            return this;
        }

        public Builder addHost(String host, int port) {
            this._addresses.add(HostAddress.from(Configuration.nullOrEmpty(host), port));
            return this;
        }

        public Builder addHost(String host, int port, boolean master) {
            this._addresses.add(HostAddress.from(Configuration.nullOrEmpty(host), port, master));
            return this;
        }

        public Builder addresses(HostAddress ... hostAddress) {
            this._addresses = new ArrayList<HostAddress>();
            this._addresses.addAll(Arrays.asList(hostAddress));
            return this;
        }

        public Builder socketFactory(String socketFactory) {
            this.socketFactory = socketFactory;
            return this;
        }

        public Builder connectTimeout(Integer connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder pipe(String pipe) {
            this.pipe = Configuration.nullOrEmpty(pipe);
            return this;
        }

        public Builder localSocket(String localSocket) {
            this.localSocket = Configuration.nullOrEmpty(localSocket);
            return this;
        }

        public Builder tcpKeepAlive(Boolean tcpKeepAlive) {
            this.tcpKeepAlive = tcpKeepAlive;
            return this;
        }

        public Builder tcpKeepIdle(Integer tcpKeepIdle) {
            this.tcpKeepIdle = tcpKeepIdle;
            return this;
        }

        public Builder tcpKeepCount(Integer tcpKeepCount) {
            this.tcpKeepCount = tcpKeepCount;
            return this;
        }

        public Builder tcpKeepInterval(Integer tcpKeepInterval) {
            this.tcpKeepInterval = tcpKeepInterval;
            return this;
        }

        public Builder tcpAbortiveClose(Boolean tcpAbortiveClose) {
            this.tcpAbortiveClose = tcpAbortiveClose;
            return this;
        }

        public Builder geometryDefaultType(String geometryDefault) {
            this.geometryDefaultType = Configuration.nullOrEmpty(geometryDefault);
            return this;
        }

        public Builder restrictedAuth(String restrictedAuth) {
            this.restrictedAuth = restrictedAuth;
            return this;
        }

        public Builder localSocketAddress(String localSocketAddress) {
            this.localSocketAddress = Configuration.nullOrEmpty(localSocketAddress);
            return this;
        }

        public Builder socketTimeout(Integer socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public Builder allowMultiQueries(Boolean allowMultiQueries) {
            this.allowMultiQueries = allowMultiQueries;
            return this;
        }

        public Builder allowLocalInfile(Boolean allowLocalInfile) {
            this.allowLocalInfile = allowLocalInfile;
            return this;
        }

        public Builder useCompression(Boolean useCompression) {
            this.useCompression = useCompression;
            return this;
        }

        public Builder blankTableNameMeta(Boolean blankTableNameMeta) {
            this.blankTableNameMeta = blankTableNameMeta;
            return this;
        }

        public Builder credentialType(String credentialType) {
            this.credentialType = Configuration.nullOrEmpty(credentialType);
            return this;
        }

        public Builder sslMode(String sslMode) {
            this.sslMode = sslMode;
            return this;
        }

        public Builder transactionIsolation(String transactionIsolation) {
            this.transactionIsolation = Configuration.nullOrEmpty(transactionIsolation);
            return this;
        }

        public Builder enabledSslCipherSuites(String enabledSslCipherSuites) {
            this.enabledSslCipherSuites = Configuration.nullOrEmpty(enabledSslCipherSuites);
            return this;
        }

        public Builder sessionVariables(String sessionVariables) {
            this.sessionVariables = Configuration.nullOrEmpty(sessionVariables);
            return this;
        }

        public Builder tinyInt1isBit(Boolean tinyInt1isBit) {
            this.tinyInt1isBit = tinyInt1isBit;
            return this;
        }

        public Builder yearIsDateType(Boolean yearIsDateType) {
            this.yearIsDateType = yearIsDateType;
            return this;
        }

        public Builder timezone(String timezone) {
            this.timezone = Configuration.nullOrEmpty(timezone);
            return this;
        }

        public Builder dumpQueriesOnException(Boolean dumpQueriesOnException) {
            this.dumpQueriesOnException = dumpQueriesOnException;
            return this;
        }

        public Builder prepStmtCacheSize(Integer prepStmtCacheSize) {
            this.prepStmtCacheSize = prepStmtCacheSize;
            return this;
        }

        public Builder useAffectedRows(Boolean useAffectedRows) {
            this.useAffectedRows = useAffectedRows;
            return this;
        }

        public Builder useServerPrepStmts(Boolean useServerPrepStmts) {
            this.useServerPrepStmts = useServerPrepStmts;
            return this;
        }

        public Builder connectionAttributes(String connectionAttributes) {
            this.connectionAttributes = Configuration.nullOrEmpty(connectionAttributes);
            return this;
        }

        public Builder useBulkStmts(Boolean useBulkStmts) {
            this.useBulkStmts = useBulkStmts;
            return this;
        }

        public Builder autocommit(Boolean autocommit) {
            this.autocommit = autocommit;
            return this;
        }

        public Builder useMysqlMetadata(Boolean useMysqlMetadata) {
            this.useMysqlMetadata = useMysqlMetadata;
            return this;
        }

        public Builder includeInnodbStatusInDeadlockExceptions(Boolean includeInnodbStatusInDeadlockExceptions) {
            this.includeInnodbStatusInDeadlockExceptions = includeInnodbStatusInDeadlockExceptions;
            return this;
        }

        public Builder includeThreadDumpInDeadlockExceptions(Boolean includeThreadDumpInDeadlockExceptions) {
            this.includeThreadDumpInDeadlockExceptions = includeThreadDumpInDeadlockExceptions;
            return this;
        }

        public Builder servicePrincipalName(String servicePrincipalName) {
            this.servicePrincipalName = Configuration.nullOrEmpty(servicePrincipalName);
            return this;
        }

        public Builder defaultFetchSize(Integer defaultFetchSize) {
            this.defaultFetchSize = defaultFetchSize;
            return this;
        }

        public Builder tlsSocketType(String tlsSocketType) {
            this.tlsSocketType = Configuration.nullOrEmpty(tlsSocketType);
            return this;
        }

        public Builder maxQuerySizeToLog(Integer maxQuerySizeToLog) {
            this.maxQuerySizeToLog = maxQuerySizeToLog;
            return this;
        }

        public Builder retriesAllDown(Integer retriesAllDown) {
            this.retriesAllDown = retriesAllDown;
            return this;
        }

        public Builder galeraAllowedState(String galeraAllowedState) {
            this.galeraAllowedState = Configuration.nullOrEmpty(galeraAllowedState);
            return this;
        }

        public Builder pool(Boolean pool) {
            this.pool = pool;
            return this;
        }

        public Builder poolName(String poolName) {
            this.poolName = Configuration.nullOrEmpty(poolName);
            return this;
        }

        public Builder maxPoolSize(Integer maxPoolSize) {
            this.maxPoolSize = maxPoolSize;
            return this;
        }

        public Builder minPoolSize(Integer minPoolSize) {
            this.minPoolSize = minPoolSize;
            return this;
        }

        public Builder maxIdleTime(Integer maxIdleTime) {
            this.maxIdleTime = maxIdleTime;
            return this;
        }

        public Builder registerJmxPool(Boolean registerJmxPool) {
            this.registerJmxPool = registerJmxPool;
            return this;
        }

        public Builder poolValidMinDelay(Integer poolValidMinDelay) {
            this.poolValidMinDelay = poolValidMinDelay;
            return this;
        }

        public Builder useResetConnection(Boolean useResetConnection) {
            this.useResetConnection = useResetConnection;
            return this;
        }

        public Builder serverRsaPublicKeyFile(String serverRsaPublicKeyFile) {
            this.serverRsaPublicKeyFile = Configuration.nullOrEmpty(serverRsaPublicKeyFile);
            return this;
        }

        public Builder allowPublicKeyRetrieval(Boolean allowPublicKeyRetrieval) {
            this.allowPublicKeyRetrieval = allowPublicKeyRetrieval;
            return this;
        }

        public Builder useReadAheadInput(Boolean useReadAheadInput) {
            this.useReadAheadInput = useReadAheadInput;
            return this;
        }

        public Builder cachePrepStmts(Boolean cachePrepStmts) {
            this.cachePrepStmts = cachePrepStmts;
            return this;
        }

        public Builder transactionReplay(Boolean transactionReplay) {
            this.transactionReplay = transactionReplay;
            return this;
        }

        public Configuration build() throws SQLException {
            Configuration conf = new Configuration(this.database, this._addresses, this._haMode, this.user, this.password, this.enabledSslProtocolSuites, this.socketFactory, this.connectTimeout, this.pipe, this.localSocket, this.tcpKeepAlive, this.tcpKeepIdle, this.tcpKeepCount, this.tcpKeepInterval, this.tcpAbortiveClose, this.localSocketAddress, this.socketTimeout, this.allowMultiQueries, this.allowLocalInfile, this.useCompression, this.blankTableNameMeta, this.credentialType, this.sslMode, this.transactionIsolation, this.enabledSslCipherSuites, this.sessionVariables, this.tinyInt1isBit, this.yearIsDateType, this.timezone, this.dumpQueriesOnException, this.prepStmtCacheSize, this.useAffectedRows, this.useServerPrepStmts, this.connectionAttributes, this.useBulkStmts, this.autocommit, this.useMysqlMetadata, this.includeInnodbStatusInDeadlockExceptions, this.includeThreadDumpInDeadlockExceptions, this.servicePrincipalName, this.defaultFetchSize, this.tlsSocketType, this.maxQuerySizeToLog, this.retriesAllDown, this.galeraAllowedState, this.pool, this.poolName, this.maxPoolSize, this.minPoolSize, this.maxIdleTime, this.registerJmxPool, this.poolValidMinDelay, this.useResetConnection, this.serverRsaPublicKeyFile, this.allowPublicKeyRetrieval, this.serverSslCert, this.keyStore, this.keyStorePassword, this.keyStoreType, this.useReadAheadInput, this.cachePrepStmts, this.transactionReplay, this.geometryDefaultType, this.restrictedAuth, this._nonMappedOptions);
            conf.initialUrl = Configuration.buildUrl(conf);
            return conf;
        }
    }
}

