/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.com.send.authentication;

import java.awt.HeadlessException;
import java.io.Console;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.mariadb.jdbc.internal.com.read.Buffer;
import org.mariadb.jdbc.internal.com.send.authentication.AuthenticationPlugin;
import org.mariadb.jdbc.internal.io.input.PacketInputStream;
import org.mariadb.jdbc.internal.io.output.PacketOutputStream;

public class SendPamAuthPacket
implements AuthenticationPlugin {
    private final String password;
    private final String passwordCharacterEncoding;
    private byte[] authData;

    public SendPamAuthPacket(String password, byte[] authData, String passwordCharacterEncoding) {
        this.authData = authData;
        this.password = password;
        this.passwordCharacterEncoding = passwordCharacterEncoding;
    }

    @Override
    public Buffer process(PacketOutputStream out, PacketInputStream in, AtomicInteger sequence) throws IOException, SQLException {
        int type = this.authData.length == 0 ? 0 : this.authData[0];
        while (true) {
            String promptb;
            String string = promptb = this.authData.length <= 1 ? null : new String(Arrays.copyOfRange(this.authData, 1, this.authData.length));
            if ((promptb == null || "Password: ".equals(promptb)) && this.password != null && !"".equals(this.password)) {
                out.startPacket(sequence.incrementAndGet());
                byte[] bytePwd = this.passwordCharacterEncoding != null && !this.passwordCharacterEncoding.isEmpty() ? this.password.getBytes(this.passwordCharacterEncoding) : this.password.getBytes();
                out.write(bytePwd, 0, bytePwd.length);
                out.write(0);
            } else {
                boolean isPassword = type == 4;
                String password = this.showInputDialog(promptb, isPassword);
                if (password == null) {
                    throw new SQLException("Error during PAM authentication : dialog input cancelled");
                }
                out.startPacket(sequence.incrementAndGet());
                byte[] bytePwd = this.passwordCharacterEncoding != null && !this.passwordCharacterEncoding.isEmpty() ? password.getBytes(this.passwordCharacterEncoding) : password.getBytes();
                out.write(bytePwd, 0, bytePwd.length);
                out.write(0);
            }
            out.flush();
            Buffer buffer = in.getPacket(true);
            sequence.set(in.getLastPacketSeq());
            type = buffer.getByteAt(0) & 0xFF;
            if (type == 254 || type == 0 || type == 255) {
                return buffer;
            }
            this.authData = buffer.readRawBytes(buffer.remaining());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String showInputDialog(String label, boolean isPassword) throws IOException {
        String password;
        try {
            if (isPassword) {
                JPasswordField pwd = new JPasswordField();
                pwd.addAncestorListener(new RequestFocusListener());
                int action = JOptionPane.showConfirmDialog(null, pwd, label, 2);
                if (action != 0) throw new IOException("Error during PAM authentication : dialog input cancelled");
                password = new String(pwd.getPassword());
            } else {
                password = JOptionPane.showInputDialog(label);
            }
        }
        catch (HeadlessException noGraphicalEnvironment) {
            Console console = System.console();
            if (console == null) {
                throw new IOException("Error during PAM authentication : input by console not possible");
            }
            if (isPassword) {
                char[] passwordChar = console.readPassword(label, new Object[0]);
                password = new String(passwordChar);
            }
            password = console.readLine(label, new Object[0]);
        }
        if (password == null) throw new IOException("Error during PAM authentication : dialog input cancelled");
        return password;
    }

    public class RequestFocusListener
    implements AncestorListener {
        private final boolean removeListener;

        public RequestFocusListener() {
            this(true);
        }

        public RequestFocusListener(boolean removeListener) {
            this.removeListener = removeListener;
        }

        @Override
        public void ancestorAdded(AncestorEvent ancestorEvent) {
            JComponent component = ancestorEvent.getComponent();
            component.requestFocusInWindow();
            if (this.removeListener) {
                component.removeAncestorListener(this);
            }
        }

        @Override
        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent ancestorEvent) {
        }
    }
}

