/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.com.send.authentication;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.mariadb.jdbc.internal.com.read.Buffer;
import org.mariadb.jdbc.internal.com.send.authentication.AuthenticationPlugin;
import org.mariadb.jdbc.internal.com.send.authentication.ed25519.math.GroupElement;
import org.mariadb.jdbc.internal.com.send.authentication.ed25519.math.ed25519.ScalarOps;
import org.mariadb.jdbc.internal.com.send.authentication.ed25519.spec.EdDSANamedCurveSpec;
import org.mariadb.jdbc.internal.com.send.authentication.ed25519.spec.EdDSANamedCurveTable;
import org.mariadb.jdbc.internal.io.input.PacketInputStream;
import org.mariadb.jdbc.internal.io.output.PacketOutputStream;

public class Ed25519PasswordPlugin
implements AuthenticationPlugin {
    private final String password;
    private final String passwordCharacterEncoding;
    private byte[] authData;

    public Ed25519PasswordPlugin(String password, byte[] authData, String passwordCharacterEncoding) {
        this.authData = authData;
        this.password = password;
        this.passwordCharacterEncoding = passwordCharacterEncoding;
    }

    @Override
    public Buffer process(PacketOutputStream out, PacketInputStream in, AtomicInteger sequence) throws IOException, SQLException {
        if (this.password == null || this.password.isEmpty()) {
            out.writeEmptyPacket(sequence.incrementAndGet());
        } else {
            out.startPacket(sequence.incrementAndGet());
            out.write(Ed25519PasswordPlugin.ed25519SignWithPassword(this.password, this.authData, this.passwordCharacterEncoding));
            out.flush();
        }
        Buffer buffer = in.getPacket(true);
        sequence.set(in.getLastPacketSeq());
        return buffer;
    }

    private static byte[] ed25519SignWithPassword(String password, byte[] seed, String passwordCharacterEncoding) throws SQLException {
        try {
            byte[] bytePwd = passwordCharacterEncoding != null && !passwordCharacterEncoding.isEmpty() ? password.getBytes(passwordCharacterEncoding) : password.getBytes();
            MessageDigest hash = MessageDigest.getInstance("SHA-512");
            int mlen = seed.length;
            byte[] sm = new byte[64 + mlen];
            byte[] az = hash.digest(bytePwd);
            az[0] = (byte)(az[0] & 0xF8);
            az[31] = (byte)(az[31] & 0x3F);
            az[31] = (byte)(az[31] | 0x40);
            System.arraycopy(seed, 0, sm, 64, mlen);
            System.arraycopy(az, 32, sm, 32, 32);
            byte[] buff = Arrays.copyOfRange(sm, 32, 96);
            hash.reset();
            byte[] nonce = hash.digest(buff);
            ScalarOps scalar = new ScalarOps();
            EdDSANamedCurveSpec spec = EdDSANamedCurveTable.getByName("Ed25519");
            GroupElement elementAvalue = spec.getB().scalarMultiply(az);
            byte[] elementAarray = elementAvalue.toByteArray();
            System.arraycopy(elementAarray, 0, sm, 32, elementAarray.length);
            nonce = scalar.reduce(nonce);
            GroupElement elementRvalue = spec.getB().scalarMultiply(nonce);
            byte[] elementRarray = elementRvalue.toByteArray();
            System.arraycopy(elementRarray, 0, sm, 0, elementRarray.length);
            hash.reset();
            byte[] hram = hash.digest(sm);
            hram = scalar.reduce(hram);
            byte[] tt = scalar.multiplyAndAdd(hram, az, nonce);
            System.arraycopy(tt, 0, sm, 32, tt.length);
            return Arrays.copyOfRange(sm, 0, 64);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SQLException("Could not use SHA-512, failing", e);
        }
        catch (UnsupportedEncodingException use) {
            throw new SQLException("Unsupported encoding '" + passwordCharacterEncoding + "' (option passwordCharacterEncoding)", use);
        }
    }
}

