/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.protocol.tls;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.sql.SQLException;
import java.util.Collection;
import java.util.UUID;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.mariadb.jdbc.internal.util.Options;
import org.mariadb.jdbc.internal.util.SqlStates;

public class MariaDbX509TrustManager
implements X509TrustManager {
    private X509TrustManager trustManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public MariaDbX509TrustManager(Options options) throws SQLException {
        KeyStore ks;
        block34: {
            if (options.trustServerCertificate) {
                return;
            }
            try {
                ks = KeyStore.getInstance(options.trustStoreType != null ? options.trustStoreType : KeyStore.getDefaultType());
            }
            catch (GeneralSecurityException generalSecurityEx) {
                throw new SQLException("Failed to create keystore instance", SqlStates.CONNECTION_EXCEPTION.getSqlState(), generalSecurityEx);
            }
            InputStream inStream = null;
            try {
                if (options.trustStore != null) {
                    try {
                        String trustStore = options.trustStore;
                        try {
                            inStream = new URL(trustStore).openStream();
                        }
                        catch (IOException ioexception) {
                            inStream = new FileInputStream(trustStore);
                        }
                        ks.load(inStream, options.trustStorePassword == null ? null : options.trustStorePassword.toCharArray());
                        break block34;
                    }
                    catch (GeneralSecurityException generalSecurityEx) {
                        throw new SQLException("Failed to create trustStore instance", SqlStates.CONNECTION_EXCEPTION.getSqlState(), generalSecurityEx);
                    }
                    catch (FileNotFoundException fileNotFoundEx) {
                        throw new SQLException("Failed to find trustStore file. trustStore=" + options.trustStore, SqlStates.CONNECTION_EXCEPTION.getSqlState(), fileNotFoundEx);
                    }
                    catch (IOException ioEx) {
                        throw new SQLException("Failed to read trustStore file. trustStore=" + options.trustStore, SqlStates.CONNECTION_EXCEPTION.getSqlState(), ioEx);
                    }
                }
                if (options.serverSslCert.startsWith("-----BEGIN CERTIFICATE-----")) {
                    inStream = new ByteArrayInputStream(options.serverSslCert.getBytes());
                } else if (options.serverSslCert.startsWith("classpath:")) {
                    String classpathFile = options.serverSslCert.substring("classpath:".length());
                    inStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(classpathFile);
                } else {
                    try {
                        inStream = new FileInputStream(options.serverSslCert);
                    }
                    catch (FileNotFoundException fileNotFoundEx) {
                        throw new SQLException("Failed to find serverSslCert file. serverSslCert=" + options.serverSslCert, SqlStates.CONNECTION_EXCEPTION.getSqlState(), fileNotFoundEx);
                    }
                }
                try {
                    ks.load(null);
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    Collection<? extends Certificate> caList = cf.generateCertificates(inStream);
                    for (Certificate certificate : caList) {
                        ks.setCertificateEntry(UUID.randomUUID().toString(), certificate);
                    }
                }
                catch (IOException ioEx) {
                    throw new SQLException("Failed load keyStore", SqlStates.CONNECTION_EXCEPTION.getSqlState(), ioEx);
                }
                catch (GeneralSecurityException generalSecurityEx) {
                    throw new SQLException("Failed to store certificate from serverSslCert into a keyStore", SqlStates.CONNECTION_EXCEPTION.getSqlState(), generalSecurityEx);
                }
            }
            finally {
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException generalSecurityEx) {}
                }
            }
        }
        try {
            void var7_21;
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ks);
            TrustManager[] trustManagerArray = tmf.getTrustManagers();
            int n = trustManagerArray.length;
            boolean bl = false;
            while (var7_21 < n) {
                TrustManager tm = trustManagerArray[var7_21];
                if (tm instanceof X509TrustManager) {
                    this.trustManager = (X509TrustManager)tm;
                    break;
                }
                ++var7_21;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmEx) {
            throw new SQLException("Failed to create TrustManagerFactory default instance", SqlStates.CONNECTION_EXCEPTION.getSqlState(), noSuchAlgorithmEx);
        }
        catch (GeneralSecurityException generalSecurityEx) {
            throw new SQLException("Failed to initialize trust manager", SqlStates.CONNECTION_EXCEPTION.getSqlState(), generalSecurityEx);
        }
        if (this.trustManager == null) {
            throw new SQLException("No X509TrustManager found");
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String string) throws CertificateException {
        if (this.trustManager == null) {
            return;
        }
        this.trustManager.checkClientTrusted(x509Certificates, string);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String string) throws CertificateException {
        if (this.trustManager == null) {
            return;
        }
        this.trustManager.checkServerTrusted(x509Certificates, string);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return null;
    }
}

