/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.mariadb.jdbc.CallParameter;
import org.mariadb.jdbc.CallableParameterMetaData;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.MariaDbPreparedStatementServer;
import org.mariadb.jdbc.internal.ColumnType;
import org.mariadb.jdbc.internal.com.read.resultset.SelectResultSet;
import org.mariadb.jdbc.internal.util.exceptions.ExceptionMapper;

public abstract class CallableProcedureStatement
extends MariaDbPreparedStatementServer
implements CallableStatement,
Cloneable {
    protected List<CallParameter> params;
    protected int[] outputParameterMapper = null;
    protected CallableParameterMetaData parameterMetadata;
    protected boolean hasInOutParameters;

    public CallableProcedureStatement(MariaDbConnection connection, String sql, int resultSetScrollType, int resultSetConcurrency) throws SQLException {
        super(connection, sql, resultSetScrollType, resultSetConcurrency, 2);
    }

    @Override
    public CallableProcedureStatement clone(MariaDbConnection connection) throws CloneNotSupportedException {
        CallableProcedureStatement clone = (CallableProcedureStatement)super.clone(connection);
        clone.params = this.params;
        clone.parameterMetadata = this.parameterMetadata;
        clone.hasInOutParameters = this.hasInOutParameters;
        clone.outputParameterMapper = this.outputParameterMapper;
        return clone;
    }

    public void setParametersVariables() {
        this.hasInOutParameters = false;
        for (CallParameter param : this.params) {
            if (param == null || !param.isOutput || !param.isInput) continue;
            this.hasInOutParameters = true;
            break;
        }
    }

    protected abstract SelectResultSet getOutputResult() throws SQLException;

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.parameterMetadata.readMetadataFromDbIfRequired();
        return this.parameterMetadata;
    }

    protected int nameToIndex(String parameterName) throws SQLException {
        this.parameterMetadata.readMetadataFromDbIfRequired();
        for (int i = 1; i <= this.parameterMetadata.getParameterCount(); ++i) {
            String name = this.parameterMetadata.getName(i);
            if (name == null || !name.equalsIgnoreCase(parameterName)) continue;
            return i;
        }
        throw new SQLException("there is no parameter with the name " + parameterName);
    }

    private int nameToOutputIndex(String parameterName) throws SQLException {
        this.parameterMetadata.readMetadataFromDbIfRequired();
        for (int i = 0; i < this.parameterMetadata.getParameterCount(); ++i) {
            String name = this.parameterMetadata.getName(i + 1);
            if (name == null || !name.equalsIgnoreCase(parameterName)) continue;
            if (this.outputParameterMapper[i] == -1) {
                throw new SQLException("Parameter '" + parameterName + "' is not declared as output parameter with method registerOutParameter");
            }
            return this.outputParameterMapper[i];
        }
        throw new SQLException("there is no parameter with the name " + parameterName);
    }

    private int indexToOutputIndex(int parameterIndex) throws SQLException {
        try {
            if (this.outputParameterMapper[parameterIndex - 1] == -1) {
                throw new SQLException("Parameter in index '" + parameterIndex + "' is not declared as output parameter with method registerOutParameter");
            }
            return this.outputParameterMapper[parameterIndex - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (parameterIndex < 1) {
                throw new SQLException("Index " + parameterIndex + " must at minimum be 1");
            }
            throw new SQLException("Index value '" + parameterIndex + "' is incorrect. Maximum value is " + this.params.size());
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.getOutputResult().wasNull();
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        return this.getOutputResult().getString(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        return this.getOutputResult().getString(this.nameToOutputIndex(parameterName));
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        return this.getOutputResult().getBoolean(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        return this.getOutputResult().getBoolean(this.nameToOutputIndex(parameterName));
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        return this.getOutputResult().getByte(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        return this.getOutputResult().getByte(this.nameToOutputIndex(parameterName));
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        return this.getOutputResult().getShort(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        return this.getOutputResult().getShort(this.nameToOutputIndex(parameterName));
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        return this.getOutputResult().getInt(this.nameToOutputIndex(parameterName));
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        return this.getOutputResult().getInt(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        return this.getOutputResult().getLong(this.nameToOutputIndex(parameterName));
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        return this.getOutputResult().getLong(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        return this.getOutputResult().getFloat(this.nameToOutputIndex(parameterName));
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        return this.getOutputResult().getFloat(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        return this.getOutputResult().getDouble(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        return this.getOutputResult().getDouble(this.nameToOutputIndex(parameterName));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        return this.getOutputResult().getBigDecimal(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        return this.getOutputResult().getBigDecimal(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        return this.getOutputResult().getBigDecimal(this.nameToOutputIndex(parameterName));
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        return this.getOutputResult().getBytes(this.nameToOutputIndex(parameterName));
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        return this.getOutputResult().getBytes(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        return this.getOutputResult().getDate(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        return this.getOutputResult().getDate(this.nameToOutputIndex(parameterName));
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        return this.getOutputResult().getDate(this.nameToOutputIndex(parameterName), cal);
    }

    @Override
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        return this.getOutputResult().getDate(parameterIndex, cal);
    }

    @Override
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        return this.getOutputResult().getTime(this.indexToOutputIndex(parameterIndex), cal);
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        return this.getOutputResult().getTime(this.nameToOutputIndex(parameterName));
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        return this.getOutputResult().getTime(this.nameToOutputIndex(parameterName), cal);
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        return this.getOutputResult().getTime(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        return this.getOutputResult().getTimestamp(parameterIndex);
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        return this.getOutputResult().getTimestamp(this.indexToOutputIndex(parameterIndex), cal);
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        return this.getOutputResult().getTimestamp(this.nameToOutputIndex(parameterName));
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        return this.getOutputResult().getTimestamp(this.nameToOutputIndex(parameterName), cal);
    }

    @Override
    public Object getObject(int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        return this.getOutputResult().getObject(this.indexToOutputIndex(parameterIndex), map);
    }

    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        Class classType = ColumnType.classFromJavaType(this.getParameter((int)parameterIndex).outputSqlType);
        if (classType != null) {
            return this.getOutputResult().getObject(this.indexToOutputIndex(parameterIndex), classType);
        }
        return this.getOutputResult().getObject(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        int index = this.nameToIndex(parameterName);
        Class classType = ColumnType.classFromJavaType(this.getParameter((int)index).outputSqlType);
        if (classType != null) {
            return this.getOutputResult().getObject(this.indexToOutputIndex(index), classType);
        }
        return this.getOutputResult().getObject(this.indexToOutputIndex(index));
    }

    @Override
    public Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        return this.getOutputResult().getObject(this.nameToOutputIndex(parameterName), map);
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        return this.getOutputResult().getObject(this.indexToOutputIndex(parameterIndex), type);
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        return this.getOutputResult().getObject(this.nameToOutputIndex(parameterName), type);
    }

    @Override
    public Ref getRef(int parameterIndex) throws SQLException {
        return this.getOutputResult().getRef(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        return this.getOutputResult().getRef(this.nameToOutputIndex(parameterName));
    }

    @Override
    public Blob getBlob(int parameterIndex) throws SQLException {
        return this.getOutputResult().getBlob(parameterIndex);
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        return this.getOutputResult().getBlob(this.nameToOutputIndex(parameterName));
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        return this.getOutputResult().getClob(this.nameToOutputIndex(parameterName));
    }

    @Override
    public Clob getClob(int parameterIndex) throws SQLException {
        return this.getOutputResult().getClob(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        return this.getOutputResult().getArray(this.nameToOutputIndex(parameterName));
    }

    @Override
    public Array getArray(int parameterIndex) throws SQLException {
        return this.getOutputResult().getArray(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        return this.getOutputResult().getURL(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        return this.getOutputResult().getURL(this.nameToOutputIndex(parameterName));
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("RowIDs not supported");
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("RowIDs not supported");
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        return this.getOutputResult().getNClob(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        return this.getOutputResult().getNClob(this.nameToOutputIndex(parameterName));
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("SQLXML not supported");
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("SQLXML not supported");
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        return this.getOutputResult().getString(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        return this.getOutputResult().getString(this.nameToOutputIndex(parameterName));
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        return this.getOutputResult().getCharacterStream(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        return this.getOutputResult().getCharacterStream(this.nameToOutputIndex(parameterName));
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        return this.getOutputResult().getCharacterStream(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        return this.getOutputResult().getCharacterStream(this.nameToOutputIndex(parameterName));
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        CallParameter callParameter = this.getParameter(parameterIndex);
        callParameter.outputSqlType = sqlType;
        callParameter.typeName = typeName;
        callParameter.isOutput = true;
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType, -1);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        CallParameter callParameter = this.getParameter(parameterIndex);
        callParameter.isOutput = true;
        callParameter.outputSqlType = sqlType;
        callParameter.scale = scale;
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        this.registerOutParameter(this.nameToIndex(parameterName), sqlType);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(this.nameToIndex(parameterName), sqlType, scale);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        this.registerOutParameter(this.nameToIndex(parameterName), sqlType, typeName);
    }

    @Override
    public void registerOutParameter(int parameterIndex, SQLType sqlType) throws SQLException {
        this.registerOutParameter(parameterIndex, (int)sqlType.getVendorTypeNumber());
    }

    @Override
    public void registerOutParameter(int parameterIndex, SQLType sqlType, int scale) throws SQLException {
        this.registerOutParameter(parameterIndex, (int)sqlType.getVendorTypeNumber(), scale);
    }

    @Override
    public void registerOutParameter(int parameterIndex, SQLType sqlType, String typeName) throws SQLException {
        this.registerOutParameter(parameterIndex, (int)sqlType.getVendorTypeNumber(), typeName);
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType) throws SQLException {
        this.registerOutParameter(parameterName, (int)sqlType.getVendorTypeNumber());
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType, int scale) throws SQLException {
        this.registerOutParameter(parameterName, (int)sqlType.getVendorTypeNumber(), scale);
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType, String typeName) throws SQLException {
        this.registerOutParameter(parameterName, (int)sqlType.getVendorTypeNumber(), typeName);
    }

    CallParameter getParameter(int index) throws SQLException {
        if (index > this.params.size() || index <= 0) {
            throw new SQLException("No parameter with index " + index);
        }
        return this.params.get(index - 1);
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("SQLXML not supported");
    }

    @Override
    public void setRowId(String parameterName, RowId rowid) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("RowIDs not supported");
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        this.setString(this.nameToIndex(parameterName), value);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        this.setCharacterStream(this.nameToIndex(parameterName), value, length);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        this.setCharacterStream(this.nameToIndex(parameterName), value);
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        this.setClob(this.nameToIndex(parameterName), (Clob)value);
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        this.setClob(this.nameToIndex(parameterName), reader, length);
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        this.setClob(this.nameToIndex(parameterName), reader);
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        this.setClob(this.nameToIndex(parameterName), reader, length);
    }

    @Override
    public void setClob(String parameterName, Clob clob) throws SQLException {
        this.setClob(this.nameToIndex(parameterName), clob);
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        this.setClob(this.nameToIndex(parameterName), reader);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        this.setBlob(this.nameToIndex(parameterName), inputStream, length);
    }

    @Override
    public void setBlob(String parameterName, Blob blob) throws SQLException {
        this.setBlob(this.nameToIndex(parameterName), blob);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        this.setBlob(this.nameToIndex(parameterName), inputStream);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream inputStream, long length) throws SQLException {
        this.setAsciiStream(this.nameToIndex(parameterName), inputStream, length);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream inputStream, int length) throws SQLException {
        this.setAsciiStream(this.nameToIndex(parameterName), inputStream, length);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream inputStream) throws SQLException {
        this.setAsciiStream(this.nameToIndex(parameterName), inputStream);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream inputStream, long length) throws SQLException {
        this.setBinaryStream(this.nameToIndex(parameterName), inputStream, length);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream inputStream) throws SQLException {
        this.setBinaryStream(this.nameToIndex(parameterName), inputStream);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream inputStream, int length) throws SQLException {
        this.setBinaryStream(this.nameToIndex(parameterName), inputStream, length);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        this.setCharacterStream(this.nameToIndex(parameterName), reader, length);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        this.setCharacterStream(this.nameToIndex(parameterName), reader);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        this.setCharacterStream(this.nameToIndex(parameterName), reader, length);
    }

    @Override
    public void setURL(String parameterName, URL url) throws SQLException {
        this.setURL(this.nameToIndex(parameterName), url);
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.setNull(this.nameToIndex(parameterName), sqlType);
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.setNull(this.nameToIndex(parameterName), sqlType, typeName);
    }

    @Override
    public void setBoolean(String parameterName, boolean booleanValue) throws SQLException {
        this.setBoolean(this.nameToIndex(parameterName), booleanValue);
    }

    @Override
    public void setByte(String parameterName, byte byteValue) throws SQLException {
        this.setByte(this.nameToIndex(parameterName), byteValue);
    }

    @Override
    public void setShort(String parameterName, short shortValue) throws SQLException {
        this.setShort(this.nameToIndex(parameterName), shortValue);
    }

    @Override
    public void setInt(String parameterName, int intValue) throws SQLException {
        this.setInt(this.nameToIndex(parameterName), intValue);
    }

    @Override
    public void setLong(String parameterName, long longValue) throws SQLException {
        this.setLong(this.nameToIndex(parameterName), longValue);
    }

    @Override
    public void setFloat(String parameterName, float floatValue) throws SQLException {
        this.setFloat(this.nameToIndex(parameterName), floatValue);
    }

    @Override
    public void setDouble(String parameterName, double doubleValue) throws SQLException {
        this.setDouble(this.nameToIndex(parameterName), doubleValue);
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal bigDecimal) throws SQLException {
        this.setBigDecimal(this.nameToIndex(parameterName), bigDecimal);
    }

    @Override
    public void setString(String parameterName, String stringValue) throws SQLException {
        this.setString(this.nameToIndex(parameterName), stringValue);
    }

    @Override
    public void setBytes(String parameterName, byte[] bytes) throws SQLException {
        this.setBytes(this.nameToIndex(parameterName), bytes);
    }

    @Override
    public void setDate(String parameterName, Date date) throws SQLException {
        this.setDate(this.nameToIndex(parameterName), date);
    }

    @Override
    public void setDate(String parameterName, Date date, Calendar cal) throws SQLException {
        this.setDate(this.nameToIndex(parameterName), date, cal);
    }

    @Override
    public void setTime(String parameterName, Time time) throws SQLException {
        this.setTime(this.nameToIndex(parameterName), time);
    }

    @Override
    public void setTime(String parameterName, Time time, Calendar cal) throws SQLException {
        this.setTime(this.nameToIndex(parameterName), time, cal);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp timestamp) throws SQLException {
        this.setTimestamp(this.nameToIndex(parameterName), timestamp);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp timestamp, Calendar cal) throws SQLException {
        this.setTimestamp(this.nameToIndex(parameterName), timestamp, cal);
    }

    @Override
    public void setObject(String parameterName, Object obj, int targetSqlType, int scale) throws SQLException {
        this.setObject(this.nameToIndex(parameterName), obj, targetSqlType, scale);
    }

    @Override
    public void setObject(String parameterName, Object obj, int targetSqlType) throws SQLException {
        this.setObject(this.nameToIndex(parameterName), obj, targetSqlType);
    }

    @Override
    public void setObject(String parameterName, Object obj) throws SQLException {
        this.setObject(this.nameToIndex(parameterName), obj);
    }

    @Override
    public void setObject(String parameterName, Object obj, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.setObject(this.nameToIndex(parameterName), obj, (int)targetSqlType.getVendorTypeNumber(), scaleOrLength);
    }

    @Override
    public void setObject(String parameterName, Object obj, SQLType targetSqlType) throws SQLException {
        this.setObject(this.nameToIndex(parameterName), obj, (int)targetSqlType.getVendorTypeNumber());
    }
}

