/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.com.read.resultset.rowprotocol;

import org.mariadb.jdbc.internal.com.read.resultset.ColumnInformation;
import org.mariadb.jdbc.internal.com.read.resultset.rowprotocol.RowProtocol;

public class BinaryRowProtocol
extends RowProtocol {
    private final ColumnInformation[] columnInformation;
    private final int columnInformationLength;

    public BinaryRowProtocol(ColumnInformation[] columnInformation, int columnInformationLength, int maxFieldSize) {
        super(maxFieldSize);
        this.columnInformation = columnInformation;
        this.columnInformationLength = columnInformationLength;
    }

    @Override
    public boolean setPosition(int newIndex) {
        if ((this.buf[1 + (newIndex + 2) / 8] & 1 << (newIndex + 2) % 8) != 0) {
            return true;
        }
        if (this.index != newIndex) {
            int internalPos = this.pos;
            if (this.index == -1 || this.index > newIndex) {
                this.index = 0;
                internalPos = 1 + (this.columnInformationLength + 9) / 8;
            } else {
                ++this.index;
                internalPos += this.length;
            }
            while (this.index <= newIndex) {
                if ((this.buf[1 + (this.index + 2) / 8] & 1 << (this.index + 2) % 8) == 0) {
                    int type;
                    if (this.index != newIndex) {
                        block0 : switch (this.columnInformation[this.index].getColumnType()) {
                            case BIGINT: 
                            case DOUBLE: {
                                internalPos += 8;
                                break;
                            }
                            case INTEGER: 
                            case MEDIUMINT: 
                            case FLOAT: {
                                internalPos += 4;
                                break;
                            }
                            case SMALLINT: 
                            case YEAR: {
                                internalPos += 2;
                                break;
                            }
                            case TINYINT: {
                                ++internalPos;
                                break;
                            }
                            default: {
                                type = this.buf[internalPos++] & 0xFF;
                                switch (type) {
                                    case 251: {
                                        break block0;
                                    }
                                    case 252: {
                                        internalPos += 2 + (0xFFFF & (this.buf[internalPos] & 0xFF) + ((this.buf[internalPos + 1] & 0xFF) << 8));
                                        break block0;
                                    }
                                    case 253: {
                                        internalPos += 3 + (0xFFFFFF & (this.buf[internalPos] & 0xFF) + ((this.buf[internalPos + 1] & 0xFF) << 8) + ((this.buf[internalPos + 2] & 0xFF) << 16));
                                        break block0;
                                    }
                                    case 254: {
                                        internalPos = (int)((long)internalPos + (8L + ((long)(this.buf[internalPos] & 0xFF) + ((long)(this.buf[internalPos + 1] & 0xFF) << 8) + ((long)(this.buf[internalPos + 2] & 0xFF) << 16) + ((long)(this.buf[internalPos + 3] & 0xFF) << 24) + ((long)(this.buf[internalPos + 4] & 0xFF) << 32) + ((long)(this.buf[internalPos + 5] & 0xFF) << 40) + ((long)(this.buf[internalPos + 6] & 0xFF) << 48) + ((long)(this.buf[internalPos + 7] & 0xFF) << 56))));
                                        break block0;
                                    }
                                }
                                internalPos += type;
                                break;
                            }
                        }
                    } else {
                        switch (this.columnInformation[this.index].getColumnType()) {
                            case BIGINT: 
                            case DOUBLE: {
                                this.pos = internalPos;
                                this.length = 8;
                                return false;
                            }
                            case INTEGER: 
                            case MEDIUMINT: 
                            case FLOAT: {
                                this.pos = internalPos;
                                this.length = 4;
                                return false;
                            }
                            case SMALLINT: 
                            case YEAR: {
                                this.pos = internalPos;
                                this.length = 2;
                                return false;
                            }
                            case TINYINT: {
                                this.pos = internalPos;
                                this.length = 1;
                                return false;
                            }
                        }
                        type = this.buf[internalPos++] & 0xFF;
                        switch (type) {
                            case 251: {
                                throw new IllegalStateException("null data is encoded in binary protocol but NULL-Bitmap is not set");
                            }
                            case 252: {
                                this.length = 0xFFFF & (this.buf[internalPos++] & 0xFF) + ((this.buf[internalPos++] & 0xFF) << 8);
                                this.pos = internalPos;
                                return false;
                            }
                            case 253: {
                                this.length = 0xFFFFFF & (this.buf[internalPos++] & 0xFF) + ((this.buf[internalPos++] & 0xFF) << 8) + ((this.buf[internalPos++] & 0xFF) << 16);
                                this.pos = internalPos;
                                return false;
                            }
                            case 254: {
                                this.length = (int)((long)(this.buf[internalPos++] & 0xFF) + ((long)(this.buf[internalPos++] & 0xFF) << 8) + ((long)(this.buf[internalPos++] & 0xFF) << 16) + ((long)(this.buf[internalPos++] & 0xFF) << 24) + ((long)(this.buf[internalPos++] & 0xFF) << 32) + ((long)(this.buf[internalPos++] & 0xFF) << 40) + ((long)(this.buf[internalPos++] & 0xFF) << 48) + ((long)(this.buf[internalPos++] & 0xFF) << 56));
                                this.pos = internalPos;
                                return false;
                            }
                        }
                        this.length = type;
                        this.pos = internalPos;
                        return false;
                    }
                }
                ++this.index;
            }
        }
        return this.length == -1;
    }
}

