/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.io.output;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.mariadb.jdbc.internal.io.TraceObject;
import org.mariadb.jdbc.internal.io.output.AbstractPacketOutputStream;
import org.mariadb.jdbc.internal.util.Utils;

public class StandardPacketOutputStream
extends AbstractPacketOutputStream {
    private static final int MAX_PACKET_LENGTH = 0x1000003;
    private int maxPacketLength = 0x1000003;

    public StandardPacketOutputStream(OutputStream out, int maxQuerySizeToLog) {
        super(out, maxQuerySizeToLog);
    }

    @Override
    public int getMaxPacketLength() {
        return this.maxPacketLength;
    }

    @Override
    public void startPacket(int seqNo) {
        this.seqNo = seqNo;
        this.pos = 4;
        this.cmdLength = 0L;
    }

    @Override
    public void setMaxAllowedPacket(int maxAllowedPacket) {
        this.maxAllowedPacket = maxAllowedPacket;
        this.maxPacketLength = Math.min(0x1000003, maxAllowedPacket + 4);
    }

    @Override
    protected void flushBuffer(boolean commandEnd) throws IOException {
        if (this.pos > 4) {
            this.buf[0] = (byte)(this.pos - 4 >>> 0);
            this.buf[1] = (byte)(this.pos - 4 >>> 8);
            this.buf[2] = (byte)(this.pos - 4 >>> 16);
            this.buf[3] = (byte)this.seqNo++;
            this.checkMaxAllowedLength(this.pos - 4);
            this.out.write(this.buf, 0, this.pos);
            if (this.traceCache != null && this.permitTrace) {
                this.traceCache.put(System.currentTimeMillis(), new TraceObject(true, 0, new byte[][]{Arrays.copyOfRange(this.buf, 0, this.pos > 1000 ? 1000 : this.pos)}));
            }
            if (logger.isTraceEnabled()) {
                if (this.permitTrace) {
                    logger.trace("send:" + this.serverThreadLog + Utils.hexdump(this.maxQuerySizeToLog, 0, this.pos, (byte[][])new byte[][]{this.buf}));
                } else {
                    logger.trace("send: content length:" + (this.pos - 4) + this.serverThreadLog + " com:<hidden>");
                }
            }
            if (commandEnd && this.pos == 0x1000003) {
                this.writeEmptyPacket();
            }
            this.pos = 4;
        }
    }

    @Override
    public void writeEmptyPacket() throws IOException {
        this.buf[0] = 0;
        this.buf[1] = 0;
        this.buf[2] = 0;
        this.buf[3] = (byte)this.seqNo++;
        this.out.write(this.buf, 0, 4);
        if (this.traceCache != null) {
            this.traceCache.put(System.currentTimeMillis(), new TraceObject(true, 0, new byte[][]{Arrays.copyOfRange(this.buf, 0, 4)}));
        }
        if (logger.isTraceEnabled()) {
            logger.trace("send com : content length:0 " + this.serverThreadLog + Utils.hexdump(this.maxQuerySizeToLog, 0, 4, (byte[][])new byte[][]{this.buf}));
        }
    }
}

