/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.io.output;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.DeflaterOutputStream;
import org.mariadb.jdbc.internal.io.output.AbstractPacketOutputStream;
import org.mariadb.jdbc.internal.util.Utils;

public class CompressPacketOutputStream
extends AbstractPacketOutputStream {
    private static final int MAX_PACKET_LENGTH = 0xFFFFFF;
    private static final byte[] EMPTY_ARRAY = new byte[0];
    private int maxPacketLength = 0xFFFFFF;
    private static final int MIN_COMPRESSION_SIZE = 100;
    private static final float MIN_COMPRESSION_RATIO = 0.9f;
    private int compressSeqNo;
    private byte[] header = new byte[7];
    private byte[] subHeader = new byte[4];
    private byte[] remainingData = new byte[0];
    private boolean lastPacketExactMaxPacketLength = false;

    public CompressPacketOutputStream(OutputStream out, int maxQuerySizeToLog) {
        super(out, maxQuerySizeToLog);
    }

    @Override
    public int getMaxPacketLength() {
        return this.maxPacketLength;
    }

    @Override
    public void setMaxAllowedPacket(int maxAllowedPacket) {
        this.maxAllowedPacket = maxAllowedPacket;
        this.maxPacketLength = Math.min(0xFFFFFF, maxAllowedPacket + 7);
    }

    @Override
    public void startPacket(int compressSeqNo) {
        this.compressSeqNo = compressSeqNo;
        this.seqNo = 0;
        this.pos = 0;
        this.cmdLength = 0L;
        this.remainingData = EMPTY_ARRAY;
        this.lastPacketExactMaxPacketLength = false;
    }

    @Override
    protected void flushBuffer(boolean commandEnd) throws IOException {
        Throwable throwable;
        DeflaterOutputStream deflater;
        Throwable throwable2;
        ByteArrayOutputStream baos;
        int uncompressSize;
        if (this.pos > 0) {
            if (this.pos + this.remainingData.length > 100) {
                byte[] compressedBytes;
                uncompressSize = Math.min(0xFFFFFF, this.remainingData.length + 4 + this.pos);
                this.checkMaxAllowedLength(uncompressSize);
                baos = new ByteArrayOutputStream();
                throwable2 = null;
                try {
                    deflater = new DeflaterOutputStream(baos);
                    throwable = null;
                    try {
                        if (this.remainingData.length != 0) {
                            deflater.write(this.remainingData);
                        }
                        this.subHeader[0] = (byte)(this.pos >>> 0);
                        this.subHeader[1] = (byte)(this.pos >>> 8);
                        this.subHeader[2] = (byte)(this.pos >>> 16);
                        this.subHeader[3] = (byte)this.seqNo++;
                        deflater.write(this.subHeader, 0, 4);
                        deflater.write(this.buf, 0, uncompressSize - (this.remainingData.length + 4));
                        deflater.finish();
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (deflater != null) {
                            if (throwable != null) {
                                try {
                                    deflater.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                            } else {
                                deflater.close();
                            }
                        }
                    }
                    compressedBytes = baos.toByteArray();
                    this.remainingData = this.pos + this.remainingData.length + 4 - uncompressSize > 0 ? Arrays.copyOfRange(this.buf, uncompressSize - (this.remainingData.length + 4), this.pos) : EMPTY_ARRAY;
                }
                catch (Throwable deflater2) {
                    throwable2 = deflater2;
                    throw deflater2;
                }
                finally {
                    if (baos != null) {
                        if (throwable2 != null) {
                            try {
                                baos.close();
                            }
                            catch (Throwable deflater2) {
                                throwable2.addSuppressed(deflater2);
                            }
                        } else {
                            baos.close();
                        }
                    }
                }
                if (compressedBytes.length < (int)(0.9f * (float)this.pos)) {
                    int compressedLength = compressedBytes.length;
                    this.header[0] = (byte)(compressedLength >>> 0);
                    this.header[1] = (byte)(compressedLength >>> 8);
                    this.header[2] = (byte)(compressedLength >>> 16);
                    this.header[3] = (byte)this.compressSeqNo++;
                    this.header[4] = (byte)(uncompressSize >>> 0);
                    this.header[5] = (byte)(uncompressSize >>> 8);
                    this.header[6] = (byte)(uncompressSize >>> 16);
                    this.out.write(this.header, 0, 7);
                    this.out.write(compressedBytes, 0, compressedLength);
                    if (logger.isTraceEnabled()) {
                        if (this.permitTrace) {
                            logger.trace("send compress: length:(zlib:" + compressedLength + ",std:" + uncompressSize + ")" + this.serverThreadLog + " packet:0x" + Utils.hexdump(this.header, this.maxQuerySizeToLog, 0, 7) + Utils.hexdump(compressedBytes, this.maxQuerySizeToLog - 7, 0, compressedLength));
                        } else {
                            logger.trace("send compress: length:(zlib:" + compressedLength + ",std:" + uncompressSize + ")" + this.serverThreadLog + " packet:<hidden>");
                        }
                    }
                    boolean bl = this.lastPacketExactMaxPacketLength = this.pos == 0xFFFFFF;
                    if (commandEnd && this.lastPacketExactMaxPacketLength) {
                        this.writeEmptyPacket();
                    }
                    this.pos = 0;
                    return;
                }
            }
            int uncompressSize2 = Math.min(0xFFFFFF, this.remainingData.length + 4 + this.pos);
            this.checkMaxAllowedLength(uncompressSize2);
            this.header[0] = (byte)(uncompressSize2 >>> 0);
            this.header[1] = (byte)(uncompressSize2 >>> 8);
            this.header[2] = (byte)(uncompressSize2 >>> 16);
            this.header[3] = (byte)this.compressSeqNo++;
            this.header[4] = 0;
            this.header[5] = 0;
            this.header[6] = 0;
            this.out.write(this.header, 0, 7);
            if (this.remainingData.length != 0) {
                this.out.write(this.remainingData);
            }
            this.subHeader[0] = (byte)(this.pos >>> 0);
            this.subHeader[1] = (byte)(this.pos >>> 8);
            this.subHeader[2] = (byte)(this.pos >>> 16);
            this.subHeader[3] = (byte)this.seqNo++;
            this.out.write(this.subHeader, 0, 4);
            this.out.write(this.buf, 0, uncompressSize2 - (this.remainingData.length + 4));
            this.remainingData = this.pos + this.remainingData.length + 4 - uncompressSize2 > 0 ? Arrays.copyOfRange(this.buf, uncompressSize2 - (this.remainingData.length + 4), this.pos) : EMPTY_ARRAY;
            if (logger.isTraceEnabled()) {
                if (this.permitTrace) {
                    logger.trace("send compress: length:(zlib:0,std:" + uncompressSize2 + ")" + this.serverThreadLog + " packet:0x" + Utils.hexdump(this.header, this.maxQuerySizeToLog, 0, this.pos) + Utils.hexdump(this.remainingData, this.maxQuerySizeToLog - this.pos, 0, this.remainingData.length) + Utils.hexdump(this.subHeader, this.maxQuerySizeToLog - (this.pos + this.remainingData.length), 0, 4) + Utils.hexdump(this.buf, this.maxQuerySizeToLog - (this.pos + this.remainingData.length + 4), 0, this.pos));
                } else {
                    logger.trace("send compress: length:(zlib:0,std:" + uncompressSize2 + ")" + this.serverThreadLog + " packet:<hidden>");
                }
            }
            this.lastPacketExactMaxPacketLength = this.pos == 0xFFFFFF;
            this.pos = 0;
        }
        if (this.remainingData.length > 0) {
            if (this.remainingData.length > 100) {
                byte[] compressedBytes;
                uncompressSize = Math.min(0xFFFFFF, this.remainingData.length);
                this.checkMaxAllowedLength(uncompressSize);
                baos = new ByteArrayOutputStream();
                throwable2 = null;
                try {
                    deflater = new DeflaterOutputStream(baos);
                    throwable = null;
                    try {
                        deflater.write(this.remainingData);
                        deflater.finish();
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (deflater != null) {
                            if (throwable != null) {
                                try {
                                    deflater.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                            } else {
                                deflater.close();
                            }
                        }
                    }
                    compressedBytes = baos.toByteArray();
                    this.remainingData = EMPTY_ARRAY;
                }
                catch (Throwable throwable7) {
                    throwable2 = throwable7;
                    throw throwable7;
                }
                finally {
                    if (baos != null) {
                        if (throwable2 != null) {
                            try {
                                baos.close();
                            }
                            catch (Throwable throwable8) {
                                throwable2.addSuppressed(throwable8);
                            }
                        } else {
                            baos.close();
                        }
                    }
                }
                if (compressedBytes.length < (int)(0.9f * (float)this.pos)) {
                    int compressedLength = compressedBytes.length;
                    this.header[0] = (byte)(compressedLength >>> 0);
                    this.header[1] = (byte)(compressedLength >>> 8);
                    this.header[2] = (byte)(compressedLength >>> 16);
                    this.header[3] = (byte)this.compressSeqNo++;
                    this.header[4] = (byte)(uncompressSize >>> 0);
                    this.header[5] = (byte)(uncompressSize >>> 8);
                    this.header[6] = (byte)(uncompressSize >>> 16);
                    this.out.write(this.header, 0, 7);
                    this.out.write(compressedBytes, 0, compressedLength);
                    if (logger.isTraceEnabled()) {
                        if (this.permitTrace) {
                            logger.trace("send compress: length:(zlib:" + compressedLength + ",std:" + uncompressSize + ")" + this.serverThreadLog + " packet:0x" + Utils.hexdump(this.header, this.maxQuerySizeToLog, 0, 7) + Utils.hexdump(compressedBytes, this.maxQuerySizeToLog - 7, 0, compressedLength));
                        } else {
                            logger.trace("send compress: length:(zlib:" + compressedLength + ",std:" + uncompressSize + ")" + this.serverThreadLog + " packet:<hidden>");
                        }
                    }
                    if (commandEnd && this.lastPacketExactMaxPacketLength) {
                        this.writeEmptyPacket();
                    }
                    return;
                }
            }
            int uncompressSize3 = Math.min(0xFFFFFF, this.remainingData.length);
            this.checkMaxAllowedLength(uncompressSize3);
            this.header[0] = (byte)(uncompressSize3 >>> 0);
            this.header[1] = (byte)(uncompressSize3 >>> 8);
            this.header[2] = (byte)(uncompressSize3 >>> 16);
            this.header[3] = (byte)this.compressSeqNo++;
            this.header[4] = 0;
            this.header[5] = 0;
            this.header[6] = 0;
            this.out.write(this.header, 0, 7);
            this.out.write(this.remainingData);
            this.remainingData = EMPTY_ARRAY;
            if (logger.isTraceEnabled()) {
                if (this.permitTrace) {
                    logger.trace("send compress: length:(zlib:0,std:" + uncompressSize3 + ")" + this.serverThreadLog + " packet:0x" + Utils.hexdump(this.header, this.maxQuerySizeToLog, 0, this.pos) + Utils.hexdump(this.remainingData, this.maxQuerySizeToLog - this.pos, 0, this.remainingData.length));
                } else {
                    logger.trace("send compress: length:(zlib:0,std:" + uncompressSize3 + ")" + this.serverThreadLog + " packet:<hidden>");
                }
            }
            if (commandEnd && this.lastPacketExactMaxPacketLength) {
                this.writeEmptyPacket();
            }
        }
    }

    @Override
    public void writeEmptyPacket() throws IOException {
        this.buf[0] = 4;
        this.buf[1] = 0;
        this.buf[2] = 0;
        this.buf[3] = (byte)this.compressSeqNo++;
        this.buf[4] = 0;
        this.buf[5] = 0;
        this.buf[6] = 0;
        this.buf[7] = 0;
        this.buf[8] = 0;
        this.buf[9] = 0;
        this.buf[10] = (byte)this.seqNo++;
        this.out.write(this.buf, 0, 11);
        if (logger.isTraceEnabled()) {
            if (this.permitTrace) {
                logger.trace("send compress: length:(zlib:0,std:0)" + this.serverThreadLog + " packet:0x" + Utils.hexdump(this.buf, this.maxQuerySizeToLog, 0, 11));
            } else {
                logger.trace("send compress: length:(zlib:0,std:0)" + this.serverThreadLog + " packet:<hidden>");
            }
        }
    }
}

