/*
 *
 * MariaDB Client for Java
 *
 * Copyright (c) 2012-2014 Monty Program Ab.
 * Copyright (c) 2015-2017 MariaDB Ab.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along
 * with this library; if not, write to Monty Program Ab info@montyprogram.com.
 *
 * This particular MariaDB Client for Java file is work
 * derived from a Drizzle-JDBC. Drizzle-JDBC file which is covered by subject to
 * the following copyright and notice provisions:
 *
 * Copyright (c) 2009-2011, Marcus Eriksson
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * Redistributions of source code must retain the above copyright notice, this list
 * of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice, this
 * list of conditions and the following disclaimer in the documentation and/or
 * other materials provided with the distribution.
 *
 * Neither the name of the driver nor the names of its contributors may not be
 * used to endorse or promote products derived from this software without specific
 * prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS  AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 */

package org.mariadb.jdbc.internal.logging;

public class Slf4JLogger implements Logger {
  private final org.slf4j.Logger logger;

  public Slf4JLogger(org.slf4j.Logger logger) {
    this.logger = logger;
  }

  public boolean isTraceEnabled() {
    return logger.isTraceEnabled();
  }

  public void trace(String msg) {
    logger.trace(msg);
  }

  public void trace(String format, Object arg) {
    logger.trace(format, arg);
  }

  public void trace(String format, Object arg1, Object arg2) {
    logger.trace(format, arg1, arg2);
  }

  public void trace(String format, Object... arguments) {
    logger.trace(format, arguments);
  }

  public void trace(String msg, Throwable throwable) {
    logger.trace(msg, throwable);
  }

  public boolean isDebugEnabled() {
    return logger.isDebugEnabled();
  }

  public void debug(String msg) {
    logger.debug(msg);
  }

  public void debug(String format, Object arg) {
    logger.debug(format, arg);
  }

  public void debug(String format, Object arg1, Object arg2) {
    logger.debug(format, arg1, arg2);
  }

  public void debug(String format, Object... arguments) {
    logger.debug(format, arguments);
  }

  public void debug(String msg, Throwable throwable) {
    logger.debug(msg, throwable);
  }

  public boolean isInfoEnabled() {
    return logger.isInfoEnabled();
  }

  public void info(String msg) {
    logger.info(msg);
  }

  public void info(String format, Object arg) {
    logger.info(format, arg);
  }

  public void info(String format, Object arg1, Object arg2) {
    logger.info(format, arg1, arg2);
  }

  public void info(String format, Object... arguments) {
    logger.info(format, arguments);
  }

  public void info(String msg, Throwable throwable) {
    logger.info(msg, throwable);
  }

  public boolean isWarnEnabled() {
    return logger.isWarnEnabled();
  }

  public void warn(String msg) {
    logger.warn(msg);
  }

  public void warn(String format, Object arg) {
    logger.warn(format, arg);
  }

  public void warn(String format, Object... arguments) {
    logger.warn(format, arguments);
  }

  public void warn(String format, Object arg1, Object arg2) {
    logger.warn(format, arg1, arg2);
  }

  public void warn(String msg, Throwable throwable) {
    logger.warn(msg, throwable);
  }

  public boolean isErrorEnabled() {
    return logger.isErrorEnabled();
  }

  public void error(String msg) {
    logger.error(msg);
  }

  public void error(String format, Object arg) {
    logger.error(format, arg);
  }

  public void error(String format, Object arg1, Object arg2) {
    logger.error(format, arg1, arg2);
  }

  public void error(String format, Object... arguments) {
    logger.error(format, arguments);
  }

  public void error(String msg, Throwable throwable) {
    logger.error(msg, throwable);
  }

}
