/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.protocol.authentication;

import java.sql.SQLException;
import org.mariadb.jdbc.internal.com.send.InterfaceAuthSwitchSendResponsePacket;
import org.mariadb.jdbc.internal.com.send.SendClearPasswordAuthPacket;
import org.mariadb.jdbc.internal.com.send.SendGssApiAuthPacket;
import org.mariadb.jdbc.internal.com.send.SendNativePasswordAuthPacket;
import org.mariadb.jdbc.internal.com.send.SendOldPasswordAuthPacket;
import org.mariadb.jdbc.internal.com.send.SendPamAuthPacket;
import org.mariadb.jdbc.internal.io.input.PacketInputStream;

public class DefaultAuthenticationProvider {
    public static final String MYSQL_NATIVE_PASSWORD = "mysql_native_password";
    public static final String MYSQL_OLD_PASSWORD = "mysql_old_password";
    public static final String MYSQL_CLEAR_PASSWORD = "mysql_clear_password";
    private static final String GSSAPI_CLIENT = "auth_gssapi_client";
    private static final String DIALOG = "dialog";

    public static InterfaceAuthSwitchSendResponsePacket processAuthPlugin(PacketInputStream reader, String plugin, String password, byte[] authData, int seqNo, String passwordCharacterEncoding) throws SQLException {
        if (MYSQL_NATIVE_PASSWORD.equals(plugin)) {
            return new SendNativePasswordAuthPacket(password, authData, seqNo, passwordCharacterEncoding);
        }
        if (MYSQL_OLD_PASSWORD.equals(plugin)) {
            return new SendOldPasswordAuthPacket(password, authData, seqNo, passwordCharacterEncoding);
        }
        if (MYSQL_CLEAR_PASSWORD.equals(plugin)) {
            return new SendClearPasswordAuthPacket(password, authData, seqNo, passwordCharacterEncoding);
        }
        if (DIALOG.equals(plugin)) {
            return new SendPamAuthPacket(reader, password, authData, seqNo, passwordCharacterEncoding);
        }
        if (GSSAPI_CLIENT.equals(plugin)) {
            return new SendGssApiAuthPacket(reader, password, authData, seqNo, passwordCharacterEncoding);
        }
        throw new SQLException("Client does not support authentication protocol requested by server. Consider upgrading MariaDB client. plugin was = " + plugin, "08004", 1251);
    }
}

