/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.com.read;

import org.mariadb.jdbc.internal.com.read.Buffer;

public class ErrorPacket {
    private final short errorNumber;
    private final byte sqlStateMarker;
    private final byte[] sqlState;
    private final String message;

    public ErrorPacket(Buffer buffer) {
        buffer.skipByte();
        this.errorNumber = buffer.readShort();
        this.sqlStateMarker = buffer.readByte();
        if (this.sqlStateMarker == 35) {
            this.sqlState = buffer.readRawBytes(5);
            this.message = buffer.readStringNullEnd(Buffer.UTF_8);
        } else {
            --buffer.position;
            this.message = new String(buffer.buf, buffer.position, buffer.limit - buffer.position, Buffer.UTF_8);
            this.sqlState = "HY000".getBytes();
        }
    }

    public String getMessage() {
        return this.message;
    }

    public short getErrorNumber() {
        return this.errorNumber;
    }

    public String getSqlState() {
        return new String(this.sqlState);
    }

    public byte getSqlStateMarker() {
        return this.sqlStateMarker;
    }
}

