/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.dao.parameters;

import java.math.BigDecimal;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.packet.dao.parameters.NotLongDataParameter;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;

public class BigDecimalParameter
extends NotLongDataParameter
implements Cloneable {
    private BigDecimal bigDecimal;

    public BigDecimalParameter(BigDecimal bigDecimal) {
        this.bigDecimal = bigDecimal;
    }

    @Override
    public void writeTo(PacketOutputStream os) {
        os.write(this.bigDecimal.toPlainString().getBytes());
    }

    @Override
    public void writeUnsafeTo(PacketOutputStream os) {
        os.writeUnsafe(this.bigDecimal.toPlainString().getBytes());
    }

    @Override
    public long getApproximateTextProtocolLength() {
        return this.bigDecimal.toPlainString().getBytes().length;
    }

    @Override
    public void writeBinary(PacketOutputStream writeBuffer) {
        writeBuffer.writeStringLength(this.bigDecimal.toPlainString());
    }

    @Override
    public MariaDbType getMariaDbType() {
        return MariaDbType.DECIMAL;
    }

    @Override
    public String toString() {
        return this.bigDecimal.toString();
    }
}

