/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.send;

import java.awt.HeadlessException;
import java.io.Console;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.mariadb.jdbc.internal.packet.read.ReadPacketFetcher;
import org.mariadb.jdbc.internal.packet.result.ErrorPacket;
import org.mariadb.jdbc.internal.packet.send.AbstractAuthSwitchSendResponsePacket;
import org.mariadb.jdbc.internal.packet.send.InterfaceAuthSwitchSendResponsePacket;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;
import org.mariadb.jdbc.internal.util.buffer.Buffer;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class SendPamAuthPacket
extends AbstractAuthSwitchSendResponsePacket
implements InterfaceAuthSwitchSendResponsePacket {
    private ReadPacketFetcher packetFetcher;

    public SendPamAuthPacket(ReadPacketFetcher packetFetcher, String password, byte[] authData, int packSeq) {
        super(packSeq, authData, password);
        this.packetFetcher = packetFetcher;
    }

    @Override
    public void send(OutputStream os) throws IOException, QueryException {
        PacketOutputStream writer = (PacketOutputStream)os;
        byte type = this.authData[0];
        while (true) {
            String promptb;
            if ("Password: ".equals(promptb = new String(Arrays.copyOfRange(this.authData, 1, this.authData.length))) && this.password != null && !"".equals(this.password)) {
                writer.startPacket(this.packSeq);
                writer.write(this.password.getBytes());
                writer.write(0);
            } else {
                boolean isPassword = type == 4;
                String password = this.showInputDialog(promptb, isPassword);
                if (password == null) {
                    throw new QueryException("Error during PAM authentication : dialog input cancelled");
                }
                writer.startPacket(this.packSeq);
                writer.write(password.getBytes());
                writer.write(0);
            }
            writer.finishPacketWithoutRelease(false);
            writer.releaseBuffer();
            try {
                Buffer buffer = this.packetFetcher.getReusableBuffer();
                this.packSeq = this.packetFetcher.getLastPacketSeq() + 1;
                type = buffer.getByteAt(0);
                if (type == -2 || type == 0) {
                    return;
                }
                if (type == -1) {
                    ErrorPacket errorPacket = new ErrorPacket(buffer);
                    throw new QueryException("Error during PAM authentication : " + errorPacket.getMessage());
                }
                this.authData = buffer.readRawBytes(buffer.remaining());
            }
            catch (EOFException eof) {
                throw new QueryException("Error during PAM authentication reading server response : " + eof.getMessage() + "\n It may be due to a low @@connect_timeout.");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String showInputDialog(String label, boolean isPassword) throws IOException {
        String password;
        try {
            if (isPassword) {
                JPasswordField pwd = new JPasswordField();
                pwd.addAncestorListener(new RequestFocusListener());
                int action = JOptionPane.showConfirmDialog(null, pwd, label, 2);
                if (action != 0) throw new IOException("Error during PAM authentication : dialog input cancelled");
                password = new String(pwd.getPassword());
            } else {
                password = JOptionPane.showInputDialog(label);
            }
        }
        catch (HeadlessException noGraphicalEnvironment) {
            Console console = System.console();
            if (console == null) {
                throw new IOException("Error during PAM authentication : input by console not possible");
            }
            if (isPassword) {
                char[] passwordChar = console.readPassword(label, new Object[0]);
                password = new String(passwordChar);
            }
            password = console.readLine(label, new Object[0]);
        }
        if (password == null) throw new IOException("Error during PAM authentication : dialog input cancelled");
        return password;
    }

    @Override
    public void handleResultPacket(ReadPacketFetcher packetFetcher) throws QueryException, IOException {
    }

    public class RequestFocusListener
    implements AncestorListener {
        private boolean removeListener;

        public RequestFocusListener() {
            this(true);
        }

        public RequestFocusListener(boolean removeListener) {
            this.removeListener = removeListener;
        }

        @Override
        public void ancestorAdded(AncestorEvent ancestorEvent) {
            JComponent component = ancestorEvent.getComponent();
            component.requestFocusInWindow();
            if (this.removeListener) {
                component.removeAncestorListener(this);
            }
        }

        @Override
        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent ancestorEvent) {
        }
    }
}

