/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.protocol;

import java.util.List;
import java.util.concurrent.Callable;
import org.mariadb.jdbc.internal.packet.ComStmtPrepare;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.protocol.AbstractMultiSend;
import org.mariadb.jdbc.internal.protocol.AsyncMultiReadResult;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.queryresults.Results;
import org.mariadb.jdbc.internal.util.dao.PrepareResult;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class AsyncMultiRead
implements Callable<AsyncMultiReadResult> {
    private final ComStmtPrepare comStmtPrepare;
    private final int nbResult;
    private final int sendCmdCounter;
    private final Protocol protocol;
    private final boolean readPrepareStmtResult;
    private Results results;
    private boolean binaryProtocol;
    private final AbstractMultiSend bulkSend;
    private int paramCount;
    private final List<ParameterHolder[]> parametersList;
    private final List<String> queries;
    private AsyncMultiReadResult asyncMultiReadResult;

    public AsyncMultiRead(ComStmtPrepare comStmtPrepare, int nbResult, int sendCmdCounter, Protocol protocol, boolean readPrepareStmtResult, AbstractMultiSend bulkSend, int paramCount, boolean binaryProtocol, Results results, List<ParameterHolder[]> parametersList, List<String> queries, PrepareResult prepareResult) {
        this.comStmtPrepare = comStmtPrepare;
        this.nbResult = nbResult;
        this.sendCmdCounter = sendCmdCounter;
        this.protocol = protocol;
        this.readPrepareStmtResult = readPrepareStmtResult;
        this.bulkSend = bulkSend;
        this.paramCount = paramCount;
        this.binaryProtocol = binaryProtocol;
        this.results = results;
        this.parametersList = parametersList;
        this.queries = queries;
        this.asyncMultiReadResult = new AsyncMultiReadResult(prepareResult);
    }

    @Override
    public AsyncMultiReadResult call() throws Exception {
        if (this.protocol.getOptions().socketTimeout != null) {
            this.protocol.changeSocketSoTimeout(0);
        }
        if (this.readPrepareStmtResult) {
            try {
                this.asyncMultiReadResult.setPrepareResult(this.comStmtPrepare.read(this.protocol.getPacketFetcher()));
            }
            catch (QueryException queryException) {
                this.asyncMultiReadResult.setException(queryException);
            }
        }
        for (int counter = 0; counter < this.nbResult; ++counter) {
            try {
                this.protocol.getResult(this.results);
                continue;
            }
            catch (QueryException qex) {
                if (this.asyncMultiReadResult.getException() != null) continue;
                this.asyncMultiReadResult.setException(this.bulkSend.handleResultException(qex, this.results, this.parametersList, this.queries, counter, this.sendCmdCounter, this.paramCount, this.asyncMultiReadResult.getPrepareResult()));
            }
        }
        if (this.protocol.getOptions().socketTimeout != null) {
            this.protocol.changeSocketSoTimeout(this.protocol.getOptions().socketTimeout);
        }
        return this.asyncMultiReadResult;
    }
}

