/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.dao.parameters;

import java.io.IOException;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterWriter;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;

public class TimeParameter
implements ParameterHolder,
Cloneable {
    private Time time;
    private Calendar calendar;
    private boolean fractionalSeconds;

    public TimeParameter(Time time, Calendar cal, boolean fractionalSeconds) {
        this.time = time;
        this.calendar = cal;
        this.fractionalSeconds = fractionalSeconds;
    }

    @Override
    public void writeTo(PacketOutputStream os) {
        os.write(39);
        os.write(this.dateToBytes());
        ParameterWriter.formatMicroseconds(os, (int)(this.time.getTime() % 1000L) * 1000, this.fractionalSeconds);
        os.write(39);
    }

    @Override
    public void writeUnsafeTo(PacketOutputStream os) {
        os.writeUnsafe(39);
        os.writeUnsafe(this.dateToBytes());
        ParameterWriter.formatMicrosecondsUnsafe(os, (int)(this.time.getTime() % 1000L) * 1000, this.fractionalSeconds);
        os.writeUnsafe(39);
    }

    private byte[] dateToBytes() {
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        sdf.setCalendar(Calendar.getInstance());
        String dateString = sdf.format(this.time);
        if (this.time.getTime() < 0L) {
            dateString = "-" + dateString;
        }
        return dateString.getBytes();
    }

    @Override
    public long getApproximateTextProtocolLength() throws IOException {
        return 15L;
    }

    @Override
    public void writeBinary(PacketOutputStream writeBuffer) {
        this.calendar = Calendar.getInstance();
        this.calendar.setTime(this.time);
        this.calendar.set(5, 1);
        writeBuffer.writeTimeLength(this.calendar, this.fractionalSeconds);
    }

    @Override
    public MariaDbType getMariaDbType() {
        return MariaDbType.TIME;
    }

    @Override
    public String toString() {
        return this.time.toString();
    }

    @Override
    public boolean isLongData() {
        return false;
    }

    @Override
    public boolean isNullData() {
        return false;
    }
}

