/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.dao.parameters;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterWriter;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;

public class StreamParameter
implements ParameterHolder {
    private InputStream is;
    private long length;
    private boolean noBackslashEscapes;

    public StreamParameter(InputStream is, long length, boolean noBackslashEscapes) {
        this.is = is;
        this.length = length;
        this.noBackslashEscapes = noBackslashEscapes;
        if (is.markSupported()) {
            is.mark(1024);
        }
    }

    public StreamParameter(InputStream is, boolean noBackSlashEscapes) {
        this(is, Long.MAX_VALUE, noBackSlashEscapes);
    }

    @Override
    public void writeTo(PacketOutputStream os) throws IOException {
        if (this.length == Long.MAX_VALUE) {
            ParameterWriter.write((OutputStream)os, this.is, this.noBackslashEscapes);
        } else {
            ParameterWriter.write((OutputStream)os, this.is, this.length, this.noBackslashEscapes);
        }
    }

    @Override
    public void writeUnsafeTo(PacketOutputStream os) throws IOException {
        throw new IOException("Cannot use unsafe with Stream");
    }

    @Override
    public long getApproximateTextProtocolLength() throws IOException {
        return -1L;
    }

    @Override
    public void writeBinary(PacketOutputStream os) throws IOException {
        if (this.length == Long.MAX_VALUE) {
            os.sendStream(this.is);
        } else {
            os.sendStream(this.is, this.length);
        }
    }

    @Override
    public String toString() {
        try {
            if (this.is.markSupported()) {
                this.is.reset();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                if (this.length == Long.MAX_VALUE) {
                    ParameterWriter.write((OutputStream)baos, this.is, this.noBackslashEscapes);
                } else {
                    ParameterWriter.write((OutputStream)baos, this.is, this.length, this.noBackslashEscapes);
                }
                byte[] bytes = baos.toByteArray();
                if (bytes.length < 1024) {
                    return "<Stream:" + new String(bytes, StandardCharsets.UTF_8) + ">";
                }
                return "<Stream:" + new String(bytes, 0, 1024, StandardCharsets.UTF_8) + "...>";
            }
            return "<Stream>";
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public MariaDbType getMariaDbType() {
        return MariaDbType.BLOB;
    }

    @Override
    public boolean isLongData() {
        return true;
    }

    @Override
    public boolean isNullData() {
        return false;
    }
}

