/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.send;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import org.mariadb.jdbc.internal.packet.read.ReadPacketFetcher;
import org.mariadb.jdbc.internal.packet.result.ErrorPacket;
import org.mariadb.jdbc.internal.packet.send.AbstractAuthSwitchSendResponsePacket;
import org.mariadb.jdbc.internal.packet.send.InterfaceAuthSwitchSendResponsePacket;
import org.mariadb.jdbc.internal.packet.send.gssapi.GssapiAuth;
import org.mariadb.jdbc.internal.packet.send.gssapi.StandardGssapiAuthentication;
import org.mariadb.jdbc.internal.packet.send.gssapi.WindowsNativeSspiAuthentication;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;
import org.mariadb.jdbc.internal.util.buffer.Buffer;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class SendGssApiAuthPacket
extends AbstractAuthSwitchSendResponsePacket
implements InterfaceAuthSwitchSendResponsePacket {
    private ReadPacketFetcher packetFetcher;

    public SendGssApiAuthPacket(ReadPacketFetcher packetFetcher, String password, byte[] authData, int packSeq) {
        super(packSeq, authData, password);
        this.packetFetcher = packetFetcher;
    }

    @Override
    public void send(OutputStream os) throws IOException, QueryException {
        Buffer buffer = new Buffer(this.authData);
        PacketOutputStream writer = (PacketOutputStream)os;
        String serverPrincipalName = buffer.readString(Charset.forName("UTF-8"));
        String mechanisms = buffer.readString(Charset.forName("UTF-8"));
        if (mechanisms.equals("")) {
            mechanisms = "Kerberos";
        }
        GssapiAuth gssapiAuth = this.getAuthenticationMethod();
        gssapiAuth.authenticate(writer, serverPrincipalName, mechanisms);
    }

    @Override
    public void handleResultPacket(ReadPacketFetcher packetFetcher) throws QueryException, IOException {
        try {
            Buffer buffer = packetFetcher.getReusableBuffer();
            if (buffer.getByteAt(0) == -1) {
                ErrorPacket ep = new ErrorPacket(buffer);
                String message = ep.getMessage();
                throw new QueryException("Could not connect: " + message, ep.getErrorNumber(), ep.getSqlState());
            }
        }
        catch (EOFException e) {
            throw new QueryException("Authentication exception", 1045, "28000", e);
        }
    }

    private GssapiAuth getAuthenticationMethod() {
        try {
            Class<?> platformClass = Class.forName("com.sun.jna.Platform");
            Method method = platformClass.getMethod("isWindows", new Class[0]);
            Boolean isWindows = (Boolean)method.invoke(platformClass, new Object[0]);
            if (isWindows.booleanValue()) {
                try {
                    Class.forName("waffle.windows.auth.impl.WindowsAuthProviderImpl");
                    return new WindowsNativeSspiAuthentication(this.packetFetcher, this.packSeq);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new StandardGssapiAuthentication(this.packetFetcher, this.packSeq);
    }
}

