/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet;

import java.io.IOException;
import java.util.List;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;
import org.mariadb.jdbc.internal.util.dao.ClientPrepareResult;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class ComExecute {
    public static void sendSubCmd(PacketOutputStream writer, ClientPrepareResult clientPrepareResult, ParameterHolder[] parameters) throws IOException {
        writer.buffer.put((byte)3);
        if (clientPrepareResult.isRewritableValuesQuery()) {
            writer.write(clientPrepareResult.getQueryParts().get(0));
            writer.write(clientPrepareResult.getQueryParts().get(1));
            for (int i = 0; i < clientPrepareResult.getParamCount(); ++i) {
                parameters[i].writeTo(writer);
                writer.write(clientPrepareResult.getQueryParts().get(i + 2));
            }
            writer.write(clientPrepareResult.getQueryParts().get(clientPrepareResult.getParamCount() + 2));
        } else {
            writer.write(clientPrepareResult.getQueryParts().get(0));
            for (int i = 0; i < clientPrepareResult.getParamCount(); ++i) {
                parameters[i].writeTo(writer);
                writer.write(clientPrepareResult.getQueryParts().get(i + 1));
            }
        }
    }

    public static int sendRewriteCmd(PacketOutputStream writer, List<byte[]> queryParts, ParameterHolder[] parameters, int currentIndex, int paramCount, List<ParameterHolder[]> parameterList, boolean rewriteValues) throws IOException {
        writer.startPacket(0);
        writer.buffer.put((byte)3);
        byte[] firstPart = queryParts.get(0);
        byte[] secondPart = queryParts.get(1);
        if (!rewriteValues) {
            int i;
            writer.write(firstPart, 0, firstPart.length);
            writer.write(secondPart, 0, secondPart.length);
            int staticLength = 1;
            for (i = 0; i < queryParts.size(); ++i) {
                staticLength += queryParts.get(i).length;
            }
            for (i = 0; i < paramCount; ++i) {
                parameters[i].writeTo(writer);
                writer.write(queryParts.get(i + 2));
            }
            writer.write(queryParts.get(paramCount + 2));
            while (currentIndex < parameterList.size()) {
                int i2;
                parameters = parameterList.get(currentIndex);
                int parameterLength = 0;
                boolean knownParameterSize = true;
                for (ParameterHolder parameter : parameters) {
                    long paramSize = parameter.getApproximateTextProtocolLength();
                    if (paramSize == -1L) {
                        knownParameterSize = false;
                        break;
                    }
                    parameterLength = (int)((long)parameterLength + paramSize);
                }
                if (knownParameterSize) {
                    if (writer.checkRewritableLength(staticLength + parameterLength)) {
                        writer.assureBufferCapacity(staticLength + parameterLength);
                        writer.buffer.put((byte)59);
                        writer.buffer.put(firstPart, 0, firstPart.length);
                        writer.buffer.put(secondPart, 0, secondPart.length);
                        for (i2 = 0; i2 < paramCount; ++i2) {
                            parameters[i2].writeUnsafeTo(writer);
                            writer.writeUnsafe(queryParts.get(i2 + 2));
                        }
                        writer.writeUnsafe(queryParts.get(paramCount + 2));
                        ++currentIndex;
                        continue;
                    }
                    break;
                }
                writer.write(59);
                writer.write(firstPart, 0, firstPart.length);
                writer.write(secondPart, 0, secondPart.length);
                for (i2 = 0; i2 < paramCount; ++i2) {
                    parameters[i2].writeTo(writer);
                    writer.write(queryParts.get(i2 + 2));
                }
                writer.write(queryParts.get(paramCount + 2));
                ++currentIndex;
            }
        } else {
            writer.write(firstPart, 0, firstPart.length);
            writer.write(secondPart, 0, secondPart.length);
            int lastPartLength = queryParts.get(paramCount + 2).length;
            int intermediatePartLength = queryParts.get(1).length;
            for (int i = 0; i < paramCount; ++i) {
                parameters[i].writeTo(writer);
                writer.write(queryParts.get(i + 2));
                intermediatePartLength += queryParts.get(i + 2).length;
            }
            while (currentIndex < parameterList.size()) {
                int i;
                parameters = parameterList.get(currentIndex);
                int parameterLength = 0;
                boolean knownParameterSize = true;
                for (ParameterHolder parameter : parameters) {
                    long paramSize = parameter.getApproximateTextProtocolLength();
                    if (paramSize == -1L) {
                        knownParameterSize = false;
                        break;
                    }
                    parameterLength = (int)((long)parameterLength + paramSize);
                }
                if (knownParameterSize) {
                    if (!writer.checkRewritableLength(1 + parameterLength + intermediatePartLength + lastPartLength)) break;
                    writer.assureBufferCapacity(1 + parameterLength + intermediatePartLength + lastPartLength);
                    writer.buffer.put((byte)44);
                    writer.buffer.put(secondPart, 0, secondPart.length);
                    for (i = 0; i < paramCount; ++i) {
                        parameters[i].writeUnsafeTo(writer);
                        byte[] addPart = queryParts.get(i + 2);
                        writer.buffer.put(addPart, 0, addPart.length);
                    }
                    ++currentIndex;
                    continue;
                }
                writer.write(44);
                writer.write(secondPart, 0, secondPart.length);
                for (i = 0; i < paramCount; ++i) {
                    parameters[i].writeTo(writer);
                    writer.write(queryParts.get(i + 2));
                }
                ++currentIndex;
            }
            writer.write(queryParts.get(paramCount + 2));
        }
        writer.finishPacketWithoutRelease();
        return currentIndex;
    }

    public static int sendMultiple(PacketOutputStream writer, String firstQuery, List<String> queries, int currentIndex) throws IOException {
        byte[] sqlByte;
        writer.startPacket(0);
        writer.write(3);
        writer.write(firstQuery.getBytes("UTF-8"));
        while (currentIndex < queries.size() && writer.checkRewritableLength((sqlByte = queries.get(currentIndex).getBytes("UTF-8")).length + 1)) {
            writer.write(59);
            writer.write(sqlByte);
            ++currentIndex;
        }
        writer.finishPacketWithoutRelease();
        return currentIndex;
    }

    public static void sendDirect(PacketOutputStream writer, byte[] sqlBytes) throws IOException, QueryException {
        writer.sendDirect(sqlBytes, 0, sqlBytes.length, (byte)3);
    }
}

