/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.BatchUpdateException;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.mariadb.jdbc.AbstractMariaDbPrepareStatement;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.MariaDbServerPreparedStatement;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.queryresults.ExecutionResult;
import org.mariadb.jdbc.internal.queryresults.MultiExecutionResult;
import org.mariadb.jdbc.internal.queryresults.MultiFixedIntExecutionResult;
import org.mariadb.jdbc.internal.queryresults.MultiVariableIntExecutionResult;
import org.mariadb.jdbc.internal.queryresults.SingleExecutionResult;
import org.mariadb.jdbc.internal.queryresults.resultset.MariaSelectResultSet;
import org.mariadb.jdbc.internal.util.ExceptionMapper;
import org.mariadb.jdbc.internal.util.Utils;
import org.mariadb.jdbc.internal.util.dao.ClientPrepareResult;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class MariaDbClientPreparedStatement
extends AbstractMariaDbPrepareStatement
implements Cloneable {
    private String sqlQuery;
    private ClientPrepareResult prepareResult;
    private ParameterHolder[] parameters;
    private List<ParameterHolder[]> parameterList = new ArrayList<ParameterHolder[]>();
    private ResultSetMetaData resultSetMetaData = null;
    private ParameterMetaData parameterMetaData = null;

    public MariaDbClientPreparedStatement(MariaDbConnection connection, String sql, int resultSetScrollType) throws SQLException {
        super(connection, resultSetScrollType);
        String key;
        this.sqlQuery = Utils.nativeSql(sql, connection.noBackslashEscapes);
        this.useFractionalSeconds = this.options.useFractionalSeconds;
        if (this.options.cachePrepStmts) {
            key = this.protocol.getDatabase() + "-" + this.sqlQuery;
            this.prepareResult = (ClientPrepareResult)connection.getClientPrepareStatementCache().get(key);
        }
        if (this.prepareResult == null) {
            this.prepareResult = this.options.rewriteBatchedStatements ? ClientPrepareResult.createRewritableParts(this.sqlQuery, connection.noBackslashEscapes) : ClientPrepareResult.createParameterParts(this.sqlQuery, connection.noBackslashEscapes);
            if (this.options.cachePrepStmts && sql.length() < 1024) {
                key = this.protocol.getDatabase() + "-" + this.sqlQuery;
                connection.getClientPrepareStatementCache().put(key, this.prepareResult);
            }
        }
        this.parameters = new ParameterHolder[this.prepareResult.getParamCount()];
    }

    @Override
    public MariaDbClientPreparedStatement clone() throws CloneNotSupportedException {
        MariaDbClientPreparedStatement clone = (MariaDbClientPreparedStatement)super.clone();
        clone.sqlQuery = this.sqlQuery;
        clone.prepareResult = this.prepareResult;
        clone.parameters = new ParameterHolder[this.prepareResult.getParamCount()];
        clone.resultSetMetaData = this.resultSetMetaData;
        clone.parameterMetaData = this.parameterMetaData;
        return clone;
    }

    @Override
    protected boolean isNoBackslashEscapes() {
        return this.connection.noBackslashEscapes;
    }

    @Override
    protected boolean useFractionalSeconds() {
        return this.useFractionalSeconds;
    }

    @Override
    protected Calendar cal() {
        return this.protocol.getCalendar();
    }

    @Override
    public boolean execute() throws SQLException {
        return this.executeInternal();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (this.executeInternal()) {
            return this.executionResult.getResultSet();
        }
        return MariaSelectResultSet.EMPTY;
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (this.executeInternal()) {
            return 0;
        }
        return this.getUpdateCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeInternal() throws SQLException {
        this.executing = true;
        QueryException exception = null;
        for (int i = 0; i < this.prepareResult.getParamCount(); ++i) {
            if (this.parameters[i] != null) continue;
            throw ExceptionMapper.getSqlException("You need to set exactly " + this.prepareResult.getParamCount() + " parameters on the prepared statement");
        }
        this.lock.lock();
        try {
            this.executeQueryProlog();
            this.batchResultSet = null;
            ExecutionResult executionResultTmp = this.options.allowMultiQueries || this.options.rewriteBatchedStatements ? new MultiVariableIntExecutionResult(this, this.getFetchSize(), 0, true) : new SingleExecutionResult((Statement)this, this.getFetchSize(), true, false, true);
            this.protocol.executeQuery(this.protocol.isMasterConnection(), executionResultTmp, this.prepareResult, this.parameters, this.resultSetScrollType);
            this.executionResult = executionResultTmp;
            boolean bl = this.executionResult.getResultSet() != null;
            return bl;
        }
        catch (QueryException e) {
            exception = e;
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
            this.executeQueryEpilog(exception);
            this.executing = false;
        }
    }

    @Override
    public void addBatch() throws SQLException {
        ParameterHolder[] holder = new ParameterHolder[this.prepareResult.getParamCount()];
        for (int i = 0; i < holder.length; ++i) {
            holder[i] = this.parameters[i];
            if (holder[i] != null) continue;
            throw ExceptionMapper.getSqlException("You need to set exactly " + this.prepareResult.getParamCount() + " parameters on the prepared statement");
        }
        this.parameterList.add(holder);
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SQLException("Cannot do addBatch(String) on preparedStatement");
    }

    @Override
    public void clearBatch() {
        this.parameterList.clear();
        this.parameters = new ParameterHolder[this.prepareResult.getParamCount()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        this.checkClose();
        int size = this.parameterList.size();
        if (size == 0) {
            return new int[0];
        }
        MultiExecutionResult internalExecutionResult = this.options.allowMultiQueries || this.options.rewriteBatchedStatements ? new MultiVariableIntExecutionResult(this, size, 0, false) : new MultiFixedIntExecutionResult(this, size, 0, false);
        this.lock.lock();
        try {
            QueryException exception = null;
            this.executeQueryProlog();
            try {
                this.executeInternalBatch(internalExecutionResult, size);
            }
            catch (QueryException e) {
                exception = e;
            }
            finally {
                if (exception != null && this.options.rewriteBatchedStatements) {
                    if (this.prepareResult.isRewritableValuesQuery()) {
                        internalExecutionResult.updateResultsForRewrite(size, true);
                    } else if (this.prepareResult.isRewritableMultipleQuery()) {
                        internalExecutionResult.updateResultsMultiple(size, true);
                    }
                }
                this.executionResult = internalExecutionResult;
                this.executing = false;
                this.executeQueryEpilog(exception);
            }
        }
        catch (SQLException sqle) {
            throw new BatchUpdateException(sqle.getMessage(), sqle.getSQLState(), sqle.getErrorCode(), internalExecutionResult.getAffectedRows(), (Throwable)sqle);
        }
        finally {
            this.lock.unlock();
            this.clearBatch();
        }
        return internalExecutionResult.getAffectedRows();
    }

    private void executeInternalBatch(MultiExecutionResult internalExecutionResult, int size) throws QueryException {
        if (this.options.rewriteBatchedStatements) {
            if (this.prepareResult.isRewritableValuesQuery()) {
                this.protocol.executeBatchRewrite(this.protocol.isMasterConnection(), internalExecutionResult, this.prepareResult, this.parameterList, this.resultSetScrollType, true);
                internalExecutionResult.updateResultsForRewrite(size, false);
                return;
            }
            if (this.prepareResult.isRewritableMultipleQuery()) {
                this.protocol.executeBatchRewrite(this.protocol.isMasterConnection(), internalExecutionResult, this.prepareResult, this.parameterList, this.resultSetScrollType, false);
                internalExecutionResult.updateResultsMultiple(size, false);
                return;
            }
        }
        if (this.options.useBatchMultiSend) {
            this.protocol.executeBatchMulti(this.protocol.isMasterConnection(), internalExecutionResult, this.prepareResult, this.parameterList, this.resultSetScrollType);
        } else {
            QueryException exception = null;
            for (int batchQueriesCount = 0; batchQueriesCount < size; ++batchQueriesCount) {
                try {
                    this.protocol.executeQuery(this.protocol.isMasterConnection(), internalExecutionResult, this.prepareResult, this.parameterList.get(batchQueriesCount), this.resultSetScrollType);
                    continue;
                }
                catch (QueryException e) {
                    if (this.options.continueBatchOnError) {
                        exception = e;
                        continue;
                    }
                    throw e;
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClose();
        ResultSet rs = this.getResultSet();
        if (rs != null) {
            return rs.getMetaData();
        }
        if (this.resultSetMetaData == null) {
            this.setParametersData();
        }
        return this.resultSetMetaData;
    }

    @Override
    protected void setParameter(int parameterIndex, ParameterHolder holder) throws SQLException {
        if (parameterIndex < 1 || parameterIndex >= this.prepareResult.getParamCount() + 1) {
            throw ExceptionMapper.getSqlException("Could not set parameter at position " + parameterIndex + " (values vas " + holder.toString() + ")");
        }
        this.parameters[parameterIndex - 1] = holder;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkClose();
        if (this.parameterMetaData == null) {
            this.setParametersData();
        }
        return this.parameterMetaData;
    }

    private void setParametersData() throws SQLException {
        MariaDbServerPreparedStatement ssps = new MariaDbServerPreparedStatement(this.connection, this.sqlQuery, 1004, true);
        this.resultSetMetaData = ssps.getMetaData();
        this.parameterMetaData = ssps.getParameterMetaData();
        ssps.close();
    }

    @Override
    public void clearParameters() {
        this.parameters = new ParameterHolder[this.prepareResult.getParamCount()];
    }

    @Override
    public void close() throws SQLException {
        super.close();
        if (this.connection == null || this.connection.pooledConnection == null || this.connection.pooledConnection.statementEventListeners.isEmpty()) {
            return;
        }
    }

    protected int getParameterCount() {
        return this.prepareResult.getParamCount();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("sql : '" + this.sqlQuery + "'");
        sb.append(", parameters : [");
        for (int i = 0; i < this.parameters.length; ++i) {
            ParameterHolder holder = this.parameters[i];
            if (holder == null) {
                sb.append("null");
            } else {
                sb.append(holder.toString());
            }
            if (i == this.parameters.length - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    protected ClientPrepareResult getPrepareResult() {
        return this.prepareResult;
    }
}

