/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.util.dao;

import java.util.concurrent.atomic.AtomicBoolean;
import org.mariadb.jdbc.internal.packet.dao.ColumnInformation;
import org.mariadb.jdbc.internal.protocol.Protocol;

public class PrepareResult {
    private int statementId;
    private ColumnInformation[] columns;
    private ColumnInformation[] parameters;
    private Protocol unProxiedProtocol;
    private final boolean executeOnMaster;
    private volatile int shareCounter = 1;
    private volatile boolean isBeingDeallocate;
    private AtomicBoolean inCache = new AtomicBoolean();

    public PrepareResult(int statementId, ColumnInformation[] columns, ColumnInformation[] parameters, Protocol unProxiedProtocol) {
        this.statementId = statementId;
        this.columns = columns;
        this.parameters = parameters;
        this.unProxiedProtocol = unProxiedProtocol;
        this.executeOnMaster = unProxiedProtocol.isMasterConnection();
    }

    public void failover(int statementId, Protocol unProxiedProtocol) {
        this.statementId = statementId;
        this.unProxiedProtocol = unProxiedProtocol;
        this.shareCounter = 1;
        this.isBeingDeallocate = false;
    }

    public void setAddToCache() {
        this.inCache.set(true);
    }

    public void setRemoveFromCache() {
        this.inCache.set(false);
    }

    public synchronized boolean incrementShareCounter() {
        if (this.isBeingDeallocate) {
            return false;
        }
        ++this.shareCounter;
        return true;
    }

    public synchronized void decrementShareCounter() {
        --this.shareCounter;
    }

    public synchronized boolean canBeDeallocate() {
        if (this.shareCounter > 0 || this.isBeingDeallocate) {
            return false;
        }
        if (!this.inCache.get()) {
            this.isBeingDeallocate = true;
            return true;
        }
        return false;
    }

    public synchronized int getShareCounter() {
        return this.shareCounter;
    }

    public int getStatementId() {
        return this.statementId;
    }

    public ColumnInformation[] getColumns() {
        return this.columns;
    }

    public ColumnInformation[] getParameters() {
        return this.parameters;
    }

    public Protocol getUnProxiedProtocol() {
        return this.unProxiedProtocol;
    }

    public boolean mustRePrepareOnSlave() {
        return this.executeOnMaster == this.unProxiedProtocol.isMasterConnection();
    }

    public boolean isExecuteOnMaster() {
        return this.executeOnMaster;
    }
}

