/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.failover.impl;

import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.UrlParser;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.failover.AbstractMastersSlavesListener;
import org.mariadb.jdbc.internal.failover.HandleErrorResult;
import org.mariadb.jdbc.internal.failover.thread.FailoverLoop;
import org.mariadb.jdbc.internal.failover.tools.SearchFilter;
import org.mariadb.jdbc.internal.protocol.MastersSlavesProtocol;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.util.dao.PrepareResult;
import org.mariadb.jdbc.internal.util.dao.QueryException;
import org.mariadb.jdbc.internal.util.dao.ReconnectDuringTransactionException;
import org.mariadb.jdbc.internal.util.scheduler.DynamicSizedSchedulerInterface;
import org.mariadb.jdbc.internal.util.scheduler.SchedulerServiceProviderHolder;

public class MastersSlavesListener
extends AbstractMastersSlavesListener {
    private static final double POOL_SIZE_TO_LISTENER_RATIO = 0.3;
    private static final double FAIL_LOOP_TO_LISTENER_RATIO = 0.3;
    protected Protocol masterProtocol;
    protected Protocol secondaryProtocol;
    private static final DynamicSizedSchedulerInterface dynamicSizedScheduler;
    private static final AtomicInteger listenerCount;

    public MastersSlavesListener(UrlParser urlParser) {
        super(urlParser);
        dynamicSizedScheduler.setPoolSize((int)Math.ceil((double)listenerCount.incrementAndGet() * 0.3));
        this.masterProtocol = null;
        this.secondaryProtocol = null;
        this.setMasterHostFail();
        this.setSecondaryHostFail();
    }

    @Override
    protected void removeListenerFromSchedulers() {
        super.removeListenerFromSchedulers();
        FailoverLoop.removeListener(this);
        listenerCount.addAndGet(-1);
    }

    @Override
    public void initializeConnection() throws QueryException {
        super.initializeConnection();
        try {
            this.reconnectFailedConnection(new SearchFilter(true));
        }
        catch (QueryException e) {
            this.checkInitialConnection(e);
        }
    }

    protected void checkInitialConnection(QueryException queryException) throws QueryException {
        if (this.secondaryProtocol == null || !this.secondaryProtocol.isConnected()) {
            this.setSecondaryHostFail();
        } else {
            this.resetSecondaryFailoverData();
        }
        if (this.masterProtocol == null || !this.masterProtocol.isConnected()) {
            this.setMasterHostFail();
            this.throwFailoverMessage(this.masterProtocol != null ? this.masterProtocol.getHostAddress() : null, true, queryException, false);
        } else {
            this.resetMasterFailoverData();
            if (this.isSecondaryHostFail()) {
                this.handleFailLoop();
            }
        }
    }

    @Override
    public void preClose() throws SQLException {
        if (this.explicitClosed.compareAndSet(false, true)) {
            this.proxy.lock.lock();
            try {
                this.removeListenerFromSchedulers();
                this.closeConnection(this.waitNewSecondaryProtocol.getAndSet(null));
                this.closeConnection(this.waitNewMasterProtocol.getAndSet(null));
                this.closeConnection(this.masterProtocol);
                this.closeConnection(this.secondaryProtocol);
            }
            finally {
                this.proxy.lock.unlock();
            }
        }
    }

    @Override
    public void preExecute() throws QueryException {
        this.lastQueryNanos = System.nanoTime();
        this.checkWaitingConnection();
        if (this.currentProtocol != null && (this.currentProtocol.isClosed() || !this.currentReadOnlyAsked && !this.currentProtocol.isMasterConnection())) {
            this.preAutoReconnect();
        }
    }

    public void checkWaitingConnection() throws QueryException {
        Protocol waitingProtocol;
        if (this.isSecondaryHostFail() && (waitingProtocol = (Protocol)this.waitNewSecondaryProtocol.getAndSet(null)) != null) {
            this.proxy.lock.lock();
            try {
                if (this.pingSecondaryProtocol(waitingProtocol)) {
                    this.lockAndSwitchSecondary(waitingProtocol);
                }
            }
            finally {
                this.proxy.lock.unlock();
            }
        }
        if (this.isMasterHostFail() && (waitingProtocol = (Protocol)this.waitNewMasterProtocol.getAndSet(null)) != null) {
            this.proxy.lock.lock();
            try {
                if (this.pingMasterProtocol(waitingProtocol)) {
                    this.lockAndSwitchMaster(waitingProtocol);
                }
            }
            finally {
                this.proxy.lock.unlock();
            }
        }
    }

    @Override
    public void reconnectFailedConnection(SearchFilter searchFilter) throws QueryException {
        if (!searchFilter.isInitialConnection() && (this.isExplicitClosed() || searchFilter.isFineIfFoundOnlyMaster() && !this.isMasterHostFail() || searchFilter.isFineIfFoundOnlySlave() && !this.isSecondaryHostFail())) {
            return;
        }
        if (!searchFilter.isFailoverLoop()) {
            try {
                this.checkWaitingConnection();
                if (searchFilter.isFineIfFoundOnlyMaster() && !this.isMasterHostFail() || searchFilter.isFineIfFoundOnlySlave() && !this.isSecondaryHostFail()) {
                    return;
                }
            }
            catch (ReconnectDuringTransactionException e) {
                return;
            }
        }
        this.currentConnectionAttempts.incrementAndGet();
        this.resetOldsBlackListHosts();
        LinkedList<HostAddress> loopAddress = new LinkedList<HostAddress>(this.urlParser.getHostAddresses());
        loopAddress.removeAll(this.getBlacklistKeys());
        Collections.shuffle(loopAddress);
        LinkedList<HostAddress> blacklistShuffle = new LinkedList<HostAddress>(this.getBlacklistKeys());
        Collections.shuffle(blacklistShuffle);
        loopAddress.addAll(blacklistShuffle);
        if (this.masterProtocol != null && !this.isMasterHostFail()) {
            loopAddress.remove(this.masterProtocol.getHostAddress());
            loopAddress.add(this.masterProtocol.getHostAddress());
        }
        if (this.secondaryProtocol != null && !this.isSecondaryHostFail()) {
            loopAddress.remove(this.secondaryProtocol.getHostAddress());
            loopAddress.add(this.secondaryProtocol.getHostAddress());
        }
        if (this.isMasterHostFail() || this.isSecondaryHostFail() || searchFilter.isInitialConnection()) {
            do {
                MastersSlavesProtocol.loop(this, loopAddress, searchFilter);
                if (searchFilter.isFailoverLoop()) continue;
                try {
                    this.checkWaitingConnection();
                }
                catch (ReconnectDuringTransactionException reconnectDuringTransactionException) {
                    // empty catch block
                }
            } while (searchFilter.isInitialConnection() && this.masterProtocol == null);
        }
    }

    @Override
    public void foundActiveMaster(Protocol newMasterProtocol) {
        if (this.isMasterHostFail()) {
            if (this.isExplicitClosed()) {
                newMasterProtocol.close();
                return;
            }
            if (!this.waitNewMasterProtocol.compareAndSet(null, newMasterProtocol)) {
                newMasterProtocol.close();
            }
        } else {
            newMasterProtocol.close();
        }
    }

    public void lockAndSwitchMaster(Protocol newMasterProtocol) throws ReconnectDuringTransactionException {
        if (this.masterProtocol != null && !this.masterProtocol.isClosed()) {
            this.masterProtocol.close();
        }
        if (!this.currentReadOnlyAsked || this.isSecondaryHostFail()) {
            try {
                this.syncConnection(this.currentProtocol, newMasterProtocol);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.currentProtocol = newMasterProtocol;
        }
        boolean inTransaction = this.masterProtocol != null && this.masterProtocol.inTransaction();
        this.masterProtocol = newMasterProtocol;
        this.resetMasterFailoverData();
        if (inTransaction) {
            throw new ReconnectDuringTransactionException("Connection reconnect automatically during an active transaction", 1401, "25S03");
        }
    }

    @Override
    public void foundActiveSecondary(Protocol newSecondaryProtocol) throws QueryException {
        if (this.isSecondaryHostFail()) {
            if (this.isExplicitClosed()) {
                newSecondaryProtocol.close();
                return;
            }
            if (this.proxy.lock.tryLock()) {
                try {
                    this.lockAndSwitchSecondary(newSecondaryProtocol);
                }
                finally {
                    this.proxy.lock.unlock();
                }
            } else if (!this.waitNewSecondaryProtocol.compareAndSet(null, newSecondaryProtocol)) {
                newSecondaryProtocol.close();
            }
        } else {
            newSecondaryProtocol.close();
        }
    }

    public void lockAndSwitchSecondary(Protocol newSecondaryProtocol) throws QueryException {
        if (this.secondaryProtocol != null && !this.secondaryProtocol.isClosed()) {
            this.secondaryProtocol.close();
        }
        if (this.currentReadOnlyAsked || this.urlParser.getOptions().failOnReadOnly && !this.currentReadOnlyAsked && this.isMasterHostFail()) {
            try {
                this.syncConnection(this.currentProtocol, newSecondaryProtocol);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.currentProtocol = newSecondaryProtocol;
        }
        this.secondaryProtocol = newSecondaryProtocol;
        if (this.urlParser.getOptions().assureReadOnly) {
            this.setSessionReadOnly(true, this.secondaryProtocol);
        }
        this.resetSecondaryFailoverData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void switchReadOnlyConnection(Boolean mustBeReadOnly) throws QueryException {
        block21: {
            block22: {
                this.checkWaitingConnection();
                if (this.currentReadOnlyAsked == mustBeReadOnly) break block21;
                this.proxy.lock.lock();
                if (this.currentReadOnlyAsked == mustBeReadOnly) {
                    return;
                }
                this.currentReadOnlyAsked = mustBeReadOnly;
                if (!this.currentReadOnlyAsked) break block22;
                if (!this.currentProtocol.isMasterConnection()) break block21;
                if (this.isSecondaryHostFail()) ** GOTO lbl-1000
                this.proxy.lock.lock();
                try {
                    this.syncConnection(this.masterProtocol, this.secondaryProtocol);
                    this.currentProtocol = this.secondaryProtocol;
                    return;
                }
                catch (QueryException e) {
                    if (this.setSecondaryHostFail()) {
                        this.addToBlacklist(this.secondaryProtocol.getHostAddress());
                    }
                }
                finally {
                    this.proxy.lock.unlock();
                }
lbl-1000:
                // 2 sources

                {
                    FailoverLoop.addListener(this);
                    break block21;
                }
            }
            if (this.currentProtocol.isMasterConnection()) break block21;
            if (this.isMasterHostFail()) ** GOTO lbl37
            try {
                this.syncConnection(this.secondaryProtocol, this.masterProtocol);
                this.currentProtocol = this.masterProtocol;
                return;
            }
            catch (QueryException e) {
                if (this.setMasterHostFail()) {
                    this.addToBlacklist(this.masterProtocol.getHostAddress());
                }
lbl37:
                // 4 sources

                try {
                    this.reconnectFailedConnection(new SearchFilter(true, false));
                    this.handleFailLoop();
                    try {
                        this.syncConnection(this.secondaryProtocol, this.masterProtocol);
                        this.currentProtocol = this.masterProtocol;
                    }
                    catch (QueryException e) {
                        if (this.setMasterHostFail()) {
                            this.addToBlacklist(this.masterProtocol.getHostAddress());
                        }
                    }
                }
                catch (QueryException e) {
                    FailoverLoop.removeListener(this);
                    failHost = this.masterProtocol != null ? this.masterProtocol.getHostAddress() : null;
                    this.throwFailoverMessage(failHost, true, new QueryException("master " + this.masterProtocol.getHostAddress() + " connection failed"), false);
                }
            }
            finally {
                this.proxy.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HandleErrorResult primaryFail(Method method, Object[] args) throws Throwable {
        boolean inTransaction;
        boolean alreadyClosed;
        block20: {
            block19: {
                alreadyClosed = !this.masterProtocol.isConnected();
                inTransaction = this.masterProtocol != null && this.masterProtocol.inTransaction();
                try {
                    if (this.masterProtocol != null && this.masterProtocol.isConnected() && this.masterProtocol.ping()) {
                        if (inTransaction) {
                            this.masterProtocol.rollback();
                            return new HandleErrorResult(true);
                        }
                        return this.relaunchOperation(method, args);
                    }
                }
                catch (QueryException e) {
                    this.proxy.lock.lock();
                    try {
                        this.masterProtocol.close();
                    }
                    finally {
                        this.proxy.lock.unlock();
                    }
                    if (!this.setMasterHostFail()) break block19;
                    this.addToBlacklist(this.masterProtocol.getHostAddress());
                }
            }
            if (this.urlParser.getOptions().failOnReadOnly && !this.isSecondaryHostFail()) {
                try {
                    if (this.secondaryProtocol == null || !this.secondaryProtocol.ping()) break block20;
                    this.syncConnection(this.masterProtocol, this.secondaryProtocol);
                    this.proxy.lock.lock();
                    try {
                        this.currentProtocol = this.secondaryProtocol;
                    }
                    finally {
                        this.proxy.lock.unlock();
                    }
                    FailoverLoop.addListener(this);
                    try {
                        return this.relaunchOperation(method, args);
                    }
                    catch (Exception e) {
                        return new HandleErrorResult();
                    }
                }
                catch (Exception e) {
                    if (!this.setSecondaryHostFail()) break block20;
                    this.blackListAndCloseConnection(this.secondaryProtocol);
                }
            }
        }
        try {
            this.reconnectFailedConnection(new SearchFilter(true, this.urlParser.getOptions().failOnReadOnly));
            this.handleFailLoop();
            if (this.currentReadOnlyAsked || alreadyClosed || !alreadyClosed && !inTransaction && this.isQueryRelaunchable(method, args)) {
                return this.relaunchOperation(method, args);
            }
            return new HandleErrorResult(true);
        }
        catch (Exception e) {
            this.setMasterHostFail();
            FailoverLoop.removeListener(this);
            return new HandleErrorResult();
        }
    }

    private void blackListAndCloseConnection(Protocol protocol) {
        this.addToBlacklist(protocol.getHostAddress());
        if (protocol.isConnected()) {
            this.proxy.lock.lock();
            try {
                protocol.close();
            }
            finally {
                this.proxy.lock.unlock();
            }
        }
    }

    @Override
    public void reconnect() throws QueryException {
        SearchFilter filter;
        boolean inTransaction = false;
        if (this.currentReadOnlyAsked) {
            filter = new SearchFilter(true, true);
        } else {
            inTransaction = this.masterProtocol != null && this.masterProtocol.inTransaction();
            filter = new SearchFilter(true, this.urlParser.getOptions().failOnReadOnly);
        }
        this.reconnectFailedConnection(filter);
        this.handleFailLoop();
        if (inTransaction) {
            throw new ReconnectDuringTransactionException("Connection reconnect automatically during an active transaction", 1401, "25S03");
        }
    }

    private boolean pingSecondaryProtocol(Protocol protocol) {
        block7: {
            try {
                if (protocol != null && protocol.isConnected() && protocol.ping()) {
                    return true;
                }
            }
            catch (Exception e) {
                this.proxy.lock.lock();
                try {
                    protocol.close();
                }
                finally {
                    this.proxy.lock.unlock();
                }
                if (!this.setSecondaryHostFail()) break block7;
                this.addToBlacklist(protocol.getHostAddress());
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HandleErrorResult secondaryFail(Method method, Object[] args) throws Throwable {
        block13: {
            if (this.pingSecondaryProtocol(this.secondaryProtocol)) {
                return this.relaunchOperation(method, args);
            }
            if (!this.isMasterHostFail()) {
                try {
                    if (this.masterProtocol == null) break block13;
                    this.masterProtocol.ping();
                    this.syncConnection(this.secondaryProtocol, this.masterProtocol);
                    this.proxy.lock.lock();
                    try {
                        this.currentProtocol = this.masterProtocol;
                    }
                    finally {
                        this.proxy.lock.unlock();
                    }
                    FailoverLoop.addListener(this);
                    return this.relaunchOperation(method, args);
                }
                catch (Exception e) {
                    if (!this.setMasterHostFail()) break block13;
                    this.blackListAndCloseConnection(this.masterProtocol);
                }
            }
        }
        try {
            this.reconnectFailedConnection(new SearchFilter(true, true));
            this.handleFailLoop();
            if (this.isSecondaryHostFail()) {
                this.syncConnection(this.secondaryProtocol, this.masterProtocol);
                this.proxy.lock.lock();
                try {
                    this.currentProtocol = this.masterProtocol;
                }
                finally {
                    this.proxy.lock.unlock();
                }
            }
            return this.relaunchOperation(method, args);
        }
        catch (Exception ee) {
            FailoverLoop.removeListener(this);
            return new HandleErrorResult();
        }
    }

    @Override
    public void handleFailLoop() {
        if (this.isMasterHostFail() || this.isSecondaryHostFail()) {
            if (!this.isExplicitClosed()) {
                FailoverLoop.addListener(this);
            }
        } else {
            FailoverLoop.removeListener(this);
        }
    }

    @Override
    public boolean isMasterConnected() {
        return this.masterProtocol != null && this.masterProtocol.isConnected();
    }

    @Override
    public boolean checkMasterStatus(SearchFilter searchFilter) {
        if (this.masterProtocol != null) {
            this.pingMasterProtocol(this.masterProtocol);
        }
        return false;
    }

    @Override
    public void rePrepareOnSlave(PrepareResult oldPrepareResult, String sql, MariaDbType[] parameterTypeHeader) throws QueryException {
        if (this.secondaryProtocol != null && !this.isSecondaryHostFail()) {
            PrepareResult prepareResult = this.secondaryProtocol.prepare(sql, true);
            for (int i = 0; i < parameterTypeHeader.length; ++i) {
                parameterTypeHeader[i] = null;
            }
            try {
                prepareResult.getUnProxiedProtocol().releasePrepareStatement(prepareResult, sql);
            }
            catch (QueryException queryException) {
                // empty catch block
            }
            oldPrepareResult.failover(prepareResult.getStatementId(), this.secondaryProtocol);
        }
    }

    static {
        listenerCount = new AtomicInteger();
        dynamicSizedScheduler = SchedulerServiceProviderHolder.getScheduler(1);
        dynamicSizedScheduler.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                dynamicSizedScheduler.setPoolSize((int)Math.ceil((double)listenerCount.get() * 0.3));
            }
        }, 2L, 2L, TimeUnit.HOURS);
        dynamicSizedScheduler.scheduleWithFixedDelay(new Runnable(){
            private final ArrayDeque<FailoverLoop> failoverLoops = new ArrayDeque(8);

            @Override
            public void run() {
                block4: {
                    int countChange;
                    block3: {
                        int desiredFailCount = (int)Math.ceil((double)listenerCount.get() * 0.3);
                        countChange = desiredFailCount - this.failoverLoops.size();
                        if (countChange <= 0) break block3;
                        while (countChange > 0) {
                            this.failoverLoops.add(new FailoverLoop(dynamicSizedScheduler));
                            --countChange;
                        }
                        break block4;
                    }
                    if (countChange >= 0) break block4;
                    ArrayList<FailoverLoop> removedLoops = new ArrayList<FailoverLoop>(-countChange);
                    while (countChange < 0) {
                        FailoverLoop failoverLoop = this.failoverLoops.remove();
                        failoverLoop.unscheduleTask();
                        removedLoops.add(failoverLoop);
                        ++countChange;
                    }
                    for (FailoverLoop failoverLoop : removedLoops) {
                        failoverLoop.blockTillTerminated();
                    }
                }
            }
        }, 250L, 250L, TimeUnit.MILLISECONDS);
    }
}

