/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.stream;

import java.io.IOException;
import java.io.InputStream;

public class OptimizedBufferedInputStream
extends InputStream {
    private static final int BUFFER_SIZE = 32768;
    private final byte[] buffer = new byte[32768];
    private final InputStream stream;
    protected int count;
    protected int position;

    public OptimizedBufferedInputStream(InputStream stream) {
        this.stream = stream;
    }

    @Override
    public int read() throws IOException {
        throw new IOException("Not implemented");
    }

    @Override
    public int read(byte[] bytes, int off, int len) throws IOException {
        if (this.count <= 0) {
            if (len >= 32768) {
                return this.stream.read(bytes, off, len);
            }
            this.readFromUnderLyingStream(len);
            if (this.count <= 0) {
                return -1;
            }
        }
        int readSize = this.count < len ? this.count : len;
        System.arraycopy(this.buffer, this.position, bytes, off, readSize);
        this.position += readSize;
        this.count -= readSize;
        return readSize;
    }

    private void readFromUnderLyingStream(int readMinLength) throws IOException {
        this.position = 0;
        this.count = 0;
        int availableLength = this.stream.available();
        int maxReadLength = availableLength > 32768 ? 32768 : (availableLength > readMinLength ? availableLength : readMinLength);
        int read = this.stream.read(this.buffer, this.position, maxReadLength);
        if (read > 0) {
            this.count = read;
        }
    }

    @Override
    public long skip(long length) throws IOException {
        if (this.count <= 0) {
            this.readFromUnderLyingStream((int)length);
            if (this.count <= 0) {
                return 0L;
            }
        }
        long skipLength = (long)this.count < length ? (long)this.count : length;
        this.position = (int)((long)this.position + skipLength);
        this.count = (int)((long)this.count - skipLength);
        return skipLength;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int available() throws IOException {
        throw new IOException("Not implemented");
    }
}

