/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.send;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Deque;
import org.mariadb.jdbc.internal.packet.send.InterfaceSendPacket;
import org.mariadb.jdbc.internal.query.Query;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class SendTextQueryPacket
implements InterfaceSendPacket {
    private Query query;
    private Deque<Query> queries;
    private boolean isRewritable;
    private int rewriteOffset;

    public SendTextQueryPacket(Deque<Query> queries, boolean isRewritable, int rewriteOffset) {
        this.queries = queries;
        this.query = null;
        this.isRewritable = isRewritable;
        this.rewriteOffset = rewriteOffset;
    }

    public SendTextQueryPacket(Query query) {
        this.query = query;
        this.queries = null;
        this.isRewritable = false;
        this.rewriteOffset = 0;
    }

    @Override
    public void send(OutputStream stream) throws IOException, QueryException {
        PacketOutputStream pos = (PacketOutputStream)stream;
        pos.startPacket(0);
        pos.write(3);
        if (this.query != null) {
            this.query.writeTo(stream);
        } else if (this.queries.size() == 1) {
            this.queries.poll().writeTo(stream);
        } else if (!this.isRewritable) {
            this.queries.poll().writeTo(stream);
            while (!this.queries.isEmpty()) {
                Query query = this.queries.poll();
                if (!pos.checkRewritableLength(query.getQuerySize())) continue;
                pos.write(59);
                query.writeTo(stream);
            }
        } else {
            Query query;
            Query firstQuery = this.queries.poll();
            firstQuery.writeFirstRewritePart(stream);
            int lastPartLength = firstQuery.writeLastRewritePartLength();
            while ((query = this.queries.peekFirst()) != null && pos.checkRewritableLength(query.writeToRewritablePartLength(this.rewriteOffset) + lastPartLength)) {
                this.queries.pollFirst();
                query.writeToRewritablePart(stream, this.rewriteOffset);
            }
            firstQuery.writeLastRewritePart(stream);
        }
        pos.finishPacket();
    }
}

