/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.dao.parameters;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;

public class ParameterWriter {
    private static final byte[] BINARY_INTRODUCER = new byte[]{95, 98, 105, 110, 97, 114, 121, 32, 39};
    private static final byte[] QUOTE = new byte[]{39};

    private static void writeBytesEscaped(OutputStream out, byte[] bytes, int count, boolean noBackslashEscapes) throws IOException {
        if (noBackslashEscapes) {
            block6: for (int i = 0; i < count; ++i) {
                byte bit = bytes[i];
                switch (bit) {
                    case 39: {
                        out.write(39);
                        out.write(bit);
                        continue block6;
                    }
                    default: {
                        out.write(bit);
                    }
                }
            }
        } else {
            block7: for (int i = 0; i < count; ++i) {
                byte bit = bytes[i];
                switch (bit) {
                    case 0: 
                    case 34: 
                    case 39: 
                    case 92: {
                        out.write(92);
                        out.write(bit);
                        continue block7;
                    }
                    default: {
                        out.write(bit);
                    }
                }
            }
        }
    }

    public static void writeBytesEscaped(OutputStream out, byte[] bytes, boolean noBackslashEscapes) throws IOException {
        ParameterWriter.writeBytesEscaped(out, bytes, bytes.length, noBackslashEscapes);
    }

    public static void write(OutputStream out, byte[] bytes, boolean noBackslashEscapes) throws IOException {
        out.write(BINARY_INTRODUCER);
        ParameterWriter.writeBytesEscaped(out, bytes, noBackslashEscapes);
        out.write(QUOTE);
    }

    public static void write(OutputStream out, String value, boolean noBackslashEscapes) throws IOException {
        byte[] bytes = value.getBytes("UTF-8");
        out.write(QUOTE);
        ParameterWriter.writeBytesEscaped(out, bytes, noBackslashEscapes);
        out.write(QUOTE);
    }

    public static void write(OutputStream out, InputStream is, boolean noBackslashEscapes) throws IOException {
        int len;
        out.write(QUOTE);
        byte[] buffer = new byte[1024];
        while ((len = is.read(buffer)) >= 0) {
            ParameterWriter.writeBytesEscaped(out, buffer, len, noBackslashEscapes);
        }
        out.write(QUOTE);
    }

    public static void write(OutputStream out, InputStream is, long length, boolean noBackslashEscapes) throws IOException {
        int len;
        int bytesToRead;
        out.write(QUOTE);
        byte[] buffer = new byte[1024];
        long bytesLeft = length;
        while ((bytesToRead = (int)Math.min(bytesLeft, (long)buffer.length)) != 0 && (len = is.read(buffer, 0, bytesToRead)) > 0) {
            ParameterWriter.writeBytesEscaped(out, buffer, len, noBackslashEscapes);
            bytesLeft -= (long)len;
        }
        out.write(QUOTE);
    }

    public static void write(OutputStream out, Reader reader, boolean noBackslashEscapes) throws IOException {
        int len;
        out.write(QUOTE);
        char[] buffer = new char[1024];
        while ((len = reader.read(buffer)) >= 0) {
            ParameterWriter.writeBytesEscaped(out, new String(buffer, 0, len).getBytes("UTF-8"), noBackslashEscapes);
        }
        out.write(QUOTE);
    }

    public static void write(OutputStream out, ArrayList<char[]> readArrays, boolean noBackslashEscapes) throws IOException {
        out.write(QUOTE);
        for (char[] charArray : readArrays) {
            ParameterWriter.writeBytesEscaped(out, new String(charArray, 0, charArray.length).getBytes("UTF-8"), noBackslashEscapes);
        }
        out.write(QUOTE);
    }

    public static void write(OutputStream out, Reader reader, long length, boolean noBackslashEscapes) throws IOException {
        int len;
        int charsToRead;
        out.write(QUOTE);
        char[] buffer = new char[1024];
        long charsLeft = length;
        while ((charsToRead = (int)Math.min(charsLeft, (long)buffer.length)) != 0 && (len = reader.read(buffer, 0, charsToRead)) > 0) {
            byte[] bytes = new String(buffer, 0, len).getBytes("UTF-8");
            ParameterWriter.writeBytesEscaped(out, bytes, bytes.length, noBackslashEscapes);
            charsLeft -= (long)len;
        }
        out.write(QUOTE);
    }

    public static void write(OutputStream out, int value) throws IOException {
        out.write(String.valueOf(value).getBytes());
    }

    public static void write(OutputStream out, long value) throws IOException {
        out.write(String.valueOf(value).getBytes());
    }

    public static void write(OutputStream out, double value) throws IOException {
        out.write(String.valueOf(value).getBytes());
    }

    public static void write(OutputStream out, BigDecimal bd) throws IOException {
        out.write(bd.toPlainString().getBytes());
    }

    public static void writeBytesArray(OutputStream out, ArrayList<byte[]> readArrays, boolean noBackslashEscapes) throws IOException {
        out.write(QUOTE);
        for (byte[] buffer : readArrays) {
            ParameterWriter.writeBytesEscaped(out, buffer, buffer.length, noBackslashEscapes);
        }
        out.write(QUOTE);
    }

    public static void writeDate(OutputStream out, Calendar calendar) throws IOException {
        out.write(QUOTE);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = sdf.format(calendar.getTime());
        out.write(dateString.getBytes());
        out.write(QUOTE);
    }

    static void formatMicroseconds(OutputStream out, int microseconds, boolean writeFractionalSeconds) throws IOException {
        if (microseconds == 0 || !writeFractionalSeconds) {
            return;
        }
        out.write(46);
        int factor = 100000;
        while (microseconds > 0) {
            int dig = microseconds / factor;
            out.write(48 + dig);
            microseconds -= dig * factor;
            factor /= 10;
        }
    }

    public static void writeTimestamp(OutputStream out, Timestamp ts, Calendar calendar, boolean writeFractionalSeconds) throws IOException {
        out.write(QUOTE);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (calendar != null) {
            sdf.setCalendar(calendar);
        }
        String dateString = sdf.format(ts);
        out.write(dateString.getBytes());
        ParameterWriter.formatMicroseconds(out, ts.getNanos() / 1000, writeFractionalSeconds);
        out.write(QUOTE);
    }

    public static void writeTime(OutputStream out, Time time, Calendar calendar, boolean writeFractionalSeconds) throws IOException {
        out.write(QUOTE);
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        if (calendar != null) {
            sdf.setCalendar(calendar);
        }
        String dateString = sdf.format(time);
        if (time.getTime() < 0L) {
            dateString = "-" + dateString;
        }
        out.write(dateString.getBytes());
        int microseconds = (int)(time.getTime() % 1000L) * 1000;
        ParameterWriter.formatMicroseconds(out, microseconds, writeFractionalSeconds);
        out.write(QUOTE);
    }

    public static void writeObject(OutputStream out, Object obj, boolean noBackslashEscapes) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(obj);
        ParameterWriter.write(out, baos.toByteArray(), noBackslashEscapes);
    }

    public static byte[] writeLittleEndian(int value) {
        return new byte[]{(byte)(value >> 0 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 24 & 0xFF)};
    }
}

