/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.queryresults;

import java.io.IOException;
import org.mariadb.jdbc.internal.packet.dao.ColumnInformation;
import org.mariadb.jdbc.internal.packet.read.ReadPacketFetcher;
import org.mariadb.jdbc.internal.packet.result.BinaryRowPacket;
import org.mariadb.jdbc.internal.packet.result.EndOfFilePacket;
import org.mariadb.jdbc.internal.packet.result.ErrorPacket;
import org.mariadb.jdbc.internal.packet.result.RowPacket;
import org.mariadb.jdbc.internal.packet.result.TextRowPacket;
import org.mariadb.jdbc.internal.protocol.AbstractConnectProtocol;
import org.mariadb.jdbc.internal.protocol.AbstractQueryProtocol;
import org.mariadb.jdbc.internal.protocol.MasterProtocol;
import org.mariadb.jdbc.internal.queryresults.AbstractQueryResult;
import org.mariadb.jdbc.internal.queryresults.NoSuchColumnException;
import org.mariadb.jdbc.internal.queryresults.SelectQueryResult;
import org.mariadb.jdbc.internal.queryresults.ValueObject;
import org.mariadb.jdbc.internal.util.buffer.Buffer;
import org.mariadb.jdbc.internal.util.constant.ServerStatus;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class StreamingSelectResult
extends SelectQueryResult {
    public ValueObject[] values;
    private ReadPacketFetcher packetFetcher;
    private AbstractConnectProtocol protocol;
    private boolean isEof;
    private boolean beforeFirst;
    private boolean binaryProtocol;
    private RowPacket rowPacket;

    public StreamingSelectResult(ColumnInformation[] info, AbstractConnectProtocol protocol, ReadPacketFetcher fetcher, boolean binaryProtocol) {
        this.columnInformation = info;
        this.columnInformationLength = info.length;
        this.protocol = protocol;
        this.packetFetcher = fetcher;
        this.beforeFirst = true;
        this.isEof = false;
        this.binaryProtocol = binaryProtocol;
        protocol.activeResult = this;
        this.rowPacket = binaryProtocol ? new BinaryRowPacket(this.columnInformation, protocol.getOptions(), this.columnInformationLength) : new TextRowPacket(this.columnInformation, protocol.getOptions(), this.columnInformationLength);
    }

    @Override
    public void addResult(AbstractQueryResult other) {
    }

    public static StreamingSelectResult createStreamingSelectResult(long fieldCount, ReadPacketFetcher packetFetcher, AbstractQueryProtocol protocol, boolean binaryProtocol) throws IOException, QueryException {
        if (protocol.activeResult != null) {
            throw new QueryException("There is an active result set on the current connection, which must be closed prior to opening a new one");
        }
        ColumnInformation[] ci = new ColumnInformation[(int)fieldCount];
        int i = 0;
        while ((long)i < fieldCount) {
            Buffer buffer = packetFetcher.getPacket();
            try {
                ci[i] = new ColumnInformation(buffer);
            }
            catch (Exception e) {
                throw new QueryException("Error when trying to parse field stream : " + e + ",stream content (hex) = " + MasterProtocol.hexdump(buffer.buf, 0), 0, "HY000", e);
            }
            ++i;
        }
        Buffer bufferEof = packetFetcher.getReusableBuffer();
        if (bufferEof.getByteAt(0) != -2 || bufferEof.limit >= 9) {
            throw new QueryException("Packets out of order when reading field packets, expected was EOF stream. Packet contents (hex) = " + MasterProtocol.hexdump(bufferEof.buf, 0));
        }
        return new StreamingSelectResult(ci, protocol, packetFetcher, binaryProtocol);
    }

    @Override
    public boolean next() throws IOException, QueryException {
        if (this.isEof) {
            return false;
        }
        Buffer buffer = this.packetFetcher.getPacket();
        byte initialByte = buffer.getByteAt(0);
        if (initialByte == -1) {
            this.protocol.activeResult = null;
            this.protocol.moreResults = false;
            ErrorPacket errorPacket = new ErrorPacket(buffer);
            throw new QueryException(errorPacket.getMessage(), errorPacket.getErrorNumber(), errorPacket.getSqlState());
        }
        if (initialByte == -2 && buffer.remaining() < 9) {
            EndOfFilePacket endOfFilePacket = new EndOfFilePacket(buffer);
            this.protocol.activeResult = null;
            this.protocol.moreResults = (endOfFilePacket.getStatusFlags() & ServerStatus.MORE_RESULTS_EXISTS) != 0;
            this.warningCount = endOfFilePacket.getWarningCount();
            this.protocol.hasWarnings = this.warningCount > 0;
            this.isEof = true;
            this.values = null;
            return false;
        }
        this.values = this.rowPacket.getRow(this.packetFetcher, buffer);
        return true;
    }

    @Override
    public void close() {
        super.close();
        if (this.protocol != null && this.protocol.activeResult == this) {
            try {
                while (true) {
                    if (this.protocol.activeResult == null) {
                        return;
                    }
                    if (this.next()) continue;
                    return;
                }
            }
            catch (QueryException qe) {
                return;
            }
            catch (IOException ioe) {
                return;
            }
            finally {
                this.protocol.activeResult = null;
                this.protocol = null;
                this.packetFetcher = null;
            }
        }
    }

    @Override
    public ValueObject getValueObject(int index) throws NoSuchColumnException {
        return this.values[index];
    }

    @Override
    public int getRows() {
        return -1;
    }

    @Override
    public boolean isBeforeFirst() {
        return this.beforeFirst;
    }

    @Override
    public boolean isAfterLast() {
        return this.isEof;
    }

    public boolean isBinaryProtocol() {
        return this.binaryProtocol;
    }
}

