/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.result;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.mariadb.jdbc.internal.packet.result.AbstractResultPacket;
import org.mariadb.jdbc.internal.util.buffer.Reader;

public class LocalInfilePacket
extends AbstractResultPacket {
    private String fileName;

    public LocalInfilePacket(ByteBuffer byteBuffer) {
        super(byteBuffer);
        Reader reader = new Reader(byteBuffer);
        long fieldCount = reader.getLengthEncodedBinary();
        if (fieldCount != -1L) {
            throw new AssertionError((Object)"field count must be -1");
        }
        this.fileName = reader.readString(StandardCharsets.UTF_8);
    }

    public String getFileName() {
        return this.fileName;
    }

    public String toString() {
        return this.fileName;
    }

    @Override
    public AbstractResultPacket.ResultType getResultType() {
        return AbstractResultPacket.ResultType.LOCALINFILE;
    }

    public byte getPacketSeq() {
        return 0;
    }
}

