/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.BatchUpdateException;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.mariadb.jdbc.AbstractMariaDbPrepareStatement;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.MariaDbParameterMetaData;
import org.mariadb.jdbc.MariaDbResultSet;
import org.mariadb.jdbc.MariaDbResultSetMetaData;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.queryresults.ModifyQueryResult;
import org.mariadb.jdbc.internal.queryresults.ResultSetType;
import org.mariadb.jdbc.internal.util.ExceptionMapper;
import org.mariadb.jdbc.internal.util.dao.PrepareResult;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class MariaDbServerPreparedStatement
extends AbstractMariaDbPrepareStatement {
    protected boolean binaryData = true;
    String sql;
    PrepareResult prepareResult;
    boolean returnTableAlias = false;
    int parameterCount;
    MariaDbResultSetMetaData metadata;
    MariaDbParameterMetaData parameterMetaData;
    ParameterHolder[] currentParameterHolder;
    List<ParameterHolder[]> queryParameters = new ArrayList<ParameterHolder[]>();

    public MariaDbServerPreparedStatement(MariaDbConnection connection, String sql, int autoGeneratedKeys) throws SQLException {
        super(connection, autoGeneratedKeys);
        this.useFractionalSeconds = connection.getProtocol().getOptions().useFractionalSeconds;
        this.sql = sql;
        this.prepare(sql);
    }

    private void prepare(String sql) throws SQLException {
        this.checkClose();
        try {
            this.connection.lock.lock();
            try {
                if (this.protocol.hasUnreadData()) {
                    ExceptionMapper.throwException(new QueryException("There is an open result set on the current connection, which must be closed prior to executing a query"), this.connection, this);
                }
                this.prepareResult = this.protocol.prepare(sql);
            }
            finally {
                this.connection.lock.unlock();
            }
            this.parameterCount = this.prepareResult.parameters.length;
            if (this.parameterCount > 0) {
                this.currentParameterHolder = new ParameterHolder[this.prepareResult.parameters.length];
            }
            this.returnTableAlias = this.protocol.getOptions().useOldAliasMetadataBehavior;
            this.metadata = new MariaDbResultSetMetaData(this.prepareResult.columns, this.protocol.getDataTypeMappingFlags(), this.returnTableAlias);
            this.parameterMetaData = new MariaDbParameterMetaData(this.prepareResult.parameters);
        }
        catch (QueryException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ExceptionMapper.throwException(e, this.connection, this);
        }
    }

    @Override
    protected boolean isNoBackslashEscapes() {
        return this.connection.noBackslashEscapes;
    }

    @Override
    protected boolean useFractionalSeconds() {
        return this.useFractionalSeconds;
    }

    @Override
    protected Calendar cal() {
        return this.protocol.getCalendar();
    }

    @Override
    protected void setParameter(int parameterIndex, ParameterHolder holder) throws SQLException {
        try {
            this.currentParameterHolder[parameterIndex - 1] = holder;
        }
        catch (ArrayIndexOutOfBoundsException a) {
            throw ExceptionMapper.getSqlException("Could not set parameter at position " + parameterIndex + ", parameter length is " + this.parameterCount);
        }
    }

    @Override
    public void addBatch() throws SQLException {
        for (int i = 0; i < this.parameterCount; ++i) {
            if (this.currentParameterHolder[i] != null) continue;
            ExceptionMapper.throwException(new QueryException("Parameter at position " + (i + 1) + " is not set", -1, "07004"), this.connection, this);
        }
        this.queryParameters.add((ParameterHolder[])this.currentParameterHolder.clone());
    }

    @Override
    public void clearBatch() {
        this.queryParameters.clear();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.parameterMetaData;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        this.checkClose();
        this.batchResultSet = null;
        if (this.parameterCount > 0 && this.queryParameters.size() == 0) {
            throw ExceptionMapper.getSqlException("No Parameters set. The command addBatch() must have been set");
        }
        int counter = 0;
        int[] ret = new int[this.queryParameters.size()];
        long[] insertIds = null;
        if (this.autoGeneratedKeys) {
            insertIds = new long[this.queryParameters.size()];
        }
        MariaDbResultSet rs = null;
        MariaDbType[] parameterTypeHeader = new MariaDbType[this.parameterCount];
        this.connection.lock.lock();
        this.executing = true;
        QueryException exception = null;
        try {
            this.executeQueryProlog();
            try {
                int queryParameterSize = this.queryParameters.size();
                while (counter < queryParameterSize) {
                    this.queryResult = this.protocol.executePreparedQuery(this.sql, this.queryParameters.get(counter), this.prepareResult, parameterTypeHeader, this.isStreaming());
                    if (this.queryResult.getFailureObject() != null) {
                        this.prepareResult = this.queryResult.getFailureObject();
                    }
                    this.cacheMoreResults();
                    int updateCount = this.getUpdateCount();
                    ret[counter] = updateCount == -1 ? -2 : updateCount;
                    if (this.autoGeneratedKeys) {
                        insertIds[counter] = this.queryResult != null && this.queryResult.getResultSetType() == ResultSetType.MODIFY ? ((ModifyQueryResult)this.queryResult).getInsertId() : 0L;
                    }
                    ++counter;
                }
            }
            catch (QueryException e) {
                exception = e;
            }
            finally {
                this.executeQueryEpilog(exception, this.sql);
                this.executing = false;
            }
            if (this.autoGeneratedKeys && this.queryResult != null && this.queryResult.getResultSetType() == ResultSetType.MODIFY) {
                rs = (MariaDbResultSet)MariaDbResultSet.createGeneratedKeysResultSet(insertIds, ret, this.connection, this.binaryData);
            }
        }
        catch (SQLException sqle) {
            this.clearBatch();
            throw new BatchUpdateException(sqle.getMessage(), sqle.getSQLState(), sqle.getErrorCode(), Arrays.copyOf(ret, counter), (Throwable)sqle);
        }
        finally {
            this.connection.lock.unlock();
            this.clearBatch();
        }
        this.batchResultSet = rs;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeInternal(ParameterHolder[] parameters, MariaDbType[] parameterTypeHeader) throws SQLException {
        this.executing = true;
        QueryException exception = null;
        this.executeQueryProlog();
        try {
            this.batchResultSet = null;
            this.queryResult = this.protocol.executePreparedQuery(this.sql, parameters, this.prepareResult, parameterTypeHeader, this.isStreaming());
            if (this.queryResult.getFailureObject() != null) {
                this.prepareResult = this.queryResult.getFailureObject();
            }
            this.cacheMoreResults();
            boolean bl = this.queryResult.getResultSetType() == ResultSetType.SELECT;
            return bl;
        }
        catch (QueryException e) {
            exception = e;
            boolean bl = false;
            return bl;
        }
        finally {
            this.executeQueryEpilog(exception, this.sql);
            this.executing = false;
        }
    }

    private void executeQueryEpilog(QueryException exception, String sql) throws SQLException {
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
        if (this.isTimedout) {
            this.isTimedout = false;
            exception = new QueryException("Query timed out", 1317, "JZ0002", exception);
        }
        if (exception == null) {
            return;
        }
        if (this.protocol.getOptions().dumpQueriesOnException || exception.getErrorCode() == 1064) {
            String queryString = new String(sql);
            if (queryString.length() > 4096) {
                queryString = queryString.substring(0, 4096);
            }
            exception.setMessage(exception.getMessage() + "\nQuery is:\n" + queryString);
        }
        if (exception.getSqlState() != null && exception.getSqlState().startsWith("08")) {
            this.close();
        }
        ExceptionMapper.throwException(exception, this.connection, this);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.execute();
        return this.getResultSet();
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.execute();
        return this.getUpdateCount();
    }

    @Override
    public void clearParameters() throws SQLException {
        this.currentParameterHolder = new ParameterHolder[this.prepareResult.parameters.length];
    }

    @Override
    public boolean execute() throws SQLException {
        this.isClosed();
        for (int i = 0; i < this.parameterCount; ++i) {
            if (this.currentParameterHolder[i] != null) continue;
            ExceptionMapper.throwException(new QueryException("Parameter at position " + (i + 1) + " is not set", -1, "07004"), this.connection, this);
        }
        MariaDbResultSet rs = null;
        boolean result = false;
        this.connection.lock.lock();
        try {
            result = this.executeInternal(this.currentParameterHolder, new MariaDbType[this.parameterCount]);
            if (this.autoGeneratedKeys) {
                rs = (MariaDbResultSet)this.getInternalGeneratedKeys();
            }
        }
        catch (SQLException sqle) {
            throw new BatchUpdateException(sqle.getMessage(), sqle.getSQLState(), sqle.getErrorCode(), new int[]{0}, (Throwable)sqle);
        }
        finally {
            this.connection.lock.unlock();
            this.clearBatch();
        }
        this.batchResultSet = rs;
        return result;
    }

    @Override
    public void close() throws SQLException {
        if (this.queryResult != null) {
            this.queryResult.close();
            this.queryResult = null;
        }
        this.cachedResultSets.clear();
        if (this.protocol.isConnected()) {
            try {
                this.protocol.releasePrepareStatement(this.sql, this.prepareResult.statementId);
            }
            catch (QueryException queryException) {
                // empty catch block
            }
        }
        if (this.isStreaming()) {
            this.connection.lock.lock();
            try {
                while (this.getInternalMoreResults(true)) {
                }
            }
            finally {
                this.connection.lock.unlock();
            }
        }
        super.close();
        this.isClosed = true;
        if (this.connection == null || this.connection.pooledConnection == null || this.connection.pooledConnection.statementEventListeners.isEmpty()) {
            return;
        }
        this.connection.pooledConnection.fireStatementClosed(this);
        this.connection = null;
        this.protocol = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("sql : '" + this.sql + "'");
        if (this.parameterCount > 0) {
            sb.append(", parameters : [");
            for (int i = 0; i < this.parameterCount; ++i) {
                if (this.currentParameterHolder[i] == null) {
                    sb.append("null");
                } else {
                    sb.append(this.currentParameterHolder[i].toString());
                }
                if (i == this.parameterCount - 1) continue;
                sb.append(",");
            }
            sb.append("]");
        }
        return sb.toString();
    }
}

