/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.protocol;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.UrlParser;
import org.mariadb.jdbc.internal.failover.FailoverProxy;
import org.mariadb.jdbc.internal.failover.Listener;
import org.mariadb.jdbc.internal.failover.tools.SearchFilter;
import org.mariadb.jdbc.internal.protocol.AbstractQueryProtocol;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class MasterProtocol
extends AbstractQueryProtocol {
    public MasterProtocol(UrlParser urlParser, ReentrantLock lock) {
        super(urlParser, lock);
    }

    public static MasterProtocol getNewProtocol(FailoverProxy proxy, UrlParser urlParser) {
        MasterProtocol newProtocol = new MasterProtocol(urlParser, proxy.lock);
        newProtocol.setProxy(proxy);
        return newProtocol;
    }

    public static void loop(Listener listener, List<HostAddress> addresses, Map<HostAddress, Long> blacklist, SearchFilter searchFilter) throws QueryException {
        LinkedList<HostAddress> loopAddresses = new LinkedList<HostAddress>(addresses);
        QueryException lastQueryException = null;
        for (int maxConnectionTry = listener.getRetriesAllDown(); !loopAddresses.isEmpty() || !searchFilter.isUniqueLoop() && maxConnectionTry > 0; --maxConnectionTry) {
            MasterProtocol protocol = MasterProtocol.getNewProtocol(listener.getProxy(), listener.getUrlParser());
            if (listener.isExplicitClosed()) {
                return;
            }
            try {
                protocol.setHostAddress((HostAddress)loopAddresses.get(0));
                loopAddresses.remove(0);
                protocol.connect();
                blacklist.remove(protocol.getHostAddress());
                listener.foundActiveMaster(protocol);
                return;
            }
            catch (QueryException e) {
                blacklist.put(protocol.getHostAddress(), System.currentTimeMillis());
                lastQueryException = e;
                if (!loopAddresses.isEmpty() || searchFilter.isUniqueLoop() || maxConnectionTry <= 0) continue;
                loopAddresses = new LinkedList<HostAddress>(addresses);
                continue;
            }
        }
        if (lastQueryException != null) {
            throw new QueryException("No active connection found for master : " + lastQueryException.getMessage(), lastQueryException.getErrorCode(), lastQueryException.getSqlState(), lastQueryException);
        }
        throw new QueryException("No active connection found for master");
    }
}

