/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import org.mariadb.jdbc.AbstractMariaDbPrepareStatement;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.MariaDbServerPreparedStatement;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.query.MariaDbClientParameterizeQuery;
import org.mariadb.jdbc.internal.util.Utils;

public class MariaDbClientPreparedStatement
extends AbstractMariaDbPrepareStatement {
    private final String sqlQuery;
    boolean parametersCleared;
    private MariaDbClientParameterizeQuery query;
    private ResultSetMetaData resultSetMetaData = null;
    private ParameterMetaData parameterMetaData = null;

    public MariaDbClientPreparedStatement(MariaDbConnection connection, String sql, int autoGeneratedKeys) throws SQLException {
        super(connection, autoGeneratedKeys);
        if (this.protocol.getOptions().rewriteBatchedStatements || this.protocol.getOptions().allowMultiQueries) {
            this.sqlQuery = deleteEndSemicolonPattern.matcher(sql).replaceAll("");
            this.isInsertRewriteable(this.sqlQuery);
        } else {
            this.sqlQuery = sql;
        }
        this.useFractionalSeconds = connection.getProtocol().getOptions().useFractionalSeconds;
        this.query = new MariaDbClientParameterizeQuery(Utils.nativeSql(this.sqlQuery, connection.noBackslashEscapes), connection.noBackslashEscapes, this.isRewriteable && this.firstRewrite != null ? this.firstRewrite.length() : -1);
        this.parametersCleared = true;
    }

    @Override
    protected boolean isNoBackslashEscapes() {
        return this.connection.noBackslashEscapes;
    }

    @Override
    protected boolean useFractionalSeconds() {
        return this.useFractionalSeconds;
    }

    @Override
    protected Calendar cal() {
        return this.protocol.getCalendar();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return this.executeQuery(this.query);
    }

    @Override
    public boolean execute() throws SQLException {
        return this.execute(this.query);
    }

    @Override
    public int executeUpdate() throws SQLException {
        return this.executeUpdate(this.query);
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkBatchFields();
        this.batchQueries.add(this.query.cloneQuery());
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SQLException("Cannot do addBatch(String) on preparedStatement");
    }

    private void checkBatchFields() {
        if (this.batchQueries == null) {
            this.batchQueries = new ArrayList();
        }
    }

    @Override
    public void clearBatch() {
        if (this.batchQueries != null) {
            this.batchQueries.clear();
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClose();
        ResultSet rs = this.getResultSet();
        if (rs != null) {
            return rs.getMetaData();
        }
        if (this.resultSetMetaData == null) {
            MariaDbServerPreparedStatement ssps = new MariaDbServerPreparedStatement(this.connection, this.sqlQuery, 2);
            ssps.close();
            this.resultSetMetaData = ssps.getMetaData();
            this.parameterMetaData = ssps.getParameterMetaData();
        }
        return this.resultSetMetaData;
    }

    @Override
    protected void setParameter(int parameterIndex, ParameterHolder holder) throws SQLException {
        this.query.setParameter(parameterIndex - 1, holder);
        this.parametersCleared = false;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkClose();
        if (this.parameterMetaData == null) {
            MariaDbServerPreparedStatement ssps = new MariaDbServerPreparedStatement(this.connection, this.sqlQuery, 2);
            ssps.close();
            this.resultSetMetaData = ssps.getMetaData();
            this.parameterMetaData = ssps.getParameterMetaData();
        }
        return this.parameterMetaData;
    }

    @Override
    public void clearParameters() {
        this.query.clearParameters();
        this.parametersCleared = true;
    }

    @Override
    public void close() throws SQLException {
        this.isClosed();
        super.close();
        if (this.connection == null || this.connection.pooledConnection == null || this.connection.pooledConnection.statementEventListeners.isEmpty()) {
            return;
        }
    }

    public String toString() {
        return this.query.toString();
    }
}

