/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.common.query.parameters;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.util.Calendar;
import org.mariadb.jdbc.internal.common.Options;
import org.mariadb.jdbc.internal.common.packet.PacketOutputStream;
import org.mariadb.jdbc.internal.common.query.parameters.NotLongDataParameterHolder;
import org.mariadb.jdbc.internal.common.query.parameters.ParameterWriter;
import org.mariadb.jdbc.internal.mysql.MySQLType;

public class TimestampParameter
extends NotLongDataParameterHolder {
    Timestamp ts;
    Calendar calendar;
    boolean fractionalSeconds;
    Options options;

    public TimestampParameter(Timestamp ts, Calendar cal, boolean fractionalSeconds, Options options) {
        this.ts = ts;
        this.calendar = cal;
        this.fractionalSeconds = fractionalSeconds;
        this.options = options;
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        ParameterWriter.writeTimestamp(os, this.ts, this.calendar, this.fractionalSeconds);
    }

    @Override
    public void writeBinary(PacketOutputStream writeBuffer) {
        if (this.options.useLegacyDatetimeCode) {
            this.calendar = Calendar.getInstance();
        }
        this.calendar.setTimeInMillis(this.ts.getTime());
        writeBuffer.writeTimestampLength(this.calendar, this.ts);
    }

    @Override
    public MySQLType getMySQLType() {
        return MySQLType.DATETIME;
    }
}

