/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.mysql;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.UUID;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.mariadb.jdbc.internal.common.Options;

class MyX509TrustManager
implements X509TrustManager {
    String serverCertFile;
    X509TrustManager trustManager;

    public MyX509TrustManager(Options options) throws Exception {
        InputStream inStream;
        boolean trustServerCertificate = options.trustServerCertificate;
        if (trustServerCertificate) {
            return;
        }
        this.serverCertFile = options.serverSslCert;
        if (this.serverCertFile.startsWith("-----BEGIN CERTIFICATE-----")) {
            inStream = new ByteArrayInputStream(this.serverCertFile.getBytes());
        } else if (this.serverCertFile.startsWith("classpath:")) {
            String classpathFile = this.serverCertFile.substring("classpath:".length());
            inStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(classpathFile);
        } else {
            inStream = new FileInputStream(this.serverCertFile);
        }
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        Collection<? extends Certificate> caList = cf.generateCertificates(inStream);
        ((InputStream)inStream).close();
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        try {
            ks.load(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Certificate certificate : caList) {
            ks.setCertificateEntry(UUID.randomUUID().toString(), certificate);
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ks);
        for (TrustManager tm : tmf.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            this.trustManager = (X509TrustManager)tm;
            break;
        }
        if (this.trustManager == null) {
            throw new RuntimeException("No X509TrustManager found");
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        if (this.trustManager == null) {
            return;
        }
        this.trustManager.checkServerTrusted(x509Certificates, s);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return null;
    }
}

