/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import org.mariadb.jdbc.JDBCUrl;
import org.mariadb.jdbc.MySQLConnection;
import org.mariadb.jdbc.MySQLStatement;
import org.mariadb.jdbc.internal.SQLExceptionMapper;
import org.mariadb.jdbc.internal.common.QueryException;
import org.mariadb.jdbc.internal.common.Utils;
import org.mariadb.jdbc.internal.mysql.Protocol;

public final class Driver
implements java.sql.Driver {
    public static void unloadDriver() {
        MySQLStatement.unloadDriver();
    }

    @Override
    public Connection connect(String url, Properties props) throws SQLException {
        try {
            JDBCUrl jdbcUrl = JDBCUrl.parse(url, props);
            if (jdbcUrl == null) {
                return null;
            }
            if (jdbcUrl.getHostAddresses() == null) {
                return null;
            }
            ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
            Protocol protocol = Utils.retrieveProxy(jdbcUrl, lock);
            return MySQLConnection.newConnection(protocol, lock);
        }
        catch (QueryException e) {
            SQLExceptionMapper.throwException(e, null, null);
            return null;
        }
    }

    @Override
    public boolean acceptsURL(String url) {
        return JDBCUrl.acceptsURL(url);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 3;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not register driver", e);
        }
    }
}

