/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.mysql;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.JDBCUrl;
import org.mariadb.jdbc.internal.SQLExceptionMapper;
import org.mariadb.jdbc.internal.common.QueryException;
import org.mariadb.jdbc.internal.common.query.MySQLQuery;
import org.mariadb.jdbc.internal.common.queryresults.SelectQueryResult;
import org.mariadb.jdbc.internal.mysql.FailoverProxy;
import org.mariadb.jdbc.internal.mysql.MastersSlavesProtocol;
import org.mariadb.jdbc.internal.mysql.listener.impl.AuroraListener;
import org.mariadb.jdbc.internal.mysql.listener.tools.SearchFilter;

public class AuroraProtocol
extends MastersSlavesProtocol {
    public AuroraProtocol(JDBCUrl url, ReentrantReadWriteLock lock) {
        super(url, lock);
    }

    @Override
    public boolean isMasterConnection() {
        return this.masterConnection;
    }

    @Override
    public boolean checkIfMaster() throws QueryException {
        this.proxy.lock.writeLock().lock();
        try {
            SelectQueryResult queryResult = (SelectQueryResult)this.executeQuery(new MySQLQuery("show global variables like 'innodb_read_only'"));
            if (queryResult != null) {
                queryResult.next();
                this.masterConnection = "OFF".equals(queryResult.getValueObject(1).getString());
            } else {
                this.masterConnection = false;
            }
            this.readOnly = !this.masterConnection;
            boolean bl = this.masterConnection;
            return bl;
        }
        catch (IOException ioe) {
            throw new QueryException("could not check the 'innodb_read_only' variable status on " + this.getHostAddress() + " : " + ioe.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), ioe);
        }
        finally {
            this.proxy.lock.writeLock().unlock();
        }
    }

    public static void searchProbableMaster(AuroraListener listener, HostAddress probableMaster, Map<HostAddress, Long> blacklist, SearchFilter searchFilter) throws QueryException {
        AuroraProtocol protocol = AuroraProtocol.getNewProtocol(listener.getProxy(), listener.getJdbcUrl());
        try {
            protocol.setHostAddress(probableMaster);
            protocol.connect();
            if (searchFilter.isSearchForMaster() && protocol.isMasterConnection()) {
                searchFilter.setSearchForMaster(false);
                protocol.setMustBeMasterConnection(true);
                listener.foundActiveMaster(protocol);
            } else if (searchFilter.isSearchForSlave() && !protocol.isMasterConnection()) {
                searchFilter.setSearchForSlave(false);
                protocol.setMustBeMasterConnection(false);
                listener.foundActiveSecondary(protocol);
            } else {
                protocol.close();
                protocol = AuroraProtocol.getNewProtocol(listener.getProxy(), listener.getJdbcUrl());
            }
        }
        catch (QueryException e) {
            blacklist.put(protocol.getHostAddress(), System.currentTimeMillis());
        }
    }

    public static void loop(AuroraListener listener, List<HostAddress> addresses, Map<HostAddress, Long> blacklist, SearchFilter searchFilter) throws QueryException {
        LinkedList<HostAddress> loopAddresses = new LinkedList<HostAddress>(addresses);
        int maxConnectionTry = listener.getRetriesAllDown();
        QueryException lastQueryException = null;
        while (!loopAddresses.isEmpty() || !searchFilter.isUniqueLoop() && maxConnectionTry > 0) {
            AuroraProtocol protocol = AuroraProtocol.getNewProtocol(listener.getProxy(), listener.getJdbcUrl());
            if (listener.isExplicitClosed() || !listener.isSecondaryHostFail() && !listener.isMasterHostFail()) {
                return;
            }
            --maxConnectionTry;
            try {
                protocol.setHostAddress((HostAddress)loopAddresses.get(0));
                loopAddresses.remove(0);
                protocol.connect();
                blacklist.remove(protocol.getHostAddress());
                if (searchFilter.isSearchForMaster() && protocol.isMasterConnection()) {
                    if (AuroraProtocol.foundMaster(listener, protocol, searchFilter)) {
                        return;
                    }
                } else if (searchFilter.isSearchForSlave() && !protocol.isMasterConnection()) {
                    if (AuroraProtocol.foundSecondary(listener, protocol, searchFilter)) {
                        return;
                    }
                    HostAddress probableMasterHost = listener.searchByStartName(protocol, listener.getJdbcUrl().getHostAddresses());
                    if (probableMasterHost != null) {
                        loopAddresses.remove(probableMasterHost);
                        AuroraProtocol.searchProbableMaster(listener, probableMasterHost, blacklist, searchFilter);
                        if (!searchFilter.isSearchForMaster()) {
                            return;
                        }
                    }
                } else {
                    protocol.close();
                }
            }
            catch (QueryException e) {
                lastQueryException = e;
                blacklist.put(protocol.getHostAddress(), System.currentTimeMillis());
            }
            if (!searchFilter.isSearchForMaster() && !searchFilter.isSearchForSlave()) {
                return;
            }
            if (!loopAddresses.isEmpty() || searchFilter.isUniqueLoop() || maxConnectionTry <= 0) continue;
            loopAddresses = new LinkedList<HostAddress>(addresses);
            listener.checkIfTypeHaveChanged(searchFilter);
        }
        if (searchFilter.isSearchForMaster() || searchFilter.isSearchForSlave()) {
            String error = "No active connection found for replica";
            if (searchFilter.isSearchForMaster()) {
                error = "No active connection found for master";
            }
            if (lastQueryException != null) {
                throw new QueryException(error, lastQueryException.getErrorCode(), lastQueryException.getSqlState(), lastQueryException);
            }
            throw new QueryException(error);
        }
    }

    private static boolean foundMaster(AuroraListener listener, AuroraProtocol protocol, SearchFilter searchFilter) {
        protocol.setMustBeMasterConnection(true);
        searchFilter.setSearchForMaster(false);
        listener.foundActiveMaster(protocol);
        if (!searchFilter.isSearchForSlave()) {
            return true;
        }
        return listener.isExplicitClosed() || searchFilter.isFineIfFoundOnlyMaster() || !listener.isSecondaryHostFail();
    }

    private static boolean foundSecondary(AuroraListener listener, AuroraProtocol protocol, SearchFilter searchFilter) {
        searchFilter.setSearchForSlave(false);
        protocol.setMustBeMasterConnection(false);
        listener.foundActiveSecondary(protocol);
        if (!searchFilter.isSearchForMaster()) {
            return true;
        }
        return listener.isExplicitClosed() || searchFilter.isFineIfFoundOnlySlave() || !listener.isMasterHostFail();
    }

    public static AuroraProtocol getNewProtocol(FailoverProxy proxy, JDBCUrl jdbcUrl) {
        AuroraProtocol newProtocol = new AuroraProtocol(jdbcUrl, proxy.lock);
        newProtocol.setProxy(proxy);
        return newProtocol;
    }
}

